/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.dialogs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseDialog;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.ToolView;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class Lti13DynamicRegistrationDialog
extends BaseDialog {
    private static final Logger logger = LoggerFactory.getLogger(Lti13DynamicRegistrationDialog.class);
    private static final String MSG_KEY_DIALOGNAME = "Lti13DynamicRegistrationDialog.";
    private final MainAppLayout mainLayoutUI;
    private final I18nService i18nService;
    private static final Pattern HTTP_PATTERN = Pattern.compile("(bolt:|http:|https:)\\/\\/?[\\d\\w\\-\\.]{1,}(\\:[\\d]{2,5}|){0,1}(\\/\\S*){0,1}");
    private TextField dynamicUrlTF;
    private String startRegistrationUrl;
    private Anchor dynRegUrlAnchor = new Anchor();
    private VerticalLayout vLayout = new VerticalLayout();
    private HorizontalLayout buttonLayout = null;

    public Lti13DynamicRegistrationDialog(MainAppLayout mainLayoutUI, ToolView toolView, String startRegistrationUrl) {
        this.mainLayoutUI = mainLayoutUI;
        this.i18nService = I18nService.getInstance();
        this.startRegistrationUrl = startRegistrationUrl;
        this.initLayout();
    }

    private void initLayout() {
        logger.debug("start loginInit");
        this.setCloseOnOutsideClick(false);
        this.setCloseOnEsc(false);
        this.removeAll();
        Button closeButton = new Button(this.i18nService.getTranslation("Lti13DynamicRegistrationDialog.button.close", this.getLocale(), new Object[0]));
        closeButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.closeThis());
        String label = this.i18nService.getTranslation("Lti13DynamicRegistrationDialog.label.dynRegUrl", this.getLocale(), new Object[0]);
        String placeHolder = this.i18nService.getTranslation("Lti13DynamicRegistrationDialog.label.dynRegUrlPlaceHolder", this.getLocale(), new Object[0]);
        this.dynamicUrlTF = new TextField(label, placeHolder);
        this.dynamicUrlTF.setWidth("50%");
        this.dynamicUrlTF.addValueChangeListener((HasValue.ValueChangeListener & Serializable)x -> this.startDynRegistration());
        this.buttonLayout = new HorizontalLayout();
        this.buttonLayout.add(new Component[]{closeButton});
        this.buttonLayout.setWidthFull();
        this.buttonLayout.setAlignItems(FlexComponent.Alignment.BASELINE);
        this.dynamicUrlTF.setValue(this.startRegistrationUrl);
        this.vLayout = new VerticalLayout();
        this.createNewDialogVerticalLayout();
        this.add(new Component[]{this.vLayout});
        logger.debug("Ende intoLayout");
        this.setWidth("100%");
    }

    private void createNewDialogVerticalLayout() {
        this.vLayout.removeAll();
        Div div = new Div();
        div.add(new Component[]{this.dynRegUrlAnchor});
        this.dynRegUrlAnchor.setText(this.i18nService.getTranslation("Lti13DynamicRegistrationDialog.msg.startDynReg", this.getLocale(), new Object[0]));
        this.vLayout.setWidthFull();
        this.vLayout.add(new Component[]{this.dynamicUrlTF});
        this.vLayout.add(new Component[]{div});
        this.vLayout.add(new Component[]{this.buttonLayout});
    }

    private void startDynRegistration() {
        this.dynRegUrlAnchor.setHref(this.startRegistrationUrl);
        this.dynRegUrlAnchor.setText(this.i18nService.getTranslation("Lti13DynamicRegistrationDialog.msg.startDynReg", this.getLocale(), new Object[0]));
        this.dynRegUrlAnchor.setTarget("_myWindow");
        String toolId = UUID.randomUUID().toString();
        String url = this.mainLayoutUI.getHostUri() + "platformapi/v1/lti13/registerStart";
        if (!HTTP_PATTERN.matcher(this.dynamicUrlTF.getValue()).matches()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("Lti13DynamicRegistrationDialog.msg.noUrl", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            return;
        }
        Map<String, String> parameter = Map.of("toolRegisterUrl", this.dynamicUrlTF.getValue(), "toolId", toolId, "schoolId", this.mainLayoutUI.getSchool().getSchoolId());
        UriComponents callUri = UriComponentsBuilder.newInstance().path(url).buildAndExpand(parameter);
        StringBuilder sb = new StringBuilder(url);
        sb.append("?toolRegistrationUrl=").append(this.dynamicUrlTF.getValue()).append("&toolId=").append(toolId).append("&schoolId=").append(this.mainLayoutUI.getSchoolId());
        this.dynRegUrlAnchor.setHref(sb.toString());
        logger.info("call Url for registerStartForm {}", (Object)sb);
        this.createNewDialogVerticalLayout();
    }

    private void closeThis() {
        this.close();
    }

    @Value(value="${dynreg.starturl}")
    public void setStartRegistrationUrl(String startRegistrationUrl) {
        this.startRegistrationUrl = startRegistrationUrl;
    }
}

