/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.dialogs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.component.upload.UploadI18N;
import com.vaadin.flow.component.upload.receivers.MemoryBuffer;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.server.Command;
import de.mahlsdorf.groupservice.model.node.Course;
import de.mahlsdorf.groupservice.model.node.Task;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.groupservice.Task2ToolAssignerService;
import de.mahlsdorf.groupservice.service.lti13.TccConverterService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseDialog;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.TaskView;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lti13TccUploadDialog
extends BaseDialog {
    public static final String NL = "\n";
    public static final String DESCRIPTION = "Description";
    private static final String MSG_KEY_DIALOGNAME = "Lti13TccUploadDialog.";
    public static final String NAME = "Name";
    public static final String URL = "Url";
    private static final Logger logger = LoggerFactory.getLogger(Lti13TccUploadDialog.class);
    public static final String STRUCTURE = "Structure";
    public static final String MAX_POINTS = "max. Points";
    private final MainAppLayout mainLayoutUI;
    private final TaskView taskView;
    private final Course course;
    private final TccConverterService tccConverter;
    private Grid<Task> grid;
    private Button saveButton;
    private Button cancelButton;
    private TextArea messageTextArea;
    private List<Task> convertedTasks;
    private final Task2ToolAssignerService task2ToolAssigner;
    private final I18nService i18nService;
    private final HorizontalLayout buttonLayout = new HorizontalLayout();

    public Lti13TccUploadDialog(MainAppLayout mainLayoutUI, TaskView taskView, TccConverterService tccConverter, Course course, Task2ToolAssignerService task2ToolAssigner, Neo4JBaseService neo4JBaseService) {
        this.i18nService = I18nService.getInstance();
        this.mainLayoutUI = mainLayoutUI;
        this.taskView = taskView;
        this.tccConverter = tccConverter;
        this.course = course;
        this.task2ToolAssigner = task2ToolAssigner;
        this.initLayout();
    }

    private void initLayout() {
        this.setCloseOnOutsideClick(false);
        VerticalLayout vLayout = new VerticalLayout();
        this.setWidth(100.0f, Unit.PERCENTAGE);
        this.grid = new Grid();
        this.grid.setWidth("100%");
        vLayout.add(new Component[]{this.grid});
        String gridheaderStructure = this.i18nService.getTranslation("Lti13TccUploadDialog.gridheader.structure", this.getLocale(), new Object[0]);
        String gridheaderName = this.i18nService.getTranslation("Lti13TccUploadDialog.gridheader.name", this.getLocale(), new Object[0]);
        String gridheaderDescription = this.i18nService.getTranslation("Lti13TccUploadDialog.gridheader.description", this.getLocale(), new Object[0]);
        String gridheaderUrl = this.i18nService.getTranslation("Lti13TccUploadDialog.gridheader.url", this.getLocale(), new Object[0]);
        String gridheadermaxPoints = this.i18nService.getTranslation("Lti13TccUploadDialog.gridheader.maxPoints", this.getLocale(), new Object[0]);
        this.grid.addColumn(Task::getStructure).setHeader(gridheaderStructure).setKey(STRUCTURE).setSortable(true).setResizable(true);
        this.grid.addColumn(Task::getName).setHeader(gridheaderName).setSortable(true).setResizable(true);
        this.grid.addColumn(Task::getDescription).setHeader(gridheaderDescription).setSortable(true).setResizable(true);
        this.grid.addColumn(Task::getUrl).setHeader(gridheaderUrl).setSortable(true).setResizable(true);
        this.grid.addColumn(Task::getLtiLineItemMaxPoints).setHeader(gridheadermaxPoints).setSortable(true).setResizable(true);
        this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.saveButton = new Button(this.i18nService.getTranslation("Lti13TccUploadDialog.button.save", this.getLocale(), new Object[0]));
        this.saveButton.addClickListener((ComponentEventListener & Serializable)event -> this.save());
        this.saveButton.setEnabled(false);
        this.cancelButton = new Button(this.i18nService.getTranslation("Lti13TccUploadDialog.button.cancel", this.getLocale(), new Object[0]));
        this.cancelButton.addClickListener((ComponentEventListener & Serializable)event -> this.cancel());
        this.grid.addSelectionListener((SelectionListener & Serializable)x -> this.saveButton.setEnabled(!this.grid.getSelectedItems().isEmpty()));
        HorizontalLayout buttonLayoutIntern = new HorizontalLayout();
        buttonLayoutIntern.add(new Component[]{this.saveButton, this.cancelButton});
        MemoryBuffer receiver = new MemoryBuffer();
        Upload upload = new Upload((Receiver)receiver);
        upload.setWidth("10em");
        upload.setVisible(true);
        upload.setAcceptedFileTypes(new String[]{"application/gzip", ".imscc"});
        UploadI18N i18n = new UploadI18N();
        UploadI18N.AddFiles addFiles = new UploadI18N.AddFiles();
        UploadI18N.DropFiles dropFiles = new UploadI18N.DropFiles();
        UploadI18N.Error error = new UploadI18N.Error();
        i18n.setAddFiles(addFiles);
        i18n.setDropFiles(dropFiles);
        i18n.setError(error);
        i18n.getAddFiles().setOne("Upload imscc...");
        i18n.getDropFiles().setOne("Drop imscc");
        i18n.getError().setIncorrectFileType(this.i18nService.getTranslation("Lti13TccUploadDialog.msg.onlyImsccAllowed", this.getLocale(), new Object[0]));
        upload.setAutoUpload(true);
        upload.setDropAllowed(false);
        upload.addSucceededListener((ComponentEventListener & Serializable)event -> {
            InputStream inputStream = receiver.getInputStream();
            try {
                StringBuilder errorSB = new StringBuilder();
                this.convertedTasks = this.tccConverter.readTccAndExtractTask(inputStream);
                this.setToolIdByToolUrl(this.convertedTasks, errorSB);
                if (!errorSB.isEmpty()) {
                    this.messageTextArea.setValue(this.i18nService.getTranslation("Lti13TccUploadDialog.msg.errorsDuringImport", this.getLocale(), new Object[]{errorSB}));
                    return;
                }
                this.grid.setItems((Collection)this.convertedTasks);
                Grid.Column sortCol = this.grid.getColumnByKey(STRUCTURE);
                GridSortOrder order = new GridSortOrder(sortCol, SortDirection.ASCENDING);
                this.grid.sort(Collections.singletonList(order));
            }
            catch (Exception e) {
                logger.error("Exception while Importing TCC ", (Throwable)e);
                this.showNotificationMiddle(e.getMessage(), 3000);
            }
        });
        this.buttonLayout.removeAll();
        this.buttonLayout.add(new Component[]{this.saveButton, this.cancelButton, upload});
        this.messageTextArea = new TextArea(this.i18nService.getTranslation("Lti13TccUploadDialog.label.messages", this.getLocale(), new Object[0]));
        this.messageTextArea.setHeight("10em");
        this.messageTextArea.setWidthFull();
        vLayout.add(new Component[]{this.messageTextArea, this.buttonLayout});
        this.add(new Component[]{vLayout});
    }

    private void setToolIdByToolUrl(List<Task> convertedTasks, StringBuilder errorSb) {
        this.task2ToolAssigner.assignTasksToToolId(convertedTasks, this.mainLayoutUI.getSchoolId(), errorSb, this.getLocale());
    }

    private void save() {
        try {
            Div spinnerDiv = BaseView.createSpinnerDiv((Locale)this.getLocale());
            this.buttonLayout.removeAll();
            UI.getCurrent().access((Command & Serializable)() -> this.buttonLayout.add(new Component[]{spinnerDiv}));
            UI.getCurrent().push();
            String result = this.tccConverter.insertTaskListIntoTheCourse(new ArrayList(this.grid.getSelectedItems()), this.course, this.getLocale());
            this.taskView.fillUpGridWithTasksForSelectedCourse();
            this.buttonLayout.removeAll();
            this.buttonLayout.add(new Component[]{this.cancelButton});
            UI.getCurrent().push();
            this.messageTextArea.setValue(result);
            this.saveButton.setEnabled(false);
        }
        catch (Exception e) {
            logger.error("Exception while saving tasks from tcc to Course {} ", (Object)this.course.getName(), (Object)e);
            this.showNotificationMiddle(this.i18nService.getTranslation("Lti13TccUploadDialog.msg.errorsDuringImport", this.getLocale(), new Object[]{e.getMessage()}), 2);
        }
    }

    private void cancel() {
        this.close();
    }
}

