/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.dialogs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.i18n.I18NProvider;
import de.mahlsdorf.groupservice.model.node.PersonIF;
import de.mahlsdorf.groupservice.model.node.Student;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.security.CryptDecryptHelper;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseDialog;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordChangeDialog
extends BaseDialog {
    private static final String MSG_KEY_VIEWNAME = "PasswordChangeDialog.";
    private static final String MSG_KEY_MESSAGE = "msg.";
    private static final Logger logger = LoggerFactory.getLogger(PasswordChangeDialog.class);
    private final MainAppLayout mainLayoutUI;
    private final I18NProvider i18nService;
    private final Neo4JBaseService neo4JBaseService;
    PersonIF person;
    private PasswordField passwordOldTF;
    private PasswordField passwordNew1TF;
    private PasswordField passwordNew2TF;
    private final Boolean withOldPassword;

    public PasswordChangeDialog(MainAppLayout mainLayoutUI, PersonIF person) {
        this(mainLayoutUI, person, false);
    }

    public PasswordChangeDialog(MainAppLayout mainLayoutUI, PersonIF person, boolean withOldPassword) {
        this.mainLayoutUI = mainLayoutUI;
        this.i18nService = mainLayoutUI.getI18nService();
        this.neo4JBaseService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        this.person = person;
        this.withOldPassword = withOldPassword;
        this.initLayout();
    }

    private void initLayout() {
        VerticalLayout vlayout = new VerticalLayout();
        this.passwordOldTF = new PasswordField(this.i18nService.getTranslation("PasswordChangeDialog.label.passwordOldTF", this.getLocale(), new Object[0]));
        this.passwordNew1TF = new PasswordField(this.i18nService.getTranslation("PasswordChangeDialog.label.passwordNew1TF", this.getLocale(), new Object[0]));
        this.passwordNew2TF = new PasswordField(this.i18nService.getTranslation("PasswordChangeDialog.label.passwordNew2TF", this.getLocale(), new Object[0]));
        Button save = new Button(this.i18nService.getTranslation("PasswordChangeDialog.button.save", this.getLocale(), new Object[0]));
        save.addClickListener((ComponentEventListener & Serializable)event -> this.checkPasswords());
        Button cancel = new Button(this.i18nService.getTranslation("PasswordChangeDialog.button.cancel", this.getLocale(), new Object[0]));
        cancel.addClickListener((ComponentEventListener & Serializable)event -> this.close());
        HorizontalLayout hLayoutButton = new HorizontalLayout(new Component[]{save, cancel});
        vlayout.add(new Component[]{this.passwordOldTF, this.passwordNew1TF, this.passwordNew2TF, hLayoutButton});
        this.add(new Component[]{vlayout});
        if (StringUtils.isEmpty((CharSequence)this.person.getPassword()) || !this.withOldPassword.booleanValue()) {
            vlayout.remove(new Component[]{this.passwordOldTF});
        }
    }

    private boolean checkPasswords() {
        try {
            if (!StringUtils.isEmpty((CharSequence)this.person.getPassword()) && this.withOldPassword.booleanValue()) {
                String oldPassword = CryptDecryptHelper.decrypt((String)this.person.getPassword());
                String tfValue = this.passwordOldTF.getValue();
                if (StringUtils.isEmpty((CharSequence)tfValue) || !oldPassword.equals(this.passwordOldTF.getValue())) {
                    this.showNotificationMiddle(this.i18nService.getTranslation("PasswordChangeDialog.msg.oldPasswordWrong", this.getLocale(), new Object[0]), 3);
                    return false;
                }
            }
            if (!this.passwordNew1TF.getValue().equals(this.passwordNew2TF.getValue())) {
                this.showNotificationMiddle(this.i18nService.getTranslation("PasswordChangeDialog.msg.newPasswordsDifferent", this.getLocale(), new Object[0]), 3);
                return false;
            }
            this.person.setPassword(CryptDecryptHelper.cryptString((String)this.passwordNew1TF.getValue()));
            if (this.person instanceof Teacher) {
                this.neo4JBaseService.saveTeacher((Teacher)this.person);
            }
            if (this.person instanceof Student) {
                this.neo4JBaseService.saveStudent((Student)this.person);
            }
            this.showNotificationMiddle(this.i18nService.getTranslation("PasswordChangeDialog.msg.passwordChanged", this.getLocale(), new Object[]{this.person.getFirstName(), this.person.getLastName()}), 3);
            this.close();
        }
        catch (Exception e) {
            this.showNotificationMiddle("Exception " + e.getMessage(), 2);
            return false;
        }
        return false;
    }
}

