/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.dialogs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.validator.EmailValidator;
import com.vaadin.flow.data.validator.RegexpValidator;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.node.PersonIF;
import de.mahlsdorf.groupservice.model.node.Student;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseDialog;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.AllStudentView;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudentDialog
extends BaseDialog {
    private static final Logger logger = LoggerFactory.getLogger(StudentDialog.class);
    private static final String MSG_KEY_DIALOGNAME = "StudentDialog.";
    private final MainAppLayout mainLayoutUI;
    private final String schoolNumber;
    private final AllStudentView studentView;
    private final Neo4JBaseService neo4JService;
    private final Binder<Student> binder = new Binder(Student.class);
    private Student student;
    private final Set<Student> studentSet;
    private TextField firstNameTF;
    private TextField lastNameTF;
    private TextField comment1TF;
    private TextField comment2TF;
    private TextField comment3TF;
    private TextField emailTF;
    private TextField loginNameTF;
    private Button saveButton;
    private Button cancelButton;
    private boolean isNew = false;
    private final I18nService i18nService;
    private Boolean isBulkUpdate = true;

    public StudentDialog(MainAppLayout mainLayoutUI, String schoolNumber, Set<Student> studentSet, AllStudentView allStudentView, boolean isBulkUpdate) {
        this.mainLayoutUI = mainLayoutUI;
        this.schoolNumber = schoolNumber;
        if (studentSet != null) {
            this.student = studentSet.size() > 0 ? studentSet.iterator().next() : new Student();
        }
        this.studentSet = studentSet;
        this.studentView = allStudentView;
        this.neo4JService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        this.i18nService = I18nService.getInstance();
        this.isBulkUpdate = isBulkUpdate;
        this.initLayout();
    }

    private void initLayout() {
        if (this.student == null) {
            this.student = new Student();
            this.isNew = true;
        }
        this.setCloseOnOutsideClick(false);
        FormLayout formLayout = new FormLayout();
        if (!this.isBulkUpdate.booleanValue()) {
            String givenName = this.i18nService.getTranslation("StudentDialog.label.givenName", this.getLocale(), new Object[0]);
            this.firstNameTF = new TextField(givenName);
            this.firstNameTF.setPlaceholder(givenName);
            this.firstNameTF.setId("tfFirstNameId");
            String lastName = this.i18nService.getTranslation("StudentDialog.label.lastName", this.getLocale(), new Object[0]);
            this.lastNameTF = new TextField(lastName);
            this.lastNameTF.setId("tfLastNameId");
            this.lastNameTF.setPlaceholder(lastName);
            String email = this.i18nService.getTranslation("StudentDialog.label.email", this.getLocale(), new Object[0]);
            this.emailTF = new TextField(email);
            this.emailTF.setId("tfEmailId");
            String loginName = this.i18nService.getTranslation("StudentDialog.label.loginName", this.getLocale(), new Object[0]);
            this.loginNameTF = new TextField(loginName);
            this.loginNameTF.setId("tfLoginNameId");
        }
        String comment1 = this.i18nService.getTranslation("StudentDialog.label.comment1", this.getLocale(), new Object[0]);
        this.comment1TF = new TextField(comment1);
        this.comment1TF.setId("tfComment1Id");
        String comment2 = this.i18nService.getTranslation("StudentDialog.label.comment2", this.getLocale(), new Object[0]);
        this.comment2TF = new TextField(comment2);
        this.comment2TF.setId("tfComment2Id");
        String comment3 = this.i18nService.getTranslation("StudentDialog.label.comment3", this.getLocale(), new Object[0]);
        this.comment3TF = new TextField(comment3);
        this.comment3TF.setId("tfComment3Id");
        String min1Char = this.i18nService.getTranslation("StudentDialog.msg.min1Char", this.getLocale(), new Object[0]);
        if (!this.isBulkUpdate.booleanValue()) {
            formLayout.add(new Component[]{this.firstNameTF, this.lastNameTF, this.comment1TF, this.comment2TF, this.comment3TF, this.emailTF, this.loginNameTF});
        } else {
            formLayout.add(new Component[]{this.comment1TF, this.comment2TF, this.comment3TF});
        }
        if (!this.isBulkUpdate.booleanValue()) {
            this.binder.forField((HasValue)this.firstNameTF).withNullRepresentation((Object)"").withValidator((Validator)new RegexpValidator(min1Char, "[\\w\\\u00e4\\\u00f6\\\u00fc\\\u00c4\\\u00d6\\\u00dc]{1,}[\\w\\\u00e4\\\u00f6\\\u00fc\\\u00c4\\\u00d6\\\u00dc\\s.]{1,}")).bind("firstName");
            this.binder.forField((HasValue)this.lastNameTF).withNullRepresentation((Object)"").withValidator((Validator)new RegexpValidator(min1Char, "[\\w\\\u00e4\\\u00f6\\\u00fc\\\u00c4\\\u00d6\\\u00dc]{1,}[\\w\\\u00e4\\\u00f6\\\u00fc\\\u00c4\\\u00d6\\\u00dc\\s.]{1,}")).bind("lastName");
            String emailMessage = this.i18nService.getTranslation("StudentDialog.msg.mustBeAEmail", this.getLocale(), new Object[0]);
            this.binder.forField((HasValue)this.emailTF).withNullRepresentation((Object)"").asRequired(this.i18nService.getTranslation("StudentDialog.msg.required", this.getLocale(), new Object[0])).withValidator((Validator)new RegexpValidator(emailMessage, "[\\w\\.\\d]{1,}[@]{1}[\\w\\.\\d]{1,}")).withValidator((Validator)new EmailValidator(emailMessage)).bind("email");
            String loginNameMessage = this.i18nService.getTranslation("StudentDialog.msg.mustBeALoginName", this.getLocale(), new Object[0]);
            this.binder.forField((HasValue)this.loginNameTF).withNullRepresentation((Object)"").asRequired(this.i18nService.getTranslation("StudentDialog.msg.required", this.getLocale(), new Object[0])).withValidator((Validator)new RegexpValidator(loginNameMessage, "[\\w\\.\\d]{2,}")).bind("loginName");
        }
        this.binder.forField((HasValue)this.comment1TF).bind("comment1");
        this.binder.forField((HasValue)this.comment2TF).bind("comment2");
        this.binder.forField((HasValue)this.comment3TF).bind("comment3");
        this.saveButton = new Button(this.i18nService.getTranslation("StudentDialog.button.save", this.getLocale(), new Object[0]));
        this.saveButton.setId("BtnSaveId");
        this.saveButton.addClickListener((ComponentEventListener & Serializable)event -> this.save());
        this.cancelButton = new Button(this.i18nService.getTranslation("StudentDialog.button.cancel", this.getLocale(), new Object[0]));
        this.cancelButton.setId("BtnCancelId");
        this.cancelButton.addClickListener((ComponentEventListener & Serializable)event -> this.cancel());
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.add(new Component[]{this.saveButton, this.cancelButton});
        buttonLayout.setAlignItems(FlexComponent.Alignment.BASELINE);
        HorizontalLayout hlButtons = new HorizontalLayout();
        hlButtons.add(new Component[]{this.saveButton, this.cancelButton});
        formLayout.add(new Component[]{hlButtons});
        if (this.studentView == null) {
            this.comment1TF.setVisible(false);
            this.comment2TF.setVisible(false);
            this.comment3TF.setVisible(false);
        }
        if (this.isBulkUpdate.booleanValue()) {
            Span label = new Span(this.i18nService.getTranslation("StudentDialog.label.isBulkUpdate", this.getLocale(), new Object[0]));
            label.setClassName("background-red-without-margin");
            this.add(new Component[]{label});
            formLayout.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("500px", 1)});
        }
        this.add(new Component[]{formLayout});
        this.binder.readBean((Object)this.student);
    }

    private void save() {
        try {
            this.binder.writeBean((Object)this.student);
            this.binder.validate();
            if (StringUtils.isEmpty((CharSequence)this.student.getEmail())) {
                String emailMessage = this.i18nService.getTranslation("StudentDialog.msg.mustBeAEmail", this.getLocale(), new Object[0]);
                this.showNotificationMiddle(emailMessage, 2);
                return;
            }
            if (!this.binder.isValid()) {
                return;
            }
            logger.info("Bean before Save {} ", (Object)this.student);
            if (!this.isBulkUpdate.booleanValue()) {
                String studentId = this.student.getStudentId();
                if (this.student.getStudentId() == null) {
                    studentId = UUID.randomUUID().toString();
                    this.student.setStudentId(studentId);
                    this.isNew = true;
                }
                Student studentExists = this.neo4JService.getStudentByEmail(this.student);
                if (this.isNew && studentExists != null) {
                    String message = this.i18nService.getTranslation("StudentDialog.msg.emailExists", this.getLocale(), new Object[]{this.student.getEmail()});
                    this.showNotificationMiddle(message, ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
                    return;
                }
                Student studentExistsLoginName = this.neo4JService.findStudentByLoginName(this.student.getLoginName());
                if (this.isNew && studentExistsLoginName != null || studentExistsLoginName != null && !this.studentIdEquals(this.student, studentExistsLoginName)) {
                    String message = this.i18nService.getTranslation("StudentDialog.msg.loginNameExists", this.getLocale(), new Object[]{this.student.getLoginName()});
                    this.showNotificationMiddle(message, ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
                    return;
                }
                if (!this.isNew && studentExists != null && studentExists != null && !this.studentIdEquals(this.student, studentExists)) {
                    String message = this.i18nService.getTranslation("StudentDialog.msg.emailExists", this.getLocale(), new Object[]{this.student.getEmail()});
                    this.showNotificationMiddle(message, ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
                    return;
                }
                if (this.isNew) {
                    this.neo4JService.createStudent(this.student);
                    this.neo4JService.createRelPersonSchool(this.schoolNumber, (PersonIF)this.student, "Student", "StudentIn");
                } else {
                    this.neo4JService.saveStudent(this.student);
                }
                String message = this.i18nService.getTranslation("StudentDialog.msg.savedStudent", this.getLocale(), new Object[]{this.student.getFirstName(), this.student.getLastName()});
                this.showNotificationMiddle(message, ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            } else {
                HashSet studentIds = new HashSet();
                this.studentSet.forEach(it -> studentIds.add(it.getStudentId()));
                this.neo4JService.bulkUpdateStudents(studentIds, this.student);
                String message = this.i18nService.getTranslation("StudentDialog.msg.bulkSaveStudents", this.getLocale(), new Object[]{studentIds.size()});
                this.showNotificationMiddle(message, ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            }
            if (this.studentView != null) {
                this.studentView.fillUpTheGrid();
            }
            this.close();
        }
        catch (Exception e) {
            logger.error("Exception while saving student", (Throwable)e);
            String message = this.i18nService.getTranslation("StudentDialog.msg.exceptionSaveStudent", this.getLocale(), new Object[]{this.student.getFirstName(), this.student.getLastName(), e.getMessage()});
            this.showNotificationMiddle(message, 2);
        }
    }

    private boolean studentIdEquals(Student studentFromDialog, Student student2) {
        if (student2 == null) {
            return false;
        }
        return studentFromDialog.getStudentId().equals(student2.getStudentId());
    }

    private void cancel() {
        this.close();
    }
}

