/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.dialogs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.component.upload.UploadI18N;
import com.vaadin.flow.component.upload.receivers.MemoryBuffer;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.server.Command;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.node.Student;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.groupservice.StudentUploadService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseDialog;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.AllStudentView;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudentUploadDialog
extends BaseDialog {
    private static final Logger logger = LoggerFactory.getLogger(StudentUploadDialog.class);
    private static final String MSG_KEY_DIALOGNAME = "StudentUploadDialog.";
    private final MainAppLayout mainLayoutUI;
    private final String schoolNumber;
    private final AllStudentView allStudentView;
    private final Neo4JBaseService neo4JService;
    private final StudentUploadService studentUploadService;
    private Grid<Student> grid;
    private Button saveButton;
    private Button cancelButton;
    private Button infoButton;
    private TextArea errorTextArea;
    private final I18nService i18nService;
    private List allButtonList = new ArrayList();
    private HorizontalLayout buttonLayout;

    public StudentUploadDialog(MainAppLayout mainLayoutUI, String schoolNumber, StudentUploadService studentUploadService, AllStudentView allStudentView) {
        this.mainLayoutUI = mainLayoutUI;
        this.schoolNumber = schoolNumber;
        this.allStudentView = allStudentView;
        this.neo4JService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        this.studentUploadService = studentUploadService;
        this.i18nService = I18nService.getInstance();
        this.initLayout();
    }

    private void initLayout() {
        this.setCloseOnOutsideClick(false);
        VerticalLayout vLayout = new VerticalLayout();
        this.setWidth(100.0f, Unit.PERCENTAGE);
        this.grid = new Grid();
        this.grid.setWidth("100%");
        vLayout.add(new Component[]{this.grid});
        String gridheaderGivenName = this.i18nService.getTranslation("StudentUploadDialog.gridheader.givenName", this.getLocale(), new Object[0]);
        String gridheaderLastName = this.i18nService.getTranslation("StudentUploadDialog.gridheader.lastName", this.getLocale(), new Object[0]);
        String gridheaderEmail = this.i18nService.getTranslation("StudentUploadDialog.gridheader.email", this.getLocale(), new Object[0]);
        String gridheaderComment1 = this.i18nService.getTranslation("StudentUploadDialog.gridheader.comment1", this.getLocale(), new Object[0]);
        String gridheaderComment2 = this.i18nService.getTranslation("StudentUploadDialog.gridheader.comment2", this.getLocale(), new Object[0]);
        String gridheaderComment3 = this.i18nService.getTranslation("StudentUploadDialog.gridheader.comment3", this.getLocale(), new Object[0]);
        String gridheaderLoginName = this.i18nService.getTranslation("StudentUploadDialog.gridheader.loginName", this.getLocale(), new Object[0]);
        this.grid.addColumn(Student::getFirstName).setHeader(gridheaderGivenName).setSortable(true).setResizable(true);
        this.grid.addColumn(Student::getLastName).setHeader(gridheaderLastName).setSortable(true).setResizable(true);
        this.grid.addColumn(Student::getLoginName).setHeader(gridheaderLoginName).setSortable(true).setResizable(true);
        this.grid.addColumn(Student::getEmail).setHeader(gridheaderEmail).setSortable(true).setResizable(true);
        this.grid.addColumn(Student::getComment1).setHeader(gridheaderComment1).setSortable(true).setResizable(true);
        this.grid.addColumn(Student::getComment2).setHeader(gridheaderComment2).setSortable(true).setResizable(true);
        this.grid.addColumn(Student::getComment3).setHeader(gridheaderComment3).setSortable(true).setResizable(true);
        this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.grid.addSelectionListener((SelectionListener & Serializable)x -> this.saveButton.setEnabled(this.grid.getSelectedItems().size() > 0));
        this.errorTextArea = new TextArea();
        this.errorTextArea.setPlaceholder(this.i18nService.getTranslation("StudentUploadDialog.label.errorMessages", this.getLocale(), new Object[0]));
        this.errorTextArea.setWidthFull();
        this.errorTextArea.setHeight("20%");
        this.errorTextArea.setVisible(false);
        this.saveButton = new Button(this.i18nService.getTranslation("StudentUploadDialog.button.save", this.getLocale(), new Object[0]));
        this.saveButton.addClickListener((ComponentEventListener & Serializable)event -> this.save());
        this.saveButton.setEnabled(false);
        this.allButtonList.add(this.saveButton);
        this.cancelButton = new Button(this.i18nService.getTranslation("StudentUploadDialog.button.cancel", this.getLocale(), new Object[0]));
        this.cancelButton.addClickListener((ComponentEventListener & Serializable)event -> this.cancel());
        this.allButtonList.add(this.cancelButton);
        this.infoButton = new Button(this.i18nService.getTranslation("StudentUploadDialog.button.info", this.getLocale(), new Object[0]));
        this.infoButton.addClickListener((ComponentEventListener & Serializable)click -> this.showInfo());
        this.allButtonList.add(this.infoButton);
        MemoryBuffer receiver = new MemoryBuffer();
        Upload upload = new Upload((Receiver)receiver);
        upload.setWidth("10em");
        upload.setVisible(true);
        upload.setAcceptedFileTypes(new String[]{"application/csv", ".csv"});
        UploadI18N i18n = new UploadI18N();
        UploadI18N.AddFiles addFiles = new UploadI18N.AddFiles();
        UploadI18N.DropFiles dropFiles = new UploadI18N.DropFiles();
        UploadI18N.Error error = new UploadI18N.Error();
        i18n.setAddFiles(addFiles);
        i18n.setDropFiles(dropFiles);
        i18n.setError(error);
        i18n.getAddFiles().setOne("Upload csv...");
        i18n.getDropFiles().setOne("Drop csv");
        i18n.getError().setIncorrectFileType(this.i18nService.getTranslation("StudentUploadDialog.msg.onlyCsvAllowed", this.getLocale(), new Object[0]));
        upload.setAutoUpload(true);
        upload.setDropAllowed(false);
        upload.addSucceededListener((ComponentEventListener & Serializable)event -> {
            String fileName = event.getFileName();
            InputStream inputStream = receiver.getInputStream();
            StringBuilder errorSb = new StringBuilder();
            List result = this.convertInputStream(inputStream, errorSb);
            this.grid.setItems((Collection)result);
        });
        this.buttonLayout = BaseView.generateButtonLayout(Arrays.asList(this.infoButton, this.saveButton, this.cancelButton, upload));
        vLayout.add(new Component[]{this.errorTextArea, this.buttonLayout});
        this.add(new Component[]{vLayout});
    }

    private List<Student> convertInputStream(InputStream inputStream, StringBuilder errorSb) {
        List result = this.studentUploadService.convertUploadFile(inputStream, errorSb, this.getLocale());
        if (errorSb.length() > 0) {
            this.errorTextArea.setVisible(true);
            this.errorTextArea.setValue(errorSb.toString());
        }
        return result;
    }

    private void showInfo() {
        Dialog dialog = new Dialog();
        TextArea TA = new TextArea();
        TA.setValue(this.i18nService.getTranslation("StudentUploadDialog.msg.infoCsv", this.getLocale(), new Object[0]));
        Button closeButton = new Button(this.i18nService.getTranslation("StudentUploadDialog.button.close", this.getLocale(), new Object[0]));
        closeButton.addClickListener((ComponentEventListener & Serializable)click -> dialog.close());
        VerticalLayout vLayout = new VerticalLayout();
        vLayout.add(new Component[]{TA, closeButton});
        TA.setWidthFull();
        vLayout.setWidthFull();
        dialog.setWidth("70%");
        dialog.add(new Component[]{vLayout});
        dialog.open();
    }

    private void save() {
        UI.getCurrent().access((Command & Serializable)() -> BaseView.disableButtons(new ArrayList(this.allButtonList)));
        Div spinnerDiv = BaseView.createSpinnerDiv((Locale)this.getLocale());
        List children = this.buttonLayout.getChildren().toList();
        this.buttonLayout.removeAll();
        UI.getCurrent().access((Command & Serializable)() -> this.buttonLayout.add(new Component[]{spinnerDiv}));
        UI.getCurrent().push();
        try {
            this.studentUploadService.saveTheStudentsFromUploadAndCreateConnection(new ArrayList(this.grid.getSelectedItems()), this.schoolNumber);
            this.allStudentView.fillUpTheGrid();
            String message = this.i18nService.getTranslation("StudentUploadDialog.msg.studentsSaved", this.getLocale(), new Object[]{this.grid.getSelectedItems().size()});
            this.showNotificationMiddle(message, ConstantsNeoc.Durations.DURATION_SHORT.intValue());
            this.allStudentView.fillUpTheGrid();
            this.close();
        }
        catch (Exception e) {
            logger.error("Exception while saving Students from Upload ", (Throwable)e);
            String message = this.i18nService.getTranslation("StudentUploadDialog.msg.execptionStudentsSave", this.getLocale(), new Object[]{e.getMessage()});
            this.showNotificationMiddle("Exception beim Speichern " + e.getMessage(), 2);
        }
    }

    private void cancel() {
        this.close();
    }
}

