/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.dialogs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.BinderValidationStatus;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.validator.RegexpValidator;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.node.Subject;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseDialog;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.SubjectView;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectDialog
extends BaseDialog {
    private static final Logger logger = LoggerFactory.getLogger(SubjectDialog.class);
    private static final String MSG_KEY_DIALOGNAME = "SubjectDialog.";
    private final String schoolId;
    private final SubjectView courseView;
    private Subject subject;
    private TextField subjectTF;
    private TextArea descriptionTA;
    private Button saveBtn;
    private Button cancelBtn;
    private boolean isNew = false;
    private final Neo4JBaseService neo4JService;
    Binder<Subject> subjectBinder;
    private final I18nService i18nService;

    public SubjectDialog(@NotNull Neo4JBaseService neo4JBaseService, @NotNull String schoolId, Subject subject, @NotNull SubjectView subjectView) {
        this.neo4JService = neo4JBaseService;
        this.schoolId = schoolId;
        this.subject = subject;
        this.courseView = subjectView;
        this.i18nService = I18nService.getInstance();
        if (logger.isDebugEnabled()) {
            logger.debug("Subject in SubjectDialog is {}", (Object)subject);
        }
        this.initLayout();
    }

    private void initLayout() {
        if (this.subject == null) {
            this.subject = new Subject();
            this.isNew = true;
        }
        this.setCloseOnOutsideClick(false);
        FormLayout formLayout = new FormLayout();
        this.subjectBinder = new Binder(Subject.class);
        String descriptionLabel = this.i18nService.getTranslation("SubjectDialog.label.description", this.getLocale(), new Object[0]);
        this.descriptionTA = new TextArea(descriptionLabel);
        this.descriptionTA.setPlaceholder(descriptionLabel);
        String subjectLabel = this.i18nService.getTranslation("SubjectDialog.label.subject", this.getLocale(), new Object[0]);
        this.subjectTF = new TextField("* " + subjectLabel);
        this.subjectTF.setPlaceholder(subjectLabel);
        formLayout.add(new Component[]{this.subjectTF, this.descriptionTA});
        this.saveBtn = new Button(this.i18nService.getTranslation("SubjectDialog.button.save", this.getLocale(), new Object[0]));
        this.saveBtn.addClickListener((ComponentEventListener & Serializable)event -> this.save());
        this.cancelBtn = new Button(this.i18nService.getTranslation("SubjectDialog.button.cancel", this.getLocale(), new Object[0]));
        this.cancelBtn.addClickListener((ComponentEventListener & Serializable)event -> this.cancel());
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.add(new Component[]{this.saveBtn, this.cancelBtn});
        buttonLayout.setAlignItems(FlexComponent.Alignment.BASELINE);
        String msgIsRequired = this.i18nService.getTranslation("SubjectDialog.msg.isRequired", this.getLocale(), new Object[0]);
        String min3Chars50 = this.i18nService.getTranslation("SubjectDialog.msg.min3Chars", this.getLocale(), new Object[]{"50"});
        String min3Chars300 = this.i18nService.getTranslation("SubjectDialog.msg.min3Chars", this.getLocale(), new Object[]{"300"});
        this.subjectBinder.forField((HasValue)this.subjectTF).asRequired(msgIsRequired).withNullRepresentation((Object)"").withValidator((Validator)new RegexpValidator(min3Chars50, "\\S[\\w\\d\\s\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\\s\\W]{3,50}")).bind("subjectName");
        this.subjectBinder.forField((HasValue)this.descriptionTA).asRequired(msgIsRequired).withNullRepresentation((Object)"").withValidator((Validator)new RegexpValidator(min3Chars300, "\\S[\\w\\d\\s\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc\\s\\W]{3,300}")).bind("description");
        this.subjectBinder.readBean((Object)this.subject);
        formLayout.add(new Component[]{buttonLayout});
        this.add(new Component[]{formLayout});
    }

    private void save() {
        if (this.subject == null) {
            this.subject = new Subject();
        }
        try {
            this.subjectBinder.writeBean((Object)this.subject);
            this.showvalidationErrors(this.subjectBinder);
            if (this.isNew) {
                this.neo4JService.createSubject(this.subject, this.schoolId);
            } else {
                this.neo4JService.updateSubject(this.subject);
            }
            this.courseView.fillUpTheGrid();
            this.close();
        }
        catch (Exception e) {
            String exceptionMessage = this.i18nService.getTranslation("SubjectDialog.msg.exceptionSaveCourse", this.getLocale(), new Object[]{e.getMessage()});
            this.showNotificationMiddle(exceptionMessage + e.getMessage(), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            this.showvalidationErrors(this.subjectBinder);
        }
    }

    public void showvalidationErrors(Binder<Subject> binder) {
        BinderValidationStatus validationStatus = binder.validate();
        List valdationErrors = this.convertValidatorErrors(binder);
        if (validationStatus.hasErrors()) {
            StringBuilder sb = new StringBuilder();
            for (String msg : valdationErrors) {
                sb.append(msg).append("\n");
            }
            this.showNotificationMiddle(sb.toString(), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
        }
    }

    private void cancel() {
        this.close();
    }
}

