/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.dialogs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.BinderValidationStatus;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.validator.RegexpValidator;
import de.mahlsdorf.groupservice.model.CreateDeleteCounter;
import de.mahlsdorf.groupservice.model.node.Task;
import de.mahlsdorf.groupservice.model.node.Tool;
import de.mahlsdorf.groupservice.model.ui.ComboShort;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.neo4j.Neo4JStudentToTaskService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseDialog;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.TaskView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDialog
extends BaseDialog {
    private static final Logger logger = LoggerFactory.getLogger(TaskDialog.class);
    private static final String MSG_KEY_DIALOGNAME = "TaskDialog.";
    private final MainAppLayout mainLayoutUI;
    private final String courseId;
    private final TaskView taskView;
    private Task task;
    private TextField structureTF;
    private TextField nameTF;
    private TextField descriptionTF;
    private TextField urlTF;
    private NumberField ltiLiMaxPointsTF;
    private TextField ltiLiLineItemTagTF;
    private TextField ltiLiResourceIdTF;
    private TextField ltiResourceLinkIdTF;
    private TextField ltiLtiLinkIdTF;
    private TextArea ltiCustomParamsTA;
    private TextField ltiThumbnailUrlTF;
    private TextField ltiIconUrlTF;
    private final Neo4JBaseService neo4JBaseService;
    private final I18nService i18nService;
    private ComboBox<String> typeCombobox;
    private Button save;
    private Button cancel;
    private boolean isNew = false;
    private final Binder<Task> binder;
    private ComboBox<ComboShort<Tool>> toolIdComboBox;
    private final String taskType;
    private final boolean isLti = false;
    private final int taskCountInCourse;
    private Neo4JStudentToTaskService neo4JStudentToTaskService;

    public TaskDialog(MainAppLayout mainLayoutUI, String courseId, Task task, TaskView taskView, String taskType, int taskCountInCourse) {
        this.mainLayoutUI = mainLayoutUI;
        this.courseId = courseId;
        this.task = task;
        this.taskView = taskView;
        this.i18nService = I18nService.getInstance();
        this.neo4JBaseService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        this.neo4JStudentToTaskService = VaadineoServiceHolder.getINSTANCE().getNeo4JStudentToTaskService();
        this.binder = new Binder(Task.class);
        this.taskType = taskType;
        this.taskCountInCourse = taskCountInCourse;
        this.initLayout();
    }

    private void initLayout() {
        if (this.task == null) {
            this.task = new Task();
            this.isNew = true;
            this.task.setType(this.taskType);
            this.task.setStructure(String.format("%04d", this.taskCountInCourse + 1));
            if ("headline".equals(this.task)) {
                this.task.setLtiIconUrl("/neoc/images/URL_HEADLINE.png");
                this.task.setLtiThumbnailUrl("/neoc/images/URL_HEADLINE.png");
            }
        }
        this.setCloseOnOutsideClick(false);
        this.setCloseOnEsc(false);
        FormLayout formLayout = new FormLayout();
        String labelStructue = this.i18nService.getTranslation("TaskDialog.label.structure", this.getLocale(), new Object[0]);
        this.structureTF = new TextField();
        this.structureTF.setLabel(labelStructue);
        this.structureTF.setPlaceholder(labelStructue);
        this.structureTF.setValue(this.task.getStructure() == null ? "" : this.task.getStructure());
        String labelNameOfTask = this.i18nService.getTranslation("TaskDialog.label.nameOfTask", this.getLocale(), new Object[0]);
        this.nameTF = new TextField("* " + labelNameOfTask);
        this.nameTF.setPlaceholder(labelNameOfTask);
        this.nameTF.setValue(this.task.getName() == null ? "" : this.task.getName());
        String labelDescription = this.i18nService.getTranslation("TaskDialog.label.description", this.getLocale(), new Object[0]);
        this.descriptionTF = new TextField("*" + labelDescription);
        this.descriptionTF.setPlaceholder(labelDescription);
        this.descriptionTF.setValue(this.task.getDescription() == null ? "" : this.task.getDescription());
        String labelMaxPoints = this.i18nService.getTranslation("TaskDialog.label.maxPoints", this.getLocale(), new Object[0]);
        this.ltiLiMaxPointsTF = new NumberField(labelMaxPoints);
        this.ltiLiMaxPointsTF.setPlaceholder(labelMaxPoints);
        this.ltiLiMaxPointsTF.setValue((Number)(this.task.getLtiLineItemMaxPoints() == null ? 0.0 : this.task.getLtiLineItemMaxPoints()));
        String labelType = this.i18nService.getTranslation("TaskDialog.combobox.type", this.getLocale(), new Object[0]);
        this.typeCombobox = new ComboBox(labelType);
        this.typeCombobox.setItems(Arrays.asList("headline", "url", "LTI-1.3"));
        this.typeCombobox.setValue((Object)(this.task == null ? "url" : this.task.getType()));
        String labelToolId = this.i18nService.getTranslation("TaskDialog.label.toolId", this.getLocale(), new Object[0]);
        this.toolIdComboBox = new ComboBox(labelToolId);
        this.fillupToolComboBox(this.toolIdComboBox, this.task);
        this.toolIdComboBox.setAllowCustomValue(false);
        String labelUrl = this.i18nService.getTranslation("TaskDialog.label.url", this.getLocale(), new Object[0]);
        this.urlTF = new TextField(labelUrl);
        this.urlTF.setPlaceholder(labelUrl);
        this.urlTF.setValue(this.task.getUrl() == null ? "https://www.berlin.de" : this.task.getUrl());
        String labelLineItemTag = this.i18nService.getTranslation("TaskDialog.label.lineItemTag", this.getLocale(), new Object[0]);
        this.ltiLiLineItemTagTF = new TextField(labelLineItemTag);
        String labelLtilineItemRessourceId = this.i18nService.getTranslation("TaskDialog.label.lineitemRessourceId", this.getLocale(), new Object[0]);
        this.ltiLiResourceIdTF = new TextField(labelLtilineItemRessourceId);
        String labelResourceLinkId = this.i18nService.getTranslation("TaskDialog.label.RessourceLinkId", this.getLocale(), new Object[0]);
        this.ltiResourceLinkIdTF = new TextField(labelResourceLinkId);
        String labelLtiLinkId = this.i18nService.getTranslation("TaskDialog.label.LtiLinkId", this.getLocale(), new Object[0]);
        this.ltiLtiLinkIdTF = new TextField(labelLtiLinkId);
        String labelCustomParams = this.i18nService.getTranslation("TaskDialog.label.customParams", this.getLocale(), new Object[0]);
        this.ltiCustomParamsTA = new TextArea(labelCustomParams);
        String labelThumbnailUrl = this.i18nService.getTranslation("TaskDialog.label.thumbNailUrl", this.getLocale(), new Object[0]);
        this.ltiThumbnailUrlTF = new TextField(labelThumbnailUrl);
        String labelIconUrl = this.i18nService.getTranslation("TaskDialog.label.iconUrl", this.getLocale(), new Object[0]);
        this.ltiIconUrlTF = new TextField(labelIconUrl);
        if ("url".equals(this.task.getType())) {
            formLayout.add(new Component[]{this.structureTF, this.nameTF, this.descriptionTF, this.urlTF});
        } else if ("headline".equals(this.task.getType())) {
            formLayout.add(new Component[]{this.structureTF, this.nameTF, this.descriptionTF});
        } else {
            formLayout.add(new Component[]{this.structureTF, this.nameTF, this.descriptionTF, this.ltiLiMaxPointsTF, this.urlTF, this.toolIdComboBox, this.typeCombobox, this.ltiLiLineItemTagTF, this.ltiLiResourceIdTF, this.ltiResourceLinkIdTF, this.ltiLtiLinkIdTF, this.ltiCustomParamsTA, this.ltiThumbnailUrlTF, this.ltiThumbnailUrlTF, this.ltiIconUrlTF});
        }
        this.save = new Button(this.i18nService.getTranslation("TaskDialog.button.save", this.getLocale(), new Object[0]));
        this.save.addClickListener((ComponentEventListener & Serializable)event -> this.save());
        this.cancel = new Button(this.i18nService.getTranslation("TaskDialog.button.cancel", this.getLocale(), new Object[0]));
        this.cancel.addClickListener((ComponentEventListener & Serializable)event -> this.cancel());
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.add(new Component[]{this.save, this.cancel});
        buttonLayout.setAlignItems(FlexComponent.Alignment.BASELINE);
        formLayout.add(new Component[]{buttonLayout});
        String messageRequired = this.i18nService.getTranslation("TaskDialog.msg.required", this.getLocale(), new Object[0]);
        this.binder.forField((HasValue)this.structureTF).asRequired(messageRequired).bind("structure");
        String urlMessage = this.i18nService.getTranslation("TaskDialog.msg.requiredUrl", this.getLocale(), new Object[0]);
        RegexpValidator urlRegexpValidator = new RegexpValidator(urlMessage, "(bolt:|http:|https:)\\/\\/?[\\d\\w\\-\\.]{1,}(\\:[\\d]{2,5}|){0,1}(\\/\\S*){0,1}");
        this.binder.forField((HasValue)this.nameTF).asRequired(messageRequired).bind("name");
        this.binder.forField((HasValue)this.descriptionTF).asRequired(messageRequired).bind("description");
        this.binder.forField((HasValue)this.ltiLiMaxPointsTF).bind("ltiLineItemMaxPoints");
        this.binder.forField((HasValue)this.typeCombobox).bind("type");
        if (!"headline".equals(this.task.getType())) {
            this.binder.forField((HasValue)this.urlTF).asRequired(messageRequired).withValidator((Validator)urlRegexpValidator).bind("url");
        }
        this.binder.forField((HasValue)this.ltiLiLineItemTagTF).bind("ltiLiLineItemTag");
        this.binder.forField((HasValue)this.ltiLiResourceIdTF).bind("ltiLiResourceId");
        this.binder.forField((HasValue)this.ltiResourceLinkIdTF).bind("ltiResourceLinkId");
        this.binder.forField((HasValue)this.ltiLtiLinkIdTF).bind("ltiLtiLinkId");
        this.binder.forField((HasValue)this.ltiCustomParamsTA).bind("ltiCustomParams");
        if (this.task.getType().equals("LTI-1.3")) {
            this.binder.forField((HasValue)this.ltiThumbnailUrlTF).withValidator((Validator)urlRegexpValidator).bind("ltiThumbnailUrl");
            this.binder.forField((HasValue)this.ltiIconUrlTF).withValidator((Validator)urlRegexpValidator).bind("ltiIconUrl");
        } else {
            this.binder.forField((HasValue)this.ltiThumbnailUrlTF).bind("ltiThumbnailUrl");
            this.binder.forField((HasValue)this.ltiIconUrlTF).bind("ltiIconUrl");
        }
        this.binder.readBean((Object)this.task);
        this.typeCombobox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.typeHasChanged());
        this.typeHasChanged();
        this.add(new Component[]{formLayout});
        this.toolIdComboBox.setReadOnly(true);
        this.enableDisableField(this.task);
    }

    private void fillupToolComboBox(ComboBox toolIdComboBox, Task task) {
        List tools = this.neo4JBaseService.getToolsForSchool(this.mainLayoutUI.getSchoolId());
        if (tools.isEmpty()) {
            String messageNoTools = this.i18nService.getTranslation("TaskDialog.msg.noLtiTools", this.getLocale(), new Object[0]);
            this.showNotificationMiddle(messageNoTools, 3);
            return;
        }
        ArrayList<ComboShort> items = new ArrayList<ComboShort>();
        ComboShort selectedItem = null;
        for (Tool tool : tools) {
            ComboShort cs = new ComboShort((Object)tool, tool.getToolName() + " (" + tool.getToolId() + ")");
            if (tool.getToolId().equals(task.getToolId())) {
                selectedItem = cs;
            }
            items.add(cs);
        }
        if (selectedItem == null) {
            selectedItem = (ComboShort)items.get(0);
        }
        toolIdComboBox.setItems(items);
        toolIdComboBox.setValue((Object)selectedItem);
        if ("url".equals(task.getType())) {
            toolIdComboBox.setValue(null);
        }
    }

    private void enableDisableField(Task task) {
        String type = (String)this.typeCombobox.getValue();
        if (task.getTaskId() == null) {
            if ("url".equals(type)) {
                this.toolIdComboBox.setReadOnly(true);
            } else if ("LTI-1.3".equals(type)) {
                this.toolIdComboBox.setReadOnly(false);
            }
        } else {
            this.typeCombobox.setReadOnly(true);
            if ("url".equals(type)) {
                this.toolIdComboBox.setReadOnly(true);
                this.urlTF.setReadOnly(false);
                this.toolIdComboBox.setReadOnly(true);
                this.ltiCustomParamsTA.setReadOnly(true);
            } else if ("LTI-1.3".equals(type)) {
                this.urlTF.setReadOnly(true);
                this.toolIdComboBox.setReadOnly(true);
                this.ltiCustomParamsTA.setReadOnly(false);
            } else if ("LineItem".equals(type)) {
                this.ltiCustomParamsTA.setReadOnly(true);
            }
        }
        this.ltiLiLineItemTagTF.setReadOnly(true);
        this.ltiLiResourceIdTF.setReadOnly(true);
        this.ltiResourceLinkIdTF.setReadOnly(true);
        this.ltiLtiLinkIdTF.setReadOnly(true);
    }

    private void typeHasChanged() {
        String type = (String)this.typeCombobox.getValue();
        if (StringUtils.isEmpty((CharSequence)type)) {
            String message = this.i18nService.getTranslation("TaskDialog.msg.selectAType", this.getLocale(), new Object[0]);
            this.showNotificationMiddle(message, 2);
            return;
        }
        try {
            this.binder.writeBean((Object)this.task);
            this.binder.validate();
            this.setToolIdIfSet();
        }
        catch (Exception e) {
            String message = this.i18nService.getTranslation("TaskDialog.msg.exceptionBeanValidation", this.getLocale(), new Object[]{this.convertValidatorErrors(this.binder)});
            this.showNotificationMiddle(message, 3);
        }
        this.enableDisableField(this.task);
    }

    private void save() {
        try {
            this.binder.writeBean((Object)this.task);
            if (this.task.getType().equals("url")) {
                this.task.setLtiIconUrl("/neoc/images/URL_THUMB.png");
                this.task.setLtiThumbnailUrl("/neoc/images/URL_THUMB.png");
            } else if ("headline".equals(this.task.getType())) {
                this.task.setLtiIconUrl("/neoc/images/URL_HEADLINE.png");
                this.task.setLtiThumbnailUrl("/neoc/images/URL_HEADLINE.png");
            }
            BinderValidationStatus status = this.binder.validate();
            if (status.hasErrors()) {
                String message = this.i18nService.getTranslation("TaskDialog.msg.exceptionBeanValidation", this.getLocale(), new Object[]{this.convertValidatorErrors(this.binder)});
                this.showNotificationMiddle(message, 3);
                return;
            }
            this.setToolIdIfSet();
            logger.error("############ Validator bauen ");
        }
        catch (Exception e) {
            logger.info("Exception while getting task bean {}", (Object)this.task, (Object)e);
            String message = this.i18nService.getTranslation("TaskDialog.msg.exceptionBeanValidation", this.getLocale(), new Object[]{this.convertValidatorErrors(this.binder)});
            this.showNotificationMiddle(message, 2);
            return;
        }
        logger.info("new Bean is {}", (Object)this.task);
        if (this.task == null) {
            this.task = new Task();
        }
        try {
            if (this.isNew) {
                this.neo4JBaseService.createTaskAndRelation(this.task, this.courseId);
                this.addStudentsToTask();
            } else {
                this.neo4JBaseService.updateTask(this.task);
            }
            this.taskView.learningGroupHasChangedFillUpCourses();
            this.close();
        }
        catch (Exception e) {
            logger.error("cant create task ", (Throwable)e);
            String message = this.i18nService.getTranslation("TaskDialog.msg.exceptionSaveTask", this.getLocale(), new Object[]{e.getMessage()});
            this.showNotificationMiddle("cant create task Exception " + e.getMessage(), 2);
        }
    }

    private void setToolIdIfSet() {
        if (this.toolIdComboBox.getValue() != null) {
            ComboShort cs = (ComboShort)this.toolIdComboBox.getValue();
            this.task.setToolId(((Tool)cs.getId()).getToolId());
        }
    }

    private void addStudentsToTask() {
        if (!"headline".equals(this.task.getType())) {
            List allStudentsHavingTaskList = this.neo4JBaseService.getStudentForCourseViaLearningGroup(this.courseId);
            logger.info("add students to Task ");
            String taskId = this.task.getTaskId();
            HashSet studentsFromGrid = new HashSet(allStudentsHavingTaskList);
            logger.info("startUpdate for TaskId {} with Assigned Students Elements {} ", (Object)taskId, (Object)studentsFromGrid.size());
            this.neo4JStudentToTaskService.updateTaskToStudentConnections(this.task, studentsFromGrid, new CreateDeleteCounter());
        }
    }

    private void cancel() {
        this.close();
    }
}

