/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.dialogs;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.Command;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.CreateDeleteCounter;
import de.mahlsdorf.groupservice.model.node.LearningGroup;
import de.mahlsdorf.groupservice.model.node.Student;
import de.mahlsdorf.groupservice.model.node.Task;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.neo4j.Neo4JStudentToTaskService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseDialog;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.TaskView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.driver.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskToStudentAssignmentDialog
extends BaseDialog {
    public static final String KOMMENTAR_2 = "Kommentar2";
    public static final String KOMMENTAR_3 = "Kommentar3";
    public static final String KOMMENTAR_1 = "Kommentar1";
    public static final String FIRST_NAME = "givenName";
    public static final String LAST_NAME = "lastName";
    public static final String NL = "\n";
    private static final Logger logger = LoggerFactory.getLogger(TaskToStudentAssignmentDialog.class);
    private static final String MSG_KEY_DIALOGNAME = "TaskToStudentAssignmentDialog.";
    private final List<Student> allStudentListPerLearningGroup = new ArrayList();
    private final List<Student> allStudentsHavingTaskList = new ArrayList();
    private final List<Task> taskList;
    private final LearningGroup learnGroup;
    private Grid<Student> gridAllStudentsPerLearningGroup;
    private Grid<Student> gridStudentsHavingTask;
    private Button saveButton;
    private ListDataProvider<Student> allStudentInGroupDataProvider;
    private ListDataProvider<Student> allStudentsHavingTaskDataProvider;
    private HorizontalLayout buttonLayout;
    private final TaskView taskView;
    private StringBuilder comboBoxMessageStringBuilder;
    private HeaderRow filteringHeader;
    private final I18nService i18nService;
    private final boolean isAssignMulti;
    private Button cancelButton;
    private Neo4JBaseService neo4JBaseService;
    private Neo4JStudentToTaskService neo4JStudentToTaskService;

    public TaskToStudentAssignmentDialog(TaskView taskView, List<Task> task, LearningGroup learngroup, boolean isAssignMulti) {
        this.taskView = taskView;
        this.taskList = task;
        this.learnGroup = learngroup;
        this.i18nService = I18nService.getInstance();
        this.isAssignMulti = isAssignMulti;
        this.neo4JBaseService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        this.neo4JStudentToTaskService = VaadineoServiceHolder.getINSTANCE().getNeo4JStudentToTaskService();
        if (this.taskView.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    private void initLayout() {
        VerticalLayout verticalLayout1 = new VerticalLayout();
        verticalLayout1.add(new Component[]{this.taskView.getLoggedInInfoLayout()});
        verticalLayout1.setMargin(true);
        Span learnGroupLabel = new Span(this.i18nService.getTranslation("TaskToStudentAssignmentDialog.label.learngroupLabel", this.getLocale(), new Object[]{this.learnGroup.toString()}));
        Span taskLabel = new Span(this.i18nService.getTranslation("TaskToStudentAssignmentDialog.label.selectedTaskLabelCount", this.getLocale(), new Object[]{this.taskList.size()}));
        if (!this.isAssignMulti) {
            taskLabel = new Span(this.i18nService.getTranslation("TaskToStudentAssignmentDialog.label.taskLabel", this.getLocale(), new Object[]{((Task)this.taskList.get(0)).getName(), ((Task)this.taskList.get(0)).getDescription()}));
        }
        Span label = new Span(this.i18nService.getTranslation("TaskToStudentAssignmentDialog.label.moveInstruction", this.getLocale(), new Object[0]));
        verticalLayout1.add(new Component[]{learnGroupLabel, taskLabel, label});
        if (this.isAssignMulti) {
            String msg = this.i18nService.getTranslation("TaskToStudentAssignmentDialog.msg.assignWarning", this.getLocale(), new Object[0]);
            Div div = new Div(new Component[]{new Span(msg)});
            div.setClassName("background-red-without-margin");
            div.setWidthFull();
            verticalLayout1.add(new Component[]{div});
        }
        HorizontalLayout hLayoutGrids = new HorizontalLayout();
        hLayoutGrids.setSpacing(false);
        this.allStudentInGroupDataProvider = new ListDataProvider((Collection)this.allStudentListPerLearningGroup);
        this.allStudentsHavingTaskDataProvider = new ListDataProvider((Collection)this.allStudentsHavingTaskList);
        this.gridAllStudentsPerLearningGroup = new Grid();
        this.gridStudentsHavingTask = new Grid();
        this.createStudentGrid(this.gridAllStudentsPerLearningGroup);
        this.createStudentGrid(this.gridStudentsHavingTask);
        Button moveToLeftButton = new Button((Component)VaadinIcon.ARROW_LEFT.create());
        moveToLeftButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.moveToLeft());
        Button moveToRightButton = new Button((Component)VaadinIcon.ARROW_RIGHT.create());
        moveToRightButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.moveToRight());
        VerticalLayout moveButtonLayout = new VerticalLayout();
        moveButtonLayout.setSpacing(false);
        moveButtonLayout.setMargin(false);
        moveButtonLayout.setPadding(false);
        moveButtonLayout.add(new Component[]{moveToRightButton, moveToLeftButton});
        moveButtonLayout.setWidth("80px");
        hLayoutGrids.add(new Component[]{this.gridAllStudentsPerLearningGroup, moveButtonLayout, this.gridStudentsHavingTask});
        hLayoutGrids.setWidthFull();
        verticalLayout1.add(new Component[]{hLayoutGrids});
        this.gridAllStudentsPerLearningGroup.setWidthFull();
        this.gridAllStudentsPerLearningGroup.setSelectionMode(Grid.SelectionMode.MULTI);
        this.gridStudentsHavingTask.setWidthFull();
        this.gridStudentsHavingTask.setSelectionMode(Grid.SelectionMode.MULTI);
        this.buttonLayout = new HorizontalLayout();
        this.saveButton = new Button(this.i18nService.getTranslation("TaskToStudentAssignmentDialog.button.save", this.getLocale(), new Object[0]));
        this.saveButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.saveTaskAssignments());
        this.cancelButton = new Button(this.i18nService.getTranslation("TaskToStudentAssignmentDialog.button.close", this.getLocale(), new Object[0]));
        this.cancelButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.cancel());
        HorizontalLayout hl = new HorizontalLayout();
        hl.add(new Component[]{this.saveButton, this.cancelButton});
        this.buttonLayout.add(new Component[]{hl});
        this.buttonLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        this.buttonLayout.setWidthFull();
        verticalLayout1.add(new Component[]{this.buttonLayout});
        this.add(new Component[]{verticalLayout1});
        this.setSizeFull();
        this.saveButton.setEnabled(false);
        this.searchStudentsForLearningGroup();
        this.fillGrisWithAssignedStudents(this.isAssignMulti);
        this.setColumnFiltering(true);
    }

    private void moveToRight(Collection<Student> items) {
        boolean mustRefresh = false;
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        String messageAdded = this.i18nService.getTranslation("TaskToStudentAssignmentDialog.msg.addedHeader", this.getLocale(), new Object[0]);
        String messageNotAdded = this.i18nService.getTranslation("TaskToStudentAssignmentDialog.msg.notAddedHeader", this.getLocale(), new Object[0]);
        sb.append(messageAdded + NL);
        sb1.append(messageNotAdded + NL);
        for (Student item : items) {
            if (!this.allStudentsHavingTaskList.contains(item)) {
                this.allStudentsHavingTaskList.add(item);
                sb.append(item.getFirstName().concat(" ").concat(item.getLastName()).concat(NL));
                mustRefresh = true;
                this.enableSaveButton(true);
                continue;
            }
            logger.info("Item {} bereits in LearningGroup", (Object)item);
            sb1.append(item.getFirstName().concat(" ").concat(item.getLastName()).concat(NL));
        }
        if (mustRefresh) {
            ListDataProvider dataProvider = new ListDataProvider((Collection)this.allStudentsHavingTaskList);
            this.gridStudentsHavingTask.setDataProvider((DataProvider)dataProvider);
            this.gridStudentsHavingTask.getDataProvider().refreshAll();
            this.showNotificationMiddle(sb.toString(), 2);
        } else {
            this.showNotificationMiddle(sb1.toString(), 1);
        }
        this.gridAllStudentsPerLearningGroup.deselectAll();
    }

    private void enableSaveButton(boolean enabled) {
        this.saveButton.setEnabled(enabled);
    }

    private void enableSearchUi(boolean enabled) {
    }

    private void createStudentGrid(Grid<Student> grid) {
        grid.setWidthFull();
        String gridheaderNumber = this.i18nService.getTranslation("TaskToStudentAssignmentDialog.gridheader.number", this.getLocale(), new Object[0]);
        String gridheaderGivenName = this.i18nService.getTranslation("TaskToStudentAssignmentDialog.gridheader.givenName", this.getLocale(), new Object[0]);
        String gridheaderLastName = this.i18nService.getTranslation("TaskToStudentAssignmentDialog.gridheader.lastName", this.getLocale(), new Object[0]);
        String gridheaderComment1 = this.i18nService.getTranslation("TaskToStudentAssignmentDialog.gridheader.comment1", this.getLocale(), new Object[0]);
        String gridheaderComment2 = this.i18nService.getTranslation("TaskToStudentAssignmentDialog.gridheader.comment2", this.getLocale(), new Object[0]);
        String gridheaderComment3 = this.i18nService.getTranslation("TaskToStudentAssignmentDialog.gridheader.comment3", this.getLocale(), new Object[0]);
        grid.addColumn(Student::getStudentId).setHeader(gridheaderNumber).setSortable(true);
        grid.addColumn(Student::getFirstName).setHeader(gridheaderGivenName).setKey(FIRST_NAME).setSortable(true);
        grid.addColumn(Student::getLastName).setHeader(gridheaderLastName).setKey(LAST_NAME).setSortable(true);
        grid.addColumn(Student::getComment1).setHeader(gridheaderComment1).setKey(KOMMENTAR_1).setSortable(true);
        grid.addColumn(Student::getComment2).setHeader(gridheaderComment2).setKey(KOMMENTAR_2).setSortable(true);
        grid.addColumn(Student::getComment3).setHeader(gridheaderComment3).setKey(KOMMENTAR_3).setSortable(true);
    }

    private void searchStudentsForLearningGroup() {
        try {
            String learnGroupId = this.learnGroup.getGroupId();
            long startTime = System.currentTimeMillis();
            List studentList = this.neo4JBaseService.getStudentsPerLearnGroup(learnGroupId);
            this.allStudentListPerLearningGroup.clear();
            this.allStudentsHavingTaskList.clear();
            this.allStudentListPerLearningGroup.addAll(studentList);
            this.allStudentInGroupDataProvider.refreshAll();
            this.enableSaveButton(false);
            this.enableSearchUi(true);
            logger.debug("search of all students in learngroup took {} msec", (Object)(startTime - System.currentTimeMillis()));
        }
        catch (Exception e) {
            logger.error("Exception during Search of Students {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void fillGrisWithAssignedStudents(boolean isSelectMulti) {
        LearningGroup selectedLearnGroup = this.learnGroup;
        List studentInLearningGroup = this.neo4JBaseService.getStudentsPerLearnGroup(selectedLearnGroup.getGroupId());
        this.allStudentInGroupDataProvider.getItems().clear();
        this.allStudentInGroupDataProvider.getItems().addAll(studentInLearningGroup);
        this.gridAllStudentsPerLearningGroup.setDataProvider((DataProvider)this.allStudentInGroupDataProvider);
        this.allStudentInGroupDataProvider.refreshAll();
        this.allStudentsHavingTaskList.clear();
        if (!this.isAssignMulti) {
            List studentPerTaskList = this.neo4JBaseService.getStudentsPerTask(((Task)this.taskList.get(0)).getTaskId());
            this.allStudentsHavingTaskList.addAll(studentPerTaskList);
            ListDataProvider dataProviderTasks = new ListDataProvider((Collection)studentPerTaskList);
            this.gridStudentsHavingTask.setDataProvider((DataProvider)dataProviderTasks);
            this.gridStudentsHavingTask.getDataProvider().refreshAll();
        }
        if (this.comboBoxMessageStringBuilder == null) {
            this.comboBoxMessageStringBuilder = new StringBuilder();
        }
        String msg = this.i18nService.getTranslation("TaskToStudentAssignmentDialog.label.moveInstruction", this.getLocale(), new Object[0]);
        if (!this.comboBoxMessageStringBuilder.toString().contains(msg)) {
            this.comboBoxMessageStringBuilder.append(msg);
        }
        this.showNotificationMiddle(this.comboBoxMessageStringBuilder.toString(), 2);
    }

    private void moveToLeft() {
        this.enableSaveButton(true);
        this.enableSearchUi(false);
        Set selectedItems = this.gridStudentsHavingTask.getSelectedItems();
        if (selectedItems == null || selectedItems.size() < 1) {
            this.showNotificationMiddle(this.i18nService.getTranslation("TaskToStudentAssignmentDialog.msg.selectStudentRightGrid", this.getLocale(), new Object[0]), 2);
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.i18nService.getTranslation("TaskToStudentAssignmentDialog.msg.removed", this.getLocale(), new Object[0]) + "\n\n");
        for (Student item : selectedItems) {
            sb.append(item.getFirstName() + " " + item.getLastName() + NL);
        }
        this.allStudentsHavingTaskList.removeAll(selectedItems);
        ListDataProvider dataProvider = new ListDataProvider((Collection)this.allStudentsHavingTaskList);
        this.gridStudentsHavingTask.setDataProvider((DataProvider)dataProvider);
        this.gridStudentsHavingTask.getDataProvider().refreshAll();
        this.gridStudentsHavingTask.deselectAll();
        this.showNotificationMiddle(sb.toString(), 2);
    }

    private void moveToRight() {
        this.enableSaveButton(true);
        this.enableSearchUi(false);
        Set selectedItems = this.gridAllStudentsPerLearningGroup.getSelectedItems();
        if (selectedItems == null || selectedItems.size() < 1) {
            this.showNotificationMiddle(this.i18nService.getTranslation("TaskToStudentAssignmentDialog.msg.selectStudentLeftGrid", this.getLocale(), new Object[0]), 2);
            return;
        }
        this.moveToRight((Collection)selectedItems);
    }

    private void saveTaskAssignments() {
        this.enableSaveButton(false);
        this.enableSearchUi(true);
        this.enableSaveButton(false);
        UI ui = UI.getCurrent();
        Div spinnerDiv = BaseView.createSpinnerDiv((Locale)this.getLocale());
        this.buttonLayout.removeAll();
        UI.getCurrent().access((Command & Serializable)() -> this.buttonLayout.add(new Component[]{spinnerDiv}));
        UI.getCurrent().push();
        Locale locale = this.getLocale();
        HashSet studentsFromGrid = new HashSet(this.allStudentsHavingTaskList);
        HashSet taskIds = new HashSet();
        this.taskList.forEach(x -> taskIds.add(x.getTaskId()));
        HashSet studentIds = new HashSet();
        this.allStudentsHavingTaskList.forEach(x -> studentIds.add(x.getStudentId()));
        Transaction tx = this.neo4JBaseService.getNewTransaction();
        CreateDeleteCounter counter = null;
        logger.info("startUpdate for {} TaskId with Assigned Students Elements {} ", (Object)this.taskList.size(), (Object)studentsFromGrid.size());
        try {
            counter = this.neo4JStudentToTaskService.updateTaskToStudentConnectionsBulk(Set.copyOf(this.taskList), studentsFromGrid);
            tx.commit();
        }
        catch (Exception e) {
            this.showNotificationMiddle(e.getMessage(), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
        }
        String msg = this.i18nService.getTranslation("TaskToStudentAssignmentDialog.msg.saveStatus", locale, new Object[]{counter.getCreated(), counter.getDeleted()});
        this.buttonLayout.removeAll();
        this.buttonLayout.add(new Component[]{this.cancelButton});
        ui.access((Command & Serializable)() -> ui.push());
        ui.access((Command & Serializable)() -> Notification.show((String)msg, (int)2000, (Notification.Position)Notification.Position.MIDDLE));
        this.close();
    }

    private void cancel() {
        this.close();
    }

    private void addValueChangeFilterListener(AbstractField.ComponentValueChangeEvent<TextField, String> event, ValueProvider<Student, String> valueProvider) {
        this.checkAllFilterFieldsEmpty((String)event.getValue(), this.filterFields, this.allStudentInGroupDataProvider);
        if (StringUtils.isEmpty((CharSequence)((CharSequence)event.getValue()))) {
            return;
        }
        this.clearFilterFields((TextField)event.getSource(), (String)event.getValue(), this.filterFields, this.allStudentInGroupDataProvider);
        this.allStudentInGroupDataProvider.clearFilters();
        this.allStudentInGroupDataProvider.addFilter(valueProvider, (SerializablePredicate & Serializable)gridFieldValue -> this.compareGridValues((String)event.getValue(), gridFieldValue));
    }

    private void setColumnFiltering(boolean filtered) {
        if (filtered && this.filteringHeader == null) {
            this.filteringHeader = this.gridAllStudentsPerLearningGroup.appendHeaderRow();
            TextField filterFieldFirstName = this.getColumnFilterField();
            filterFieldFirstName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.addValueChangeFilterListener(event, Student::getFirstName));
            TextField filterFieldLastName = this.getColumnFilterField();
            filterFieldLastName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.addValueChangeFilterListener(event, Student::getLastName));
            TextField filterFieldComment1 = this.getColumnFilterField();
            filterFieldComment1.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.addValueChangeFilterListener(event, Student::getComment1));
            TextField filterFieldComment2 = this.getColumnFilterField();
            filterFieldComment2.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.addValueChangeFilterListener(event, Student::getComment2));
            TextField filterFieldComment3 = this.getColumnFilterField();
            filterFieldComment3.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.addValueChangeFilterListener(event, Student::getComment3));
            Grid.Column colComment1 = this.gridAllStudentsPerLearningGroup.getColumnByKey(KOMMENTAR_1);
            Grid.Column colComment2 = this.gridAllStudentsPerLearningGroup.getColumnByKey(KOMMENTAR_2);
            Grid.Column colComment3 = this.gridAllStudentsPerLearningGroup.getColumnByKey(KOMMENTAR_3);
            Grid.Column colFirstName = this.gridAllStudentsPerLearningGroup.getColumnByKey(FIRST_NAME);
            Grid.Column colLastName = this.gridAllStudentsPerLearningGroup.getColumnByKey(LAST_NAME);
            ((HeaderRow.HeaderCell)this.filteringHeader.getCell(colComment1)).setComponent((Component)filterFieldComment1);
            ((HeaderRow.HeaderCell)this.filteringHeader.getCell(colComment2)).setComponent((Component)filterFieldComment2);
            ((HeaderRow.HeaderCell)this.filteringHeader.getCell(colComment3)).setComponent((Component)filterFieldComment3);
            ((HeaderRow.HeaderCell)this.filteringHeader.getCell(colFirstName)).setComponent((Component)filterFieldFirstName);
            ((HeaderRow.HeaderCell)this.filteringHeader.getCell(colLastName)).setComponent((Component)filterFieldLastName);
            this.filterFields = Collections.unmodifiableList(Arrays.asList(filterFieldComment1, filterFieldComment2, filterFieldComment3, filterFieldFirstName, filterFieldLastName));
        } else if (!filtered && this.filteringHeader != null) {
            this.allStudentInGroupDataProvider.clearFilters();
            this.filteringHeader = null;
        }
    }
}

