/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.dialogs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.validator.RegexpValidator;
import com.vaadin.flow.server.Command;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.node.PersonIF;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseDialog;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.TeacherView;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeacherDialog
extends BaseDialog {
    private static final String MSG_KEY_DIALOGNAME = "TeacherDialog.";
    private static final Logger logger = LoggerFactory.getLogger(TeacherDialog.class);
    private final MainAppLayout mainLayoutUI;
    private final String schoolNumber;
    private final TeacherView teacherView;
    private final Neo4JBaseService neo4JService;
    private final Binder<Teacher> binder = new Binder(Teacher.class);
    private Teacher teacher;
    private final Teacher loggedInTeacher;
    private TextField lastNameTF;
    private TextField firstNameTF;
    private Checkbox isAdminCheckBox;
    private TextField loginNameTF;
    private Button saveButton;
    I18nService i18nService = I18nService.getInstance();

    public TeacherDialog(MainAppLayout mainLayoutUI, String schoolNumber, Teacher teacher, TeacherView teacherView, Teacher loggedInTeacher) {
        this.mainLayoutUI = mainLayoutUI;
        this.schoolNumber = schoolNumber;
        this.teacher = teacher;
        this.teacherView = teacherView;
        this.neo4JService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        this.loggedInTeacher = loggedInTeacher;
        this.initLayout();
    }

    private void initLayout() {
        if (this.teacher == null) {
            this.teacher = new Teacher();
        }
        FormLayout formLayout = new FormLayout();
        String labelFirstName = this.i18nService.getTranslation("TeacherDialog.label.givenName", this.getLocale(), new Object[0]);
        this.firstNameTF = this.createTextField(labelFirstName);
        this.firstNameTF.setId("tfFirstNameId");
        String labelLastName = this.i18nService.getTranslation("TeacherDialog.label.lastName", this.getLocale(), new Object[0]);
        this.lastNameTF = this.createTextField(labelLastName);
        this.lastNameTF.setId("tfLastNameId");
        String labelLoginName = this.i18nService.getTranslation("TeacherDialog.label.loginName", this.getLocale(), new Object[0]);
        this.loginNameTF = this.createTextField(labelLoginName);
        this.loginNameTF.setId("tfLoginId");
        String labelAdmin = this.i18nService.getTranslation("TeacherDialog.label.isAdmin", this.getLocale(), new Object[0]);
        this.isAdminCheckBox = new Checkbox();
        this.isAdminCheckBox.setId("cBAdminId");
        this.isAdminCheckBox.setLabel(labelAdmin);
        if (!this.loggedInTeacher.getAdmin().booleanValue()) {
            this.isAdminCheckBox.setEnabled(false);
        }
        formLayout.add(new Component[]{this.firstNameTF, this.lastNameTF, this.loginNameTF, this.isAdminCheckBox});
        String validatorMessage = this.i18nService.getTranslation("TeacherDialog.msg.nameRegex", this.getLocale(), new Object[0]);
        this.bindNameField(this.firstNameTF, validatorMessage, "firstName");
        this.bindNameField(this.lastNameTF, validatorMessage, "lastName");
        this.bindNameField(this.loginNameTF, validatorMessage, "loginName");
        this.binder.forField((HasValue)this.isAdminCheckBox).bind("admin");
        this.saveButton = new Button(this.i18nService.getTranslation("TeacherDialog.button.save", this.getLocale(), new Object[0]));
        this.saveButton.setId("BtnSaveId");
        this.saveButton.addClickListener((ComponentEventListener & Serializable)event -> this.save());
        Button cancelButton = new Button(this.i18nService.getTranslation("TeacherDialog.button.cancel", this.getLocale(), new Object[0]));
        cancelButton.setId("BtnCanelId");
        cancelButton.addClickListener((ComponentEventListener & Serializable)event -> this.cancel());
        HorizontalLayout hlButtons = BaseView.generateButtonLayout(List.of(this.saveButton, cancelButton));
        formLayout.add(new Component[]{hlButtons});
        this.add(new Component[]{formLayout});
        this.binder.readBean((Object)this.teacher);
    }

    public boolean isEditAllowed(Teacher teacher, Teacher loggedInTeacher) {
        if (!loggedInTeacher.getAdmin().booleanValue() && !teacher.equals((Object)loggedInTeacher)) {
            this.close();
            UI.getCurrent().access((Command & Serializable)() -> this.showNotificationMiddle(this.i18nService.getTranslation("TeacherDialog.msg.noAdmin", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue()));
            return false;
        }
        return true;
    }

    private void bindNameField(TextField lastName, String validatorMessage, String lastName1) {
        this.binder.forField((HasValue)lastName).asRequired(validatorMessage).withValidator((Validator)new RegexpValidator(validatorMessage, "[\\w\\\u00e4\\\u00f6\\\u00fc\\\u00c4\\\u00d6\\\u00dc]{1,}[\\w\\\u00e4\\\u00f6\\\u00fc\\\u00c4\\\u00d6\\\u00dc\\s.]{1,}")).bind(lastName1);
    }

    TextField createTextField(String label) {
        TextField result = new TextField();
        result.setLabel(label);
        result.setPlaceholder(label);
        return result;
    }

    private void save() {
        try {
            boolean isNew = false;
            this.binder.writeBean((Object)this.teacher);
            logger.info("Bean before Save {} ", (Object)this.teacher);
            if (this.teacher.getTeacherId() == null) {
                String teacherId = UUID.randomUUID().toString();
                this.teacher.setTeacherId(teacherId);
                isNew = true;
            }
            Teacher teacherLoginName = this.neo4JService.findTeacherByLoginName(this.teacher.getLoginName());
            if (isNew && teacherLoginName != null || teacherLoginName != null && !this.teacherIdEquals(this.teacher, teacherLoginName)) {
                String message = this.i18nService.getTranslation("TeacherDialog.msg.loginNameExists", this.getLocale(), new Object[]{this.teacher.getLoginName()});
                this.showNotificationMiddle(message, ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
                return;
            }
            if (isNew) {
                this.neo4JService.createPerson((PersonIF)this.teacher);
                this.neo4JService.createRelPersonSchool(this.schoolNumber, (PersonIF)this.teacher, "Teacher", "TeacherIn");
            } else {
                this.neo4JService.saveTeacher(this.teacher);
            }
            String msg = this.i18nService.getTranslation("TeacherDialog.msg.teacherSaved", this.getLocale(), new Object[]{this.teacher.getFirstName(), this.teacher.getLastName()});
            this.showNotificationMiddle(msg, ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            if (this.teacherView != null) {
                this.teacherView.fillUpTheGrid();
            }
            Teacher changedTeacher = this.neo4JService.findTeacherById(this.teacher.getTeacherId());
            if (this.mainLayoutUI.getLoggedInTeacher().getTeacherId().equals(changedTeacher.getTeacherId())) {
                this.mainLayoutUI.setLoggedInTeacher(changedTeacher);
            }
            this.close();
        }
        catch (Exception e) {
            logger.error("Exception while saving Teacher ", (Throwable)e);
            String msg = this.i18nService.getTranslation("TeacherDialog.msg.exceptionTeacherSave", this.getLocale(), new Object[]{e.getMessage()});
            this.showNotificationMiddle(msg, ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
        }
    }

    private boolean teacherIdEquals(Teacher teacherFromDialog, Teacher teacher) {
        if (teacher == null) {
            return false;
        }
        return teacherFromDialog.getTeacherId().equals(teacher.getTeacherId());
    }

    private void cancel() {
        this.close();
    }
}

