/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.dialogs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.server.Command;
import de.mahlsdorf.groupservice.model.CreateDeleteCounter;
import de.mahlsdorf.groupservice.model.node.LearningGroup;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.neo4j.Neo4JTeacherToLearningGroupService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseDialog;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.LearningGroupNamesView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeacherToLearningGroupAssignmentDialog
extends BaseDialog {
    private static final Logger logger = LoggerFactory.getLogger(TeacherToLearningGroupAssignmentDialog.class);
    private static final String MSG_KEY_DIALOGNAME = "TeacherToLearningGroupAssignmentDialog.";
    private final LearningGroupNamesView learningGroupNamesView;
    private final LearningGroup learnGroup;
    private final String schoolId;
    private final List<Teacher> teacherListPerLearningGroup = new ArrayList();
    private final List<Teacher> teachersAssignedToLearningGroup = new ArrayList();
    private Neo4JBaseService neo4JBaseService;
    private VerticalLayout verticalLayout1;
    private Grid<Teacher> gridAllTeacher;
    private Grid<Teacher> gridTeacherAssignedToLearningGroup;
    private Button saveButton;
    private Button cancelButton;
    private Button moveToLeftButton;
    private Button moveToRightButton;
    private ListDataProvider<Teacher> allTeacherDataProvider;
    private ListDataProvider<Teacher> assignedTeacherDataProvider;
    private StringBuilder comboBoxMessageStringBuilder;
    private final I18nService i18nService = I18nService.getInstance();
    private final Locale locale;

    public TeacherToLearningGroupAssignmentDialog(String schoolId, LearningGroup learngroup, LearningGroupNamesView learningGroupNamesView) {
        this.learnGroup = learngroup;
        this.schoolId = schoolId;
        this.learningGroupNamesView = learningGroupNamesView;
        this.neo4JBaseService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        this.locale = this.getLocale();
        this.initLayout();
    }

    private void initLayout() {
        this.verticalLayout1 = new VerticalLayout();
        this.verticalLayout1.setMargin(true);
        String labelInstruction1 = this.i18nService.getTranslation("TeacherToLearningGroupAssignmentDialog.label.instruction1", this.getLocale(), new Object[]{this.learnGroup.getLearnGroupname()});
        Span label1 = new Span(labelInstruction1);
        String labelInstruction2 = this.i18nService.getTranslation("TeacherToLearningGroupAssignmentDialog.label.instruction2", this.getLocale(), new Object[]{this.learnGroup.getLearnGroupname()});
        Span label2 = new Span(labelInstruction2);
        this.verticalLayout1.add(new Component[]{label1, label2});
        HorizontalLayout hLayoutGrids = new HorizontalLayout();
        hLayoutGrids.setSpacing(false);
        this.allTeacherDataProvider = new ListDataProvider((Collection)this.teacherListPerLearningGroup);
        this.assignedTeacherDataProvider = new ListDataProvider((Collection)this.teachersAssignedToLearningGroup);
        this.gridAllTeacher = new Grid();
        this.gridTeacherAssignedToLearningGroup = new Grid();
        this.createTeacherGrid(this.gridAllTeacher);
        this.createTeacherGrid(this.gridTeacherAssignedToLearningGroup);
        this.moveToLeftButton = new Button((Component)VaadinIcon.ARROW_LEFT.create());
        this.moveToLeftButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.moveToLeft());
        this.moveToRightButton = new Button((Component)VaadinIcon.ARROW_RIGHT.create());
        this.moveToRightButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.moveToRight());
        VerticalLayout moveButtonLayout = new VerticalLayout();
        moveButtonLayout.setSpacing(false);
        moveButtonLayout.setPadding(false);
        moveButtonLayout.setMargin(false);
        moveButtonLayout.setWidth("80px");
        moveButtonLayout.add(new Component[]{this.moveToRightButton, this.moveToLeftButton});
        hLayoutGrids.add(new Component[]{this.gridAllTeacher, moveButtonLayout, this.gridTeacherAssignedToLearningGroup});
        hLayoutGrids.setWidthFull();
        this.verticalLayout1.add(new Component[]{hLayoutGrids});
        this.gridAllTeacher.setWidthFull();
        this.gridAllTeacher.setSelectionMode(Grid.SelectionMode.MULTI);
        this.gridTeacherAssignedToLearningGroup.setWidthFull();
        this.gridTeacherAssignedToLearningGroup.setSelectionMode(Grid.SelectionMode.MULTI);
        HorizontalLayout hLayoutButton = new HorizontalLayout();
        this.saveButton = new Button(this.i18nService.getTranslation("TeacherToLearningGroupAssignmentDialog.button.save", this.getLocale(), new Object[0]));
        this.saveButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.saveTaskAssignments());
        this.cancelButton = new Button(this.i18nService.getTranslation("TeacherToLearningGroupAssignmentDialog.button.close", this.getLocale(), new Object[0]));
        this.cancelButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.cancel());
        HorizontalLayout hl = new HorizontalLayout();
        hl.add(new Component[]{this.cancelButton, this.saveButton});
        hLayoutButton.add(new Component[]{hl});
        hLayoutButton.setWidthFull();
        this.verticalLayout1.add(new Component[]{hLayoutButton});
        this.add(new Component[]{this.verticalLayout1});
        this.setWidthFull();
        this.saveButton.setEnabled(false);
        this.initLearningGroupTeacherAssigmentGrids();
    }

    private void moveToRight(Collection<Teacher> items) {
        boolean mustRefresh = false;
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        sb.append(this.i18nService.getTranslation("TeacherToLearningGroupAssignmentDialog.msg.added", this.getLocale(), new Object[0]));
        sb1.append(this.i18nService.getTranslation("TeacherToLearningGroupAssignmentDialog.msg.removed", this.getLocale(), new Object[0]));
        for (Teacher item : items) {
            if (!this.teachersAssignedToLearningGroup.contains(item)) {
                this.teachersAssignedToLearningGroup.add(item);
                sb.append(item.getFirstName() + " " + item.getLastName() + "\n");
                mustRefresh = true;
                this.enableSaveButton(true);
                continue;
            }
            logger.info("Item {} already LearningGroup", (Object)item);
            sb1.append(item.getFirstName() + " " + item.getLastName() + "\n");
        }
        if (mustRefresh) {
            ListDataProvider dataProvider = new ListDataProvider((Collection)this.teachersAssignedToLearningGroup);
            this.gridTeacherAssignedToLearningGroup.setDataProvider((DataProvider)dataProvider);
            this.gridTeacherAssignedToLearningGroup.getDataProvider().refreshAll();
            this.showNotificationMiddle(sb.toString(), 1);
        } else {
            this.showNotificationMiddle(sb1.toString(), 2);
        }
        this.gridAllTeacher.deselectAll();
    }

    private void enableSaveButton(boolean enabled) {
        this.saveButton.setEnabled(enabled);
    }

    private void enableSearchUi(boolean enabled) {
    }

    private void createTeacherGrid(Grid<Teacher> grid) {
        grid.setWidthFull();
        String gridheaderNumber = this.i18nService.getTranslation("TeacherToLearningGroupAssignmentDialog.gridheader.number", this.getLocale(), new Object[0]);
        String gridheaderGivenName = this.i18nService.getTranslation("TeacherToLearningGroupAssignmentDialog.gridheader.givenName", this.getLocale(), new Object[0]);
        String gridheaderLastName = this.i18nService.getTranslation("TeacherToLearningGroupAssignmentDialog.gridheader.lastName", this.getLocale(), new Object[0]);
        grid.addColumn(Teacher::getTeacherId).setHeader(gridheaderNumber);
        grid.addColumn(Teacher::getFirstName).setHeader(gridheaderGivenName);
        grid.addColumn(Teacher::getLastName).setHeader(gridheaderLastName);
    }

    private void initLearningGroupTeacherAssigmentGrids() {
        List allTeacherList = this.neo4JBaseService.getTeacherPerSchool(this.schoolId);
        this.allTeacherDataProvider.getItems().clear();
        this.allTeacherDataProvider.getItems().addAll(allTeacherList);
        this.gridAllTeacher.setDataProvider((DataProvider)this.allTeacherDataProvider);
        this.allTeacherDataProvider.refreshAll();
        List teacherAssignedToLearningGroupList = this.neo4JBaseService.getTeacherForLearningGroup(this.learnGroup.getGroupId());
        this.teachersAssignedToLearningGroup.clear();
        this.teachersAssignedToLearningGroup.addAll(teacherAssignedToLearningGroupList);
        ListDataProvider dataProviderAssignedTeacher = new ListDataProvider((Collection)teacherAssignedToLearningGroupList);
        this.gridTeacherAssignedToLearningGroup.setDataProvider((DataProvider)dataProviderAssignedTeacher);
        this.gridTeacherAssignedToLearningGroup.getDataProvider().refreshAll();
        if (this.comboBoxMessageStringBuilder == null) {
            this.comboBoxMessageStringBuilder = new StringBuilder();
        }
    }

    private void moveToLeft() {
        this.enableSaveButton(true);
        this.enableSearchUi(false);
        Set selectedItems = this.gridTeacherAssignedToLearningGroup.getSelectedItems();
        if (selectedItems == null || selectedItems.size() < 1) {
            String msg = this.i18nService.getTranslation("TeacherToLearningGroupAssignmentDialog.msg.selectTeacherRightGrid", this.getLocale(), new Object[0]);
            this.showNotificationMiddle(msg, 2);
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.i18nService.getTranslation("TeacherToLearningGroupAssignmentDialog.msg.removedTeacherFromLearningGroup", this.getLocale(), new Object[0]));
        for (Teacher item : selectedItems) {
            sb.append(item.getFirstName() + " " + item.getLastName() + "\n");
        }
        this.teachersAssignedToLearningGroup.removeAll(selectedItems);
        ListDataProvider dataProvider = new ListDataProvider((Collection)this.teachersAssignedToLearningGroup);
        this.gridTeacherAssignedToLearningGroup.setDataProvider((DataProvider)dataProvider);
        this.gridTeacherAssignedToLearningGroup.getDataProvider().refreshAll();
        this.gridTeacherAssignedToLearningGroup.deselectAll();
        this.showNotificationMiddle(sb.toString(), 2);
    }

    private void moveToRight() {
        this.enableSaveButton(true);
        this.enableSearchUi(false);
        Set selectedItems = this.gridAllTeacher.getSelectedItems();
        if (selectedItems == null || selectedItems.size() < 1) {
            String msg = this.i18nService.getTranslation("TeacherToLearningGroupAssignmentDialog.msg.selectTeacherLeftGrid", this.getLocale(), new Object[0]);
            this.showNotificationMiddle(msg, 2);
            return;
        }
        this.moveToRight((Collection)selectedItems);
    }

    private void saveTaskAssignments() {
        this.enableSaveButton(false);
        this.enableSearchUi(true);
        this.enableSaveButton(false);
        if (this.gridTeacherAssignedToLearningGroup.getDataProvider().size(new Query()) < 1) {
            String msg = this.i18nService.getTranslation("TeacherToLearningGroupAssignmentDialog.msg.oneTeacherMustBeAssgined", this.getLocale(), new Object[0]);
            this.showNotificationMiddle(msg, 2);
            return;
        }
        UI ui = UI.getCurrent();
        CompletableFuture<Void> voidCompletableFuture = CompletableFuture.runAsync(() -> {
            Neo4JTeacherToLearningGroupService taskService = VaadineoServiceHolder.getINSTANCE().getNeo4JTeacherToLearningGroupService();
            String groupId = this.learnGroup.getGroupId();
            HashSet studentsFromGrid = new HashSet(this.teachersAssignedToLearningGroup);
            logger.info("startUpdate for TaskId {} with Assigned Students Elements {} ", (Object)groupId, (Object)studentsFromGrid.size());
            CreateDeleteCounter counter = taskService.updateTeacherToLearningGroupConnections(groupId, studentsFromGrid);
            String msg = this.i18nService.getTranslation("TeacherToLearningGroupAssignmentDialog.msg.saveStatus", this.locale, new Object[]{counter.getCreated(), counter.getDeleted()});
            ui.access((Command & Serializable)() -> Notification.show((String)msg, (int)2000, (Notification.Position)Notification.Position.MIDDLE));
        });
        voidCompletableFuture.exceptionally(throwable -> {
            this.showNotificationMiddle(throwable.getMessage(), 2);
            return null;
        });
    }

    private void cancel() {
        this.close();
    }
}

