/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.dialogs;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.validator.AbstractValidator;
import de.mahlsdorf.groupservice.model.node.Tool;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.security.KeyPairGenerator;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseDialog;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.ToolView;
import de.mahlsdorf.groupservice.validator.ToolIdValidator;
import de.mahlsdorf.groupservice.validator.UrlVaadinValidator;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolDialog
extends BaseDialog {
    private static final Logger logger = LoggerFactory.getLogger(ToolDialog.class);
    private static final String MSG_KEY_DIALOGNAME = "ToolDialog.";
    private final String schoolId;
    private final ToolView toolView;
    private final Binder<Tool> binder;
    private transient Tool tool;
    private TextField toolIdTF;
    private TextField clientIdTF;
    private TextField deploymentIdTF;
    private TextField toolNameTF;
    private TextField toolDescriptionTF;
    private TextArea redirectionUrlTA;
    private TextField deepLinkingUrlTF;
    private TextField loginInitUrlTF;
    private TextField toolJwksUrlTF;
    private TextArea privateKeyAsPemTA;
    private TextArea publicKeyAsPemTA;
    private TextField keyIdTF;
    private TextField toolUrlTF;
    private Checkbox useNamesAndRolesCB;
    private Checkbox useAgsCB;
    private Button saveButton;
    private Button cancelButton;
    private Button newKeyPairButton;
    private boolean isNew = false;
    private Neo4JBaseService neo4JBaseService;
    private final I18nService i18nService;

    public ToolDialog(String schoolId, Tool tool, ToolView toolView, Neo4JBaseService neo4JBaseService) {
        this.schoolId = schoolId;
        this.tool = tool;
        this.toolView = toolView;
        this.binder = new Binder(Tool.class);
        this.i18nService = I18nService.getInstance();
        this.neo4JBaseService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        this.initLayout();
    }

    private void initLayout() {
        if (this.tool == null) {
            this.tool = new Tool();
            this.isNew = true;
        }
        this.setCloseOnOutsideClick(false);
        this.setCloseOnEsc(false);
        FormLayout formLayout = new FormLayout();
        this.toolIdTF = new TextField(this.i18nService.getTranslation("ToolDialog.label.toolId", this.getLocale(), new Object[0]));
        this.toolIdTF.setRequired(true);
        this.clientIdTF = new TextField(this.i18nService.getTranslation("ToolDialog.label.clientId", this.getLocale(), new Object[0]));
        this.clientIdTF.setRequired(true);
        this.deploymentIdTF = new TextField(this.i18nService.getTranslation("ToolDialog.label.deploymentId", this.getLocale(), new Object[0]));
        this.deploymentIdTF.setRequired(true);
        this.toolNameTF = new TextField(this.i18nService.getTranslation("ToolDialog.label.toolName", this.getLocale(), new Object[0]));
        this.toolNameTF.setRequired(true);
        this.toolDescriptionTF = new TextField(this.i18nService.getTranslation("ToolDialog.label.description", this.getLocale(), new Object[0]));
        this.toolDescriptionTF.setRequired(true);
        this.redirectionUrlTA = new TextArea(this.i18nService.getTranslation("ToolDialog.label.redirectUrls", this.getLocale(), new Object[0]));
        this.redirectionUrlTA.setRequired(true);
        this.deepLinkingUrlTF = new TextField(this.i18nService.getTranslation("ToolDialog.label.deeplinkingUrl", this.getLocale(), new Object[0]));
        this.deepLinkingUrlTF.setRequired(true);
        this.loginInitUrlTF = new TextField(this.i18nService.getTranslation("ToolDialog.label.loginitUrl", this.getLocale(), new Object[0]));
        this.loginInitUrlTF.setRequired(true);
        this.toolJwksUrlTF = new TextField(this.i18nService.getTranslation("ToolDialog.label.jwksToolUrl", this.getLocale(), new Object[0]));
        this.toolJwksUrlTF.setRequired(true);
        this.toolUrlTF = new TextField(this.i18nService.getTranslation("ToolDialog.label.toolUrl", this.getLocale(), new Object[0]));
        this.privateKeyAsPemTA = new TextArea(this.i18nService.getTranslation("ToolDialog.label.privateKeyPEM", this.getLocale(), new Object[0]));
        this.privateKeyAsPemTA.setRequired(true);
        this.privateKeyAsPemTA.setHeight("150px");
        this.privateKeyAsPemTA.setWidthFull();
        this.privateKeyAsPemTA.setReadOnly(true);
        this.publicKeyAsPemTA = new TextArea(this.i18nService.getTranslation("ToolDialog.label.publicKeyPEM", this.getLocale(), new Object[0]));
        this.publicKeyAsPemTA.setRequired(true);
        this.publicKeyAsPemTA.setHeight("150px");
        this.publicKeyAsPemTA.setWidthFull();
        this.publicKeyAsPemTA.setReadOnly(true);
        this.keyIdTF = new TextField(this.i18nService.getTranslation("ToolDialog.label.keyId", this.getLocale(), new Object[0]));
        this.useNamesAndRolesCB = new Checkbox(this.i18nService.getTranslation("ToolDialog.label.useNamesAndRoles", this.getLocale(), new Object[0]));
        this.useAgsCB = new Checkbox(this.i18nService.getTranslation("ToolDialog.label.useAgs", this.getLocale(), new Object[0]));
        this.redirectionUrlTA.setHeight("150px");
        this.redirectionUrlTA.setWidthFull();
        this.redirectionUrlTA.setPlaceholder("redirectUrls separated bey \\n");
        this.redirectionUrlTA.setValue("redirectUrls separated by \\n");
        formLayout.add(new Component[]{this.toolIdTF, this.deploymentIdTF, this.toolUrlTF, this.toolNameTF, this.toolDescriptionTF, this.clientIdTF, this.keyIdTF, this.deepLinkingUrlTF, this.loginInitUrlTF, this.redirectionUrlTA, this.privateKeyAsPemTA, this.publicKeyAsPemTA, this.toolJwksUrlTF, this.useNamesAndRolesCB, this.useAgsCB});
        this.saveButton = new Button(this.i18nService.getTranslation("ToolDialog.button.save", this.getLocale(), new Object[0]));
        this.saveButton.addClickListener((ComponentEventListener & Serializable)event -> this.save());
        this.cancelButton = new Button(this.i18nService.getTranslation("ToolDialog.button.cancel", this.getLocale(), new Object[0]));
        this.cancelButton.addClickListener((ComponentEventListener & Serializable)event -> this.cancel());
        this.newKeyPairButton = new Button(this.i18nService.getTranslation("ToolDialog.button.newKeyPair", this.getLocale(), new Object[0]));
        this.newKeyPairButton.addClickListener((ComponentEventListener & Serializable)event -> this.newKeyPair());
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.add(new Component[]{this.saveButton, this.newKeyPairButton, this.cancelButton});
        buttonLayout.setAlignItems(FlexComponent.Alignment.BASELINE);
        formLayout.add(new Component[]{buttonLayout});
        ToolIdValidator toolIdValidator = new ToolIdValidator("xx", this.isNew, this.getLocale(), this.neo4JBaseService);
        UrlVaadinValidator urlVaadinValidator = new UrlVaadinValidator("error", this.getLocale());
        this.bindNameField((AbstractSinglePropertyField)this.toolIdTF, (AbstractValidator)toolIdValidator, "toolId");
        this.bindNameField((AbstractSinglePropertyField)this.clientIdTF, null, "clientId");
        this.binder.bind((HasValue)this.deploymentIdTF, "deploymentId");
        this.bindNameField((AbstractSinglePropertyField)this.deploymentIdTF, null, "deploymentId");
        this.bindNameField((AbstractSinglePropertyField)this.toolNameTF, null, "toolName");
        this.bindNameField((AbstractSinglePropertyField)this.toolDescriptionTF, null, "toolDescription");
        this.bindNameField((AbstractSinglePropertyField)this.redirectionUrlTA, (AbstractValidator)urlVaadinValidator, "redirectUrls");
        this.bindNameField((AbstractSinglePropertyField)this.deepLinkingUrlTF, (AbstractValidator)urlVaadinValidator, "deeplinkUrl");
        this.bindNameField((AbstractSinglePropertyField)this.loginInitUrlTF, (AbstractValidator)urlVaadinValidator, "loginInitUrl");
        this.bindNameField((AbstractSinglePropertyField)this.toolJwksUrlTF, (AbstractValidator)urlVaadinValidator, "toolJwksUrl");
        this.bindNameField((AbstractSinglePropertyField)this.privateKeyAsPemTA, null, "privateKeyAsPem");
        this.bindNameField((AbstractSinglePropertyField)this.publicKeyAsPemTA, null, "publicKeyAsPem");
        this.bindNameField((AbstractSinglePropertyField)this.keyIdTF, null, "keyId");
        this.bindNameField((AbstractSinglePropertyField)this.toolUrlTF, (AbstractValidator)urlVaadinValidator, "toolUrl");
        this.binder.bind((HasValue)this.useNamesAndRolesCB, "useNamesAndRoles");
        this.binder.bind((HasValue)this.useAgsCB, "useAgs");
        this.binder.readBean((Object)this.tool);
        if (!this.isNew) {
            this.toolIdTF.setReadOnly(true);
            this.keyIdTF.setReadOnly(true);
        }
        if (this.isNew) {
            this.newKeyPair();
        }
        this.add(new Component[]{formLayout});
    }

    private void bindNameField(AbstractSinglePropertyField lastName, @Nullable AbstractValidator validator, String propertyName) {
        String required = this.i18nService.getTranslation("ToolDialog.msg.required", this.getLocale(), new Object[0]);
        if (validator != null) {
            this.binder.forField((HasValue)lastName).asRequired(required).withValidator((Validator)validator).bind(propertyName);
        } else {
            this.binder.forField((HasValue)lastName).asRequired("").bind(propertyName);
        }
    }

    private void save() {
        try {
            this.binder.writeBean((Object)this.tool);
        }
        catch (Exception e) {
            logger.info("Exception while getting task bean {}", (Object)this.tool);
            this.showNotificationMiddle(this.i18nService.getTranslation("ToolDialog.msg.exceptionWhileSaveTool", this.getLocale(), new Object[]{e.getMessage()}), 2);
            return;
        }
        logger.info("new Bean is {}", (Object)this.tool);
        if (this.tool == null) {
            this.tool = new Tool();
        }
        try {
            if (this.isNew) {
                this.neo4JBaseService.createToolAndRelation(this.tool, this.schoolId);
            } else {
                this.neo4JBaseService.updateTool(this.tool);
            }
            this.toolView.fillUpTheGrid();
            this.close();
        }
        catch (Exception e) {
            logger.error("cant create task ", (Throwable)e);
            this.showNotificationMiddle(this.i18nService.getTranslation("ToolDialog.button.exceptionWhileSaveTool", this.getLocale(), new Object[]{e.getMessage()}), 2);
        }
    }

    private void newKeyPair() {
        try {
            Tool tempTool = new Tool();
            tempTool = KeyPairGenerator.getInstance().createNewKeyPair(tempTool);
            this.tool.setPublicKeyAsPem(tempTool.getPublicKeyAsPem());
            this.tool.setPrivateKeyAsPem(tempTool.getPrivateKeyAsPem());
            this.tool.setKeyId(tempTool.getKeyId());
            this.binder.readBean((Object)this.tool);
        }
        catch (Exception e) {
            logger.error("exception while generating new KeyPair", (Throwable)e);
            this.showNotificationMiddle("Exception while generating new Keypair", 2);
        }
    }

    private void cancel() {
        this.close();
    }
}

