/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.dialogs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Pre;
import com.vaadin.flow.component.html.Span;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.node.Tool;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseDialog;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ToolInfoDialog
extends BaseDialog {
    private static final String MSG_KEY_DIALOGNAME = "ToolInfoDialog.";
    private final String hostUri;
    private final Tool tool;
    private final I18nService i18nService;

    public ToolInfoDialog(Tool tool, String hostUri) {
        this.tool = tool;
        this.hostUri = hostUri;
        this.i18nService = I18nService.getInstance();
        this.initLayout();
    }

    private void initLayout() {
        if (StringUtils.isEmpty((CharSequence)this.tool.getToolId())) {
            this.showNotificationMiddle(this.i18nService.getTranslation("ToolInfoDialog.msg.noToolId", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            return;
        }
        Div divBody = new Div();
        Span headlineSpan = new Span(new Component[]{new Span(this.i18nService.getTranslation("ToolInfoDialog.msg.headlineLMS", this.getLocale(), new Object[]{this.tool.getToolId()}))});
        divBody.add(new Component[]{headlineSpan});
        Pre clientIdPre = new Pre(this.i18nService.getTranslation("ToolInfoDialog.msg.clientId", this.getLocale(), new Object[]{this.tool.getClientId()}));
        Pre deploymentIdPre = new Pre(this.i18nService.getTranslation("ToolInfoDialog.msg.deploymentId", this.getLocale(), new Object[]{this.tool.getDeploymentId()}));
        Pre loginUrlPre = new Pre(this.i18nService.getTranslation("ToolInfoDialog.msg.loginUrl", this.getLocale(), new Object[]{this.hostUri, this.tool.getClientId()}));
        Pre accessTokenPre = new Pre(this.i18nService.getTranslation("ToolInfoDialog.msg.accessTokenUrl", this.getLocale(), new Object[]{this.hostUri, this.tool.getToolId()}));
        Pre jwksPre = new Pre(this.i18nService.getTranslation("ToolInfoDialog.msg.jwksUrl", this.getLocale(), new Object[]{this.hostUri, this.tool.getToolId()}));
        Pre jwksIssuerPre = new Pre(this.i18nService.getTranslation("ToolInfoDialog.msg.jwksIssuer", this.getLocale(), new Object[]{this.hostUri}));
        divBody.add(new Component[]{clientIdPre, deploymentIdPre, loginUrlPre, accessTokenPre, jwksPre, jwksIssuerPre});
        Button closeButton = new Button(this.i18nService.getTranslation("ToolInfoDialog.button.Close", this.getLocale(), new Object[0]));
        closeButton.addClickListener((ComponentEventListener & Serializable)click -> this.close());
        this.add(new Component[]{divBody});
        this.add(new Component[]{BaseView.generateButtonLayout(List.of(closeButton))});
    }
}

