/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.styling;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.function.SerializableBiConsumer;
import de.mahlsdorf.groupservice.model.node.Task;
import de.mahlsdorf.groupservice.service.groupservice.TaskIconUrlChecker;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

@org.springframework.stereotype.Component
public class TaskGridRenderer {
    public static final SerializableBiConsumer<Div, Task> pointRenderer = (SerializableBiConsumer & Serializable)(div, task) -> {
        if (task.getType().equals("LineItem")) {
            div.setText("");
        } else if ("headline".equals(task.getType()) || "url".equals(task.getType())) {
            div.setText("");
        } else {
            String divText = "" + task.getLtiLineItemMaxPoints();
            div.setText(divText);
        }
    };
    private TaskIconUrlChecker taskIconUrlChecker;
    public SerializableBiConsumer<Div, Task> taskIconRenderer = (SerializableBiConsumer & Serializable)(div, task) -> {
        if (StringUtils.isNotBlank((CharSequence)task.getLtiIconUrl())) {
            String urlOfIcon = this.taskIconUrlChecker.getTaskUrl(task.getLtiIconUrl());
            Image image = new Image(urlOfIcon, "TaskIcon");
            image.setHeight("20px");
            image.setWidth("20px");
            div.add(new Component[]{image});
        }
    };
    public static final SerializableBiConsumer<Div, Task> taskTypeRenderer = (SerializableBiConsumer & Serializable)(div, task) -> {
        if (task.getType().equals("headline")) {
            div.add("");
        } else {
            div.add(task.getType());
        }
    };
    public static final SerializableBiConsumer<Div, Task> taskTypeDescriptionRenderer = (SerializableBiConsumer & Serializable)(div, task) -> {
        if (task.getType().equals("headline")) {
            div.add("");
        } else {
            div.add(task.getDescription());
        }
    };
    public static final SerializableBiConsumer<Div, Task> taskTypeIdRenderer = (SerializableBiConsumer & Serializable)(div, task) -> {
        if (task.getType().equals("headline")) {
            div.add("");
        } else {
            div.add(task.getTaskId());
        }
    };

    public TaskGridRenderer(TaskIconUrlChecker taskUrl) {
        this.taskIconUrlChecker = taskUrl;
    }
}

