/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.utils;

import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableFunction;
import de.mahlsdorf.groupservice.model.node.Course;
import de.mahlsdorf.groupservice.model.node.Subject;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CourseUtils {
    private Neo4JBaseService neo4JBaseService;
    private String schoolId;
    private Map<String, Subject> allSubjectsMap = new HashMap();

    public CourseUtils(Neo4JBaseService neo4JBaseService, String schoolId) {
        this.neo4JBaseService = neo4JBaseService;
        this.schoolId = schoolId;
        this.refreshSubjectsMap();
    }

    public Map<String, Subject> refreshSubjectsMap() {
        List allSubjects = this.neo4JBaseService.findSubjectsBySchoolId(this.schoolId);
        this.allSubjectsMap.clear();
        for (Subject subject : allSubjects) {
            this.allSubjectsMap.put(subject.getSubjectId(), subject);
        }
        return new HashMap<String, Subject>(this.allSubjectsMap);
    }

    public SerializableBiConsumer<Div, Course> getCourseSubjectRenderer() {
        return (SerializableBiConsumer & Serializable)(div, course) -> {
            if (this.allSubjectsMap.get(course.getSubjectId()) == null) {
                div.setText("removed");
            } else {
                div.setText(((Subject)this.allSubjectsMap.get(course.getSubjectId())).getSubjectName());
            }
        };
    }

    public SerializableFunction<Course, String> getSubjectToolTipRenderer() {
        return (SerializableFunction & Serializable)course -> {
            if (this.allSubjectsMap.get(course.getSubjectId()) == null) {
                return "removed";
            }
            return ((Subject)this.allSubjectsMap.get(course.getSubjectId())).getDescription();
        };
    }
}

