/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.views.school;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.validator.RegexpValidator;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.BeforeLeaveObserver;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.spring.annotation.UIScope;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.node.School;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.security.CryptDecryptHelper;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import de.mahlsdorf.groupservice.ui.layout.views.school.SchoolFormLayoutBuilder;
import java.io.Serializable;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Route(value="createSchool", layout=MainAppLayout.class)
@Component
@UIScope
public class CreateSchoolView
extends BaseView
implements BeforeLeaveObserver {
    private static final Logger LOG = LoggerFactory.getLogger(CreateSchoolView.class);
    public static final String MSG_KEY_VIEWNAME = "CreateSchoolView.";
    private final Neo4JBaseService neo4JBaseService;
    private final I18nService i18nService;
    private static final String LAYOUT_WIDTH = "80%";
    private final Binder<Teacher> teacherBinder = new Binder(Teacher.class);
    private final Binder<School> schoolBinder = new Binder(School.class);
    private final School schoolToCreate = new School();
    private final Teacher teacherToCreate = new Teacher();
    private TextField lastNameTF;
    private TextField firstNameTF;
    private Checkbox isAdminCheckBox;
    private TextField loginNameTF;
    private PasswordField password1PF;
    private PasswordField password2PF;
    private boolean isInitalized = false;

    public CreateSchoolView() {
        this.i18nService = I18nService.getInstance();
        this.neo4JBaseService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        this.initLayout();
    }

    public void beforeEnter(BeforeEnterEvent var1) {
        this.initLayout();
    }

    public void beforeLeave(BeforeLeaveEvent event) {
        this.showNotificationMiddle("you want to leave check that school and teacher exists ", 3);
    }

    private void initLayout() {
        if (this.isInitalized) {
            return;
        }
        this.removeAll();
        try {
            VerticalLayout allVLayout = new VerticalLayout();
            HorizontalLayout allHLayout = new HorizontalLayout();
            this.setWidth("100%");
            VerticalLayout vLayoutSchool = new VerticalLayout();
            vLayoutSchool.setWidth(LAYOUT_WIDTH);
            VerticalLayout vLayoutTeacher = new VerticalLayout();
            vLayoutTeacher.setWidth(LAYOUT_WIDTH);
            Span infoLabelSchool = new Span(this.i18nService.getTranslation(MSG_KEY_VIEWNAME.concat("label.").concat("School"), this.getLocale(), new Object[0]));
            FormLayout formLayoutSchool = this.createFormLayoutSchool();
            vLayoutSchool.add(new com.vaadin.flow.component.Component[]{infoLabelSchool, formLayoutSchool});
            Span infoLabelTeacher = new Span(this.i18nService.getTranslation(MSG_KEY_VIEWNAME.concat("label.").concat("Teacher"), this.getLocale(), new Object[0]));
            FormLayout formLayoutTeacher = this.createFormLayoutTeacher();
            vLayoutTeacher.add(new com.vaadin.flow.component.Component[]{infoLabelTeacher, formLayoutTeacher});
            Button createButton = new Button(this.i18nService.getTranslation("CreateSchoolView.button.save", this.getLocale(), new Object[0]));
            createButton.setId("buttonCreateId");
            allHLayout.add(new com.vaadin.flow.component.Component[]{vLayoutSchool, vLayoutTeacher});
            HorizontalLayout hLayoutButton = new HorizontalLayout();
            hLayoutButton.add(new com.vaadin.flow.component.Component[]{createButton});
            allVLayout.add(new com.vaadin.flow.component.Component[]{allHLayout, hLayoutButton});
            this.add(new com.vaadin.flow.component.Component[]{allVLayout});
            createButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.createSchoolAndTeacher());
            this.isInitalized = true;
        }
        catch (Exception e) {
            LOG.error("Exception during create of layout  ", (Throwable)e);
        }
    }

    private void createSchoolAndTeacher() {
        try {
            this.teacherBinder.writeBean((Object)this.teacherToCreate);
            this.schoolBinder.writeBean((Object)this.schoolToCreate);
            this.teacherToCreate.setTeacherId(UUID.randomUUID().toString());
            this.schoolToCreate.setSchoolId(UUID.randomUUID().toString());
            Teacher foundTeacher = this.neo4JBaseService.findTeacherByLoginName(this.teacherToCreate.getLoginName());
            if (foundTeacher != null) {
                this.showNotificationMiddle(this.i18nService.getTranslation("CreateSchoolView.msg.loginNameExists", this.getLocale(), new Object[]{this.teacherToCreate.getLoginName()}), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
                return;
            }
            if (!this.password1PF.getValue().equals(this.password2PF.getValue())) {
                this.showNotificationMiddle(this.i18nService.getTranslation("CreateSchoolView.msg.newPasswordsDifferent", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
                return;
            }
            this.teacherToCreate.setPassword(CryptDecryptHelper.cryptString((String)this.password1PF.getValue()));
            try {
                this.neo4JBaseService.createTeacherAndSchool(this.schoolToCreate, this.teacherToCreate);
            }
            catch (Exception e) {
                LOG.error("Exception while create teacher and school {}", (Object)e.getMessage(), (Object)e);
                this.showNotificationMiddle(this.i18nService.getTranslation("CreateSchoolView.msg.loginNameExists", this.getLocale(), new Object[]{this.teacherToCreate.getLoginName()}), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
                return;
            }
            this.showNotificationMiddle(this.i18nService.getTranslation("CreateSchoolView.msg.Saved", this.getLocale(), new Object[0]), 2);
            this.navigateToHome();
        }
        catch (Exception e) {
            LOG.error("Exception while validaating and saving teacher {} and School {} ", new Object[]{this.teacherToCreate, this.schoolToCreate, e});
            this.showNotificationMiddle(e.getMessage(), ConstantsNeoc.Durations.DURATION_SHORT.intValue());
        }
    }

    private void navigateToHome() {
        UI.getCurrent().navigate("home");
    }

    private FormLayout createFormLayoutSchool() {
        return SchoolFormLayoutBuilder.getInstance().createFormLayoutSchool(this.schoolBinder);
    }

    private FormLayout createFormLayoutTeacher() {
        FormLayout formLayout = new FormLayout();
        String labelFirstName = this.i18nService.getTranslation("CreateSchoolView.label.givenName", this.getLocale(), new Object[0]);
        this.firstNameTF = this.createTextField(labelFirstName, "tfTeacherFNId");
        String labelLastName = this.i18nService.getTranslation("CreateSchoolView.label.lastName", this.getLocale(), new Object[0]);
        this.lastNameTF = this.createTextField(labelLastName, "tfTeacherLNId");
        String labelLoginName = this.i18nService.getTranslation("CreateSchoolView.label.loginName", this.getLocale(), new Object[0]);
        this.loginNameTF = this.createTextField(labelLoginName, "tfTeacherLoginNId");
        String labelAdmin = this.i18nService.getTranslation("CreateSchoolView.label.isAdmin", this.getLocale(), new Object[0]);
        this.password1PF = new PasswordField(this.i18nService.getTranslation("CreateSchoolView.label.Password1", this.getLocale(), new Object[0]));
        this.password1PF.setId("tfTeacherPword1Id");
        this.password2PF = new PasswordField(this.i18nService.getTranslation("CreateSchoolView.label.Password2", this.getLocale(), new Object[0]));
        this.password2PF.setId("tfTeacherPword2Id");
        this.isAdminCheckBox = new Checkbox();
        this.isAdminCheckBox.setLabel(labelAdmin);
        this.isAdminCheckBox.setValue((Object)true);
        this.isAdminCheckBox.setEnabled(false);
        formLayout.add(new com.vaadin.flow.component.Component[]{this.firstNameTF, this.lastNameTF, this.loginNameTF, this.isAdminCheckBox, this.password1PF, this.password2PF});
        String validatorMessage = this.i18nService.getTranslation("CreateSchoolView.msg.nameRegex", this.getLocale(), new Object[0]);
        this.bindNameField(this.teacherBinder, this.firstNameTF, validatorMessage, "[\\w\\\u00e4\\\u00f6\\\u00fc\\\u00c4\\\u00d6\\\u00dc]{1,}[\\w\\\u00e4\\\u00f6\\\u00fc\\\u00c4\\\u00d6\\\u00dc\\s.]{1,}", "firstName");
        this.bindNameField(this.teacherBinder, this.lastNameTF, validatorMessage, "[\\w\\\u00e4\\\u00f6\\\u00fc\\\u00c4\\\u00d6\\\u00dc]{1,}[\\w\\\u00e4\\\u00f6\\\u00fc\\\u00c4\\\u00d6\\\u00dc\\s.]{1,}", "lastName");
        this.bindNameField(this.teacherBinder, this.loginNameTF, validatorMessage, "[\\w\\\u00e4\\\u00f6\\\u00fc\\\u00c4\\\u00d6\\\u00dc]{1,}[\\w\\\u00e4\\\u00f6\\\u00fc\\\u00c4\\\u00d6\\\u00dc\\s.]{1,}", "loginName");
        this.teacherBinder.forField((HasValue)this.isAdminCheckBox).bind("admin");
        formLayout.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 1, FormLayout.ResponsiveStep.LabelsPosition.TOP)});
        return formLayout;
    }

    private void bindNameField(Binder binder, TextField textfield, String validatorMessage, String pattern, String propertyName) {
        binder.forField((HasValue)textfield).asRequired(validatorMessage).withValidator((Validator)new RegexpValidator(validatorMessage, pattern)).bind(propertyName);
        LOG.info("Bind PropertyName {} ", (Object)propertyName);
    }

    TextField createTextField(String label, String id) {
        TextField result = new TextField();
        result.setLabel(label);
        result.setPlaceholder(label);
        result.setId(id);
        return result;
    }
}

