/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.views.school;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.BinderValidationStatus;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.spring.annotation.UIScope;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.node.School;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.service.ui.ServiceLoader;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import de.mahlsdorf.groupservice.ui.layout.views.school.SchoolFormLayoutBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Route(value="editSchools", layout=MainAppLayout.class)
@Component
@UIScope
public class EditSchoolView
extends BaseView {
    private static final Logger LOG = LoggerFactory.getLogger(EditSchoolView.class);
    public static final String MSG_KEY_VIEWNAME = "EditSchoolView.";
    private I18nService i18nService;
    private Neo4JBaseService neo4JBaseService;
    private final Binder<School> schoolBinder = new Binder(School.class);

    public EditSchoolView() {
        this.neo4JBaseService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        this.i18nService = I18nService.getInstance();
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    public void beforeEnter(BeforeEnterEvent var1) {
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    private void initLayout() {
        this.removeAll();
        Span infoLabel = new Span("EditSchoolView ");
        this.add(new com.vaadin.flow.component.Component[]{infoLabel});
        School school1 = this.mainLayoutUI.getSchool();
        FormLayout schoolFormLayout = SchoolFormLayoutBuilder.getInstance().createFormLayoutSchool(this.schoolBinder);
        this.add(new com.vaadin.flow.component.Component[]{schoolFormLayout});
        this.schoolBinder.readBean((Object)school1);
        VerticalLayout vLayout = new VerticalLayout();
        HorizontalLayout hLayoutButtons = new HorizontalLayout();
        Button buttonSave = new Button(this.i18nService.getTranslation("EditSchoolView.button.Save", this.getLocale(), new Object[0]));
        buttonSave.setId("buttonSaveId");
        buttonSave.addClickListener((ComponentEventListener & Serializable)click -> this.saveSchool());
        Button buttonDelete = new Button(this.i18nService.getTranslation("EditSchoolView.button.Delete", this.getLocale(), new Object[0]));
        buttonDelete.addClickListener((ComponentEventListener & Serializable)click -> this.deleteSchoolStart());
        buttonDelete.setId("buttonDeleteId");
        hLayoutButtons.add(new com.vaadin.flow.component.Component[]{buttonSave, buttonDelete});
        vLayout.add(new com.vaadin.flow.component.Component[]{infoLabel, schoolFormLayout, hLayoutButtons});
        if (!this.loggedInTeacher.getAdmin().booleanValue()) {
            EditSchoolView.disableButtons(List.of(buttonSave, buttonDelete));
        }
        this.add(new com.vaadin.flow.component.Component[]{vLayout});
    }

    private void deleteSchoolStart() {
        this.createConfirmDialog();
    }

    private void saveSchool() {
        try {
            School schoolBean = new School();
            BinderValidationStatus validationStatus = this.schoolBinder.validate();
            if (LOG.isInfoEnabled()) {
                LOG.info(validationStatus.getValidationErrors().toString());
            }
            this.schoolBinder.writeBean((Object)schoolBean);
            schoolBean.setSchoolId(this.mainLayoutUI.getSchoolId());
            this.neo4JBaseService.saveSchoolWithTx(schoolBean, null);
            this.mainLayoutUI.setSchool(schoolBean);
            this.showNotificationMiddle(this.i18nService.getTranslation("EditSchoolView.msg.Saved", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
        }
        catch (Exception e) {
            this.showNotificationMiddle("Error while saving school " + e.getMessage(), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            LOG.error("Exception while saving school {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void deleteSchool() {
        this.neo4JBaseService.deleteSchool(this.school.getSchoolId());
        LOG.info("Deleted School {}", (Object)this.school);
        this.showNotificationMiddle(this.i18nService.getTranslation("EditSchoolView.msg.schoolDeleted", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
        this.mainLayoutUI.doLogout();
    }

    private void createConfirmDialog() {
        Dialog dialog = new Dialog();
        String question = this.i18nService.getTranslation("EditSchoolView.msg.reallyDeleteSchool", this.getLocale(), new Object[0]);
        Button deleteButton = new Button(this.i18nService.getTranslation("EditSchoolView.button.dialogDelete", this.getLocale(), new Object[0]));
        deleteButton.addClickListener((ComponentEventListener & Serializable)click -> this.deleteSchool());
        deleteButton.setId("buttonConfirmId");
        deleteButton.addClickListener((ComponentEventListener & Serializable)click -> dialog.close());
        Button cancelButton = new Button(this.i18nService.getTranslation("EditSchoolView.button.dialogCancel", this.getLocale(), new Object[0]));
        cancelButton.setId("buttonCloseId");
        cancelButton.addClickListener((ComponentEventListener & Serializable)click -> dialog.close());
        dialog.add(new com.vaadin.flow.component.Component[]{this.createConfirmDialogLayout(question, List.of(deleteButton, cancelButton))});
        dialog.open();
    }

    private void assignServices() {
        this.neo4JBaseService = (Neo4JBaseService)ServiceLoader.get(Neo4JBaseService.class);
        this.i18nService = (I18nService)ServiceLoader.get(I18nService.class);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.assignServices();
    }
}

