/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.views.school;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.validator.RegexpValidator;
import de.mahlsdorf.groupservice.model.node.School;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import java.util.Locale;

public class SchoolFormLayoutBuilder {
    private static final String MSG_KEY_VIEWNAME = "CreateSchoolView.";
    private static SchoolFormLayoutBuilder INSTANCE;
    private final I18nService i18nService = I18nService.getInstance();

    private SchoolFormLayoutBuilder() {
    }

    static SchoolFormLayoutBuilder getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SchoolFormLayoutBuilder();
        }
        return INSTANCE;
    }

    public FormLayout createFormLayoutSchool(Binder<School> schoolBinder) {
        FormLayout formLayout = new FormLayout();
        String schoolNameLabel = this.i18nService.getTranslation("CreateSchoolView.label.SchoolName", this.getLocale(), new Object[0]);
        TextField schoolNameTF = this.createTextField(schoolNameLabel);
        schoolNameTF.setId("tfSchoolNameId");
        String labelZip = this.i18nService.getTranslation("CreateSchoolView.label.SchoolZip", this.getLocale(), new Object[0]);
        TextField schoolZipTF = this.createTextField(labelZip);
        schoolZipTF.setId("tfSchoolZipId");
        String labelLocation = this.i18nService.getTranslation("CreateSchoolView.label.Location", this.getLocale(), new Object[0]);
        TextField locationTF = this.createTextField(labelLocation);
        locationTF.setId("tfSchoolLocationId");
        String labelStreet = this.i18nService.getTranslation("CreateSchoolView.label.Street", this.getLocale(), new Object[0]);
        TextField streetTF = this.createTextField(labelStreet);
        streetTF.setId("tfSchoolStreetId");
        String labelStreetNumber = this.i18nService.getTranslation("CreateSchoolView.label.StreetNumber", this.getLocale(), new Object[0]);
        TextField streetNumberTF = this.createTextField(labelStreetNumber);
        streetNumberTF.setId("tfSchoolStreetNumberId");
        String labelCountry = this.i18nService.getTranslation("CreateSchoolView.label.Country", this.getLocale(), new Object[0]);
        TextField countryTF = this.createTextField(labelCountry);
        countryTF.setId("tfSchoolCountryId");
        String labelBackgroudImage = this.i18nService.getTranslation("CreateSchoolView.label.BackgroundImage", this.getLocale(), new Object[0]);
        TextField backgroundTF = this.createTextField(labelBackgroudImage);
        backgroundTF.setId("tfSchoolBackgroundImage");
        formLayout.add(new Component[]{schoolNameTF, schoolZipTF, locationTF, streetTF, streetNumberTF, countryTF, backgroundTF});
        formLayout.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 1, FormLayout.ResponsiveStep.LabelsPosition.TOP)});
        String validatorMessageSchoolName = this.i18nService.getTranslation("CreateSchoolView.msg.schoolNameRegex", this.getLocale(), new Object[0]);
        String validatorMessageZip = this.i18nService.getTranslation("CreateSchoolView.msg.zipRegex", this.getLocale(), new Object[0]);
        String validatorMessageBackgroundImage = this.i18nService.getTranslation("CreateSchoolView.msg.backgroundImageRegEx", this.getLocale(), new Object[0]);
        this.bindNameField(schoolBinder, schoolNameTF, validatorMessageSchoolName, "[\\w\\\u00e4\\\u00f6\\\u00fc\\\u00c4\\\u00d6\\\u00dc\\,\\-\\.\\d\\s]{10,}[\\w\\\u00e4\\\u00f6\\\u00fc\\\u00c4\\\u00d6\\\u00dc\\,\\-\\.\\d\\s\\s.]*", "name");
        this.bindNameField(schoolBinder, schoolZipTF, validatorMessageZip, "[\\d]{5}", "zip");
        this.bindNameField(schoolBinder, locationTF, "location");
        this.bindNameField(schoolBinder, streetTF, "street");
        this.bindNameField(schoolBinder, streetNumberTF, "streetNumber");
        this.bindNameField(schoolBinder, countryTF, "country");
        this.bindNameField(schoolBinder, backgroundTF, "backgroundImage");
        return formLayout;
    }

    private Locale getLocale() {
        return UI.getCurrent().getLocale();
    }

    private void bindNameField(Binder<School> binder, TextField textfield, String validatorMessage, String pattern, String propertyName) {
        binder.forField((HasValue)textfield).asRequired(validatorMessage).withValidator((Validator)new RegexpValidator(validatorMessage, pattern)).bind(propertyName);
    }

    private void bindNameField(Binder<School> binder, TextField textfield, String propertyName) {
        binder.forField((HasValue)textfield).bind(propertyName);
    }

    TextField createTextField(String label) {
        TextField result = new TextField();
        result.setLabel(label);
        result.setPlaceholder(label);
        return result;
    }
}

