/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.views.students;

import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.spring.annotation.UIScope;
import de.mahlsdorf.groupservice.model.node.Course;
import de.mahlsdorf.groupservice.model.node.Task;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.groupservice.TaskIconUrlChecker;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.styling.TaskGridRenderer;
import de.mahlsdorf.groupservice.ui.layout.styling.TaskGridStyler;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.HomeView;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Route(value="studentCoursesTasks/courseId:", layout=MainAppLayout.class)
@Component
@UIScope
public class StudentCourseTaskView
extends BaseView
implements HasUrlParameter<String> {
    private static final Logger logger = LoggerFactory.getLogger(StudentCourseTaskView.class);
    private static final String MSG_KEY_VIEWNAME = "StudentCourseTaskView.";
    public static final String STRUCTURE = "Structure";
    private final Neo4JBaseService neo4JBaseService;
    private Grid<Task> taskGrid;
    private String courseParameter;
    private final I18nService i18nService = I18nService.getInstance();
    private final TaskIconUrlChecker taskUrl;

    public StudentCourseTaskView(TaskIconUrlChecker taskUrl) {
        this.neo4JBaseService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        this.taskUrl = taskUrl;
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    public void setParameter(BeforeEvent event, String parameter) {
        logger.info("Parameter '{}'", (Object)parameter);
        this.courseParameter = parameter;
        this.isUserLoggedInOrNavigateToHome();
        this.initLayout();
    }

    public void beforeEnter(BeforeEnterEvent var1) {
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    private void initLayout() {
        if (this.mainLayoutUI == null || this.mainLayoutUI.getLoggedInStudent() == null) {
            UI.getCurrent().navigate("home");
            return;
        }
        this.removeAll();
        try {
            this.setWidth("100%");
            VerticalLayout verticalLayout1 = new VerticalLayout();
            verticalLayout1.add(new com.vaadin.flow.component.Component[]{this.getLoggedInInfoLayout()});
            if (StringUtils.isEmpty((CharSequence)this.courseParameter) && (this.mainLayoutUI == null || StringUtils.isEmpty((CharSequence)this.mainLayoutUI.getCourseId()))) {
                this.showNotificationMiddle(this.i18nService.getTranslation("StudentCourseTaskView.msg.noCourseSelected", this.getLocale(), new Object[0]), 2);
                this.getUI().ifPresent(ui -> ui.navigate(HomeView.class));
                return;
            }
            verticalLayout1.setWidth("100%");
            verticalLayout1.setSizeFull();
            this.taskGrid = new Grid();
            Html courseLabel = this.createCourseLabel();
            this.createCoursesGrid(this.taskGrid);
            verticalLayout1.add(new com.vaadin.flow.component.Component[]{courseLabel, this.taskGrid});
            this.add(new com.vaadin.flow.component.Component[]{verticalLayout1});
            Dimension dim = this.getBrowserDimension();
            verticalLayout1.setHeight(Math.round((double)dim.height * 0.9) + "px");
            this.refreshGrid();
        }
        catch (Exception e) {
            logger.error("Exception in initLayout ", (Throwable)e);
            this.isUserLoggedInOrNavigateToHome();
        }
    }

    private Html createCourseLabel() {
        try {
            String courseLabel = this.i18nService.getTranslation("StudentCourseTaskView.label.course", this.getLocale(), new Object[0]);
            Course course = this.neo4JBaseService.findCourseById(this.mainLayoutUI.getCourseId());
            return new Html("<div><b>" + courseLabel + ":</b>" + course.getName() + " [" + course.getComment() + "] (" + course.getSubject() + ")</div>");
        }
        catch (Exception e) {
            String msg = this.i18nService.getTranslation("StudentCourseTaskView.msg.exceptionCreateCourseLabel", this.getLocale(), new Object[]{e.getMessage()});
            logger.error(msg, (Throwable)e);
            this.showNotificationMiddle(msg, 2);
            return null;
        }
    }

    private void createCoursesGrid(Grid<Task> grid) {
        SerializableBiConsumer & Serializable launchRenderer = (SerializableBiConsumer & Serializable)(div, task) -> {
            if (task.getType().equals("LineItem")) {
                div.setText("");
            } else if ("headline".equals(task.getType())) {
                String text = task.getName();
                div.add(text);
            } else {
                String divText = "/platformapi/v1/launch?taskId=" + task.getTaskId() + "&userId=" + this.getLoggedInStudent().getStudentId();
                Anchor anchor = new Anchor();
                anchor.setHref(divText);
                anchor.setText(task.getName());
                anchor.setTarget("_myWindow");
                div.add(new com.vaadin.flow.component.Component[]{anchor});
            }
        };
        String userNumber = this.mainLayoutUI.getLoggedInStudentNumber();
        grid.setWidthFull();
        grid.addColumn(Task::getStructure).setHeader(STRUCTURE).setSortable(true).setFlexGrow(0).setAutoWidth(true).setKey(STRUCTURE).setId(STRUCTURE);
        grid.addColumn((Renderer)new ComponentRenderer(Div::new, new TaskGridRenderer((TaskIconUrlChecker)this.taskUrl).taskIconRenderer)).setHeader("icon").setFlexGrow(0).setAutoWidth(true);
        ((Grid.Column)grid.addColumn((Renderer)new ComponentRenderer(Div::new, (SerializableBiConsumer)launchRenderer)).setHeader("launch").setResizable(true)).setSortable(true).setFlexGrow(1);
        String gridheaderDescription = this.i18nService.getTranslation("StudentCourseTaskView.gridheader.description", this.getLocale(), new Object[0]);
        String gridheaderMaxPoints = this.i18nService.getTranslation("StudentCourseTaskView.gridheader.maxPoints", this.getLocale(), new Object[0]);
        String gridheaderType = this.i18nService.getTranslation("StudentCourseTaskView.gridheader.type", this.getLocale(), new Object[0]);
        String gridheaderStructure = this.i18nService.getTranslation("StudentCourseTaskView.gridheader.structure", this.getLocale(), new Object[0]);
        ((Grid.Column)grid.addColumn((Renderer)new ComponentRenderer(Div::new, TaskGridRenderer.taskTypeDescriptionRenderer)).setHeader(gridheaderDescription).setTooltipGenerator(Task::getDescription).setResizable(true)).setSortable(true).setFlexGrow(1);
        grid.addColumn((Renderer)new ComponentRenderer(Div::new, TaskGridRenderer.pointRenderer)).setHeader(gridheaderMaxPoints).setSortable(true).setFlexGrow(0).setAutoWidth(true);
        grid.addColumn((Renderer)new ComponentRenderer(Div::new, TaskGridRenderer.taskTypeIdRenderer)).setHeader(gridheaderType).setSortable(true).setFlexGrow(0).setAutoWidth(true);
        Grid.Column sortCol = grid.getColumnByKey(STRUCTURE);
        sortCol.setHeader(gridheaderStructure);
        GridSortOrder order = new GridSortOrder(sortCol, SortDirection.ASCENDING);
        grid.sort(Collections.singletonList(order));
        grid.setClassNameGenerator((SerializableFunction)new TaskGridStyler());
    }

    private void refreshGrid() {
        try {
            String courseId = this.courseParameter;
            if (StringUtils.isEmpty((CharSequence)this.courseParameter)) {
                logger.info("looking for tasks in {}  and course {} ", (Object)this.mainLayoutUI.getLoggedInStudent().getStudentId(), (Object)this.mainLayoutUI.getCourseId());
                courseId = this.mainLayoutUI.getCourseId();
            }
            ArrayList foundCourses = this.neo4JBaseService.getTasksPerStudentAndCourse(this.mainLayoutUI.getLoggedInStudent().getStudentId(), courseId);
            List headlines = this.neo4JBaseService.getHeadlinesByCourse(courseId);
            foundCourses.addAll(headlines);
            List filteredTasks = foundCourses.stream().filter(v -> !"LineItem".equals(v.getType())).collect(Collectors.toList());
            foundCourses = new ArrayList(filteredTasks);
            BeanComparator comperator = new BeanComparator("structure");
            Collections.sort(foundCourses, comperator);
            ListDataProvider dataProvider = new ListDataProvider(foundCourses);
            this.taskGrid.setDataProvider((DataProvider)dataProvider);
        }
        catch (Exception e) {
            logger.error("Exception while getting Tasks ", (Throwable)e);
            this.showNotificationMiddle(this.i18nService.getTranslation("StudentCourseTaskView.msg.exceptionSearchTasks", this.getLocale(), new Object[]{e.getMessage()}), 2);
        }
    }
}

