/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.views.students;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.spring.annotation.UIScope;
import de.mahlsdorf.groupservice.model.node.Course;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.utils.CourseUtils;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import de.mahlsdorf.groupservice.ui.layout.views.students.StudentCourseTaskView;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Route(value="studentCourses", layout=MainAppLayout.class)
@Component
@UIScope
public class StudentCourseView
extends BaseView {
    private static final Logger logger = LoggerFactory.getLogger(StudentCourseView.class);
    private static final String MSG_KEY_VIEWNAME = "StudentCourseView.";
    private Grid<Course> courseGrid;
    private final Neo4JBaseService neo4JBaseService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
    private final I18nService i18nService = I18nService.getInstance();

    public StudentCourseView() {
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    public void beforeEnter(BeforeEnterEvent var1) {
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    private void initLayout() {
        this.removeAll();
        this.setWidth("100%");
        VerticalLayout verticalLayout1 = new VerticalLayout();
        verticalLayout1.setWidthFull();
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{this.getLoggedInInfoLayout()});
        Span label = new Span(this.i18nService.getTranslation("StudentCourseView.label.descriptionView", this.getLocale(), new Object[0]));
        this.courseGrid = new Grid();
        this.createCoursesGrid(this.courseGrid);
        this.refreshGrid();
        Button gotoCourseButton = new Button(this.i18nService.getTranslation("StudentCourseView.button.gotoCourse", this.getLocale(), new Object[0]));
        gotoCourseButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.gotoCourse());
        this.courseGrid.addSelectionListener((SelectionListener & Serializable)selectionEvent -> this.gotoCourse());
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{label, this.courseGrid, gotoCourseButton});
        Dimension dim = this.getBrowserDimension();
        verticalLayout1.setHeight(Math.round((double)dim.height * 0.9) + "px");
        this.add(new com.vaadin.flow.component.Component[]{verticalLayout1});
    }

    private void gotoCourse() {
        if (this.courseGrid.getSelectedItems() == null || this.courseGrid.getSelectedItems().size() < 1) {
            this.showNotificationMiddle(this.i18nService.getTranslation("StudentCourseView.msg.noCourseSelected", this.getLocale(), new Object[0]), 2);
            return;
        }
        Course selectedCourse = (Course)this.courseGrid.getSelectedItems().iterator().next();
        this.mainLayoutUI.setCourseId(selectedCourse.getCourseId());
        this.getUI().ifPresent(ui -> ui.navigate(StudentCourseTaskView.class, new RouteParameters("___url_parameter", selectedCourse.getCourseId())));
    }

    private void createCoursesGrid(Grid<Course> grid) {
        CourseUtils courseUtils = new CourseUtils(this.neo4JBaseService, this.schoolId);
        String gridheaderCourseName = this.i18nService.getTranslation("StudentCourseView.gridheader.name", this.getLocale(), new Object[0]);
        String gridheaderCourseSubject = this.i18nService.getTranslation("StudentCourseView.gridheader.subject", this.getLocale(), new Object[0]);
        String gridheaderCourseComment = this.i18nService.getTranslation("StudentCourseView.gridheader.comment", this.getLocale(), new Object[0]);
        String gridheaderStarted = this.i18nService.getTranslation("StudentCourseView.gridheader.started", this.getLocale(), new Object[0]);
        String gridheaderEnds = this.i18nService.getTranslation("StudentCourseView.gridheader.ends", this.getLocale(), new Object[0]);
        String gridheaderCourseId = this.i18nService.getTranslation("StudentCourseView.gridheader.id", this.getLocale(), new Object[0]);
        grid.addColumn(Course::getName).setHeader(gridheaderCourseName).setSortable(true).setResizable(true);
        grid.addColumn((Renderer)new ComponentRenderer(Div::new, courseUtils.getCourseSubjectRenderer())).setHeader(gridheaderCourseSubject).setTooltipGenerator(courseUtils.getSubjectToolTipRenderer()).setResizable(true);
        ((Grid.Column)grid.addColumn(Course::getComment).setHeader(gridheaderCourseComment).setResizable(true)).setSortable(true);
        grid.addColumn((Renderer)new ComponentRenderer(Div::new, this.startCourseConsumerRenderer)).setHeader(gridheaderStarted);
        grid.addColumn((Renderer)new ComponentRenderer(Div::new, this.endCourseConsumerRenderer)).setHeader(gridheaderEnds);
    }

    private void refreshGrid() {
        try {
            logger.info("looking for Course per student {} ", (Object)this.mainLayoutUI.getLoggedInStudent().getStudentId());
            List foundCourses = this.neo4JBaseService.getCoursesPerStudent(this.mainLayoutUI.getLoggedInStudent().getStudentId());
            ListDataProvider dataProvider = new ListDataProvider((Collection)foundCourses);
            this.courseGrid.setDataProvider((DataProvider)dataProvider);
        }
        catch (Exception e) {
            String msg = this.i18nService.getTranslation("StudentCourseView.gridheader.id", this.getLocale(), new Object[]{e.getMessage()});
            logger.error(msg, (Throwable)e);
            this.showNotificationMiddle(msg, 2);
        }
    }
}

