/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.views.students;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.spring.annotation.UIScope;
import de.mahlsdorf.groupservice.model.node.Course;
import de.mahlsdorf.groupservice.model.node.TaskResult;
import de.mahlsdorf.groupservice.model.ui.ComboShort;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.styling.TaskResultGridStyler;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Route(value="studentGrades", layout=MainAppLayout.class)
@Component
@UIScope
public class StudentGradesView
extends BaseView {
    private static final Logger logger = LoggerFactory.getLogger(StudentGradesView.class);
    private static final String MSG_KEY_VIEWNAME = "StudentGradesView.";
    private Neo4JBaseService neo4JBaseService;
    private ComboBox<ComboShort> courseComboBox;
    private Grid<TaskResult> grid;
    private final I18nService i18nService = new I18nService();

    public StudentGradesView() {
        this.neo4JBaseService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    public void beforeEnter(BeforeEnterEvent var1) {
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    private void initLayout() {
        this.removeAll();
        logger.info("init Layout begins");
        VerticalLayout verticalLayout1 = new VerticalLayout();
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{this.getLoggedInInfoLayout()});
        Span label = new Span(this.i18nService.getTranslation("StudentGradesView.label.description", this.getLocale(), new Object[0]));
        this.courseComboBox = new ComboBox(this.i18nService.getTranslation("StudentGradesView.combobox.selectCourse", this.getLocale(), new Object[0]));
        this.fillupCourseComboBox();
        this.courseComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.fillUpGrid());
        this.grid = new Grid();
        this.createTaskResultGrid(this.grid);
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{label, this.courseComboBox, this.grid});
        this.add(new com.vaadin.flow.component.Component[]{verticalLayout1});
        this.fillUpGrid();
        logger.info("init Layout ends");
    }

    private void fillUpGrid() {
        String studentId = this.mainLayoutUI.getLoggedInStudentNumber();
        ComboShort selectedCourse = (ComboShort)this.courseComboBox.getValue();
        if (selectedCourse == null) {
            this.showNotificationMiddle(this.i18nService.getTranslation("StudentGradesView.msg.selectCourse", this.getLocale(), new Object[0]), 2);
        }
        if (selectedCourse != null) {
            String courseId = (String)selectedCourse.getId();
            List taskResults = this.neo4JBaseService.getTaskResultsForCourseForOneStudent(courseId, studentId);
            this.grid.setItems((Collection)taskResults);
        }
    }

    private void fillupCourseComboBox() {
        ArrayList<ComboShort> items = new ArrayList<ComboShort>();
        String studentId = this.mainLayoutUI.getLoggedInStudentNumber();
        List courses = this.neo4JBaseService.getCoursesPerStudent(studentId);
        for (Course course1 : courses) {
            ComboShort cs = new ComboShort((Object)course1.getCourseId(), course1.getName() + " [" + course1.getSubject() + "]");
            items.add(cs);
        }
        this.courseComboBox.setWidthFull();
        this.courseComboBox.setItems(items);
        if (!items.isEmpty()) {
            this.courseComboBox.setValue((Object)((ComboShort)items.get(0)));
        }
    }

    private void createTaskResultGrid(Grid<TaskResult> grid) {
        String gridheaderTaskId = this.i18nService.getTranslation("StudentGradesView.gridheader.taskId", this.getLocale(), new Object[0]);
        String gridheaderTaskName = this.i18nService.getTranslation("StudentGradesView.gridheader.taskName", this.getLocale(), new Object[0]);
        String gridheaderTaskScore = this.i18nService.getTranslation("StudentGradesView.gridheader.taskScore", this.getLocale(), new Object[0]);
        String gridheaderMaxTaskScore = this.i18nService.getTranslation("StudentGradesView.gridheader.maxTaskScore", this.getLocale(), new Object[0]);
        String gridheaderTaskComment = this.i18nService.getTranslation("StudentGradesView.gridheader.taskComment", this.getLocale(), new Object[0]);
        String gridheaderTaskModified = this.i18nService.getTranslation("StudentGradesView.gridheader.taskModified", this.getLocale(), new Object[0]);
        ((Grid.Column)grid.addColumn(TaskResult::getTaskId).setHeader(gridheaderTaskId).setResizable(true)).setSortable(true);
        grid.addColumn(TaskResult::getTaskName).setHeader(gridheaderTaskName).setSortable(true).setResizable(true);
        ((Grid.Column)grid.addColumn(TaskResult::getScoreGiven).setHeader(gridheaderTaskScore).setResizable(true)).setSortable(true);
        ((Grid.Column)grid.addColumn(TaskResult::getMaxScore).setHeader(gridheaderMaxTaskScore).setResizable(true)).setSortable(true);
        ((Grid.Column)grid.addColumn(TaskResult::getComment).setHeader(gridheaderTaskComment).setResizable(true)).setSortable(true);
        grid.setClassNameGenerator((SerializableFunction)new TaskResultGridStyler());
    }
}

