/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.views.teacher;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.spring.annotation.UIScope;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.node.PersonIF;
import de.mahlsdorf.groupservice.model.node.Student;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.groupservice.StudentUploadService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.dialogs.ConfirmDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.PasswordChangeDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.StudentDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.StudentUploadDialog;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Route(value="allStudents", layout=MainAppLayout.class)
@Component
@UIScope
public class AllStudentView
extends BaseView {
    private static final Logger logger = LoggerFactory.getLogger(AllStudentView.class);
    private static final String MSG_KEY_VIEWNAME = "AllStudentView.";
    private final StudentUploadService studentUploadService;
    private Grid<Student> grid;
    private final I18nService i18nService;
    private static final String KEY_FIRST_NAME = "firstName";
    private static final String KEY_LAST_NAME = "lastName";
    private static final String KEY_EMAIL = "Email";
    private static final String KEY_COMMENT1 = "comment1";
    private static final String KEY_COMMENT2 = "comment2";
    private static final String KEY_COMMENT3 = "comment3";
    private static final String KEY_LOGIN_NAME = "loginName";
    private ListDataProvider<Student> allStudentInGroupDataProvider;
    private final List<Student> allStudentList = new ArrayList();
    private HeaderRow filteringHeader;
    private List<Button> allButtonList = new ArrayList();
    private ConfirmDialog infoDialog;
    private Neo4JBaseService neo4JBaseService;

    public AllStudentView(@Autowired StudentUploadService studentUploadService) {
        this.studentUploadService = studentUploadService;
        this.i18nService = I18nService.getInstance();
        this.neo4JBaseService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    public void beforeEnter(BeforeEnterEvent var1) {
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    private void initLayout() {
        this.removeAll();
        this.allButtonList.clear();
        VerticalLayout verticalLayout1 = new VerticalLayout();
        verticalLayout1.setMargin(true);
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{this.getLoggedInInfoLayout()});
        this.allStudentInGroupDataProvider = new ListDataProvider((Collection)this.allStudentList);
        this.grid = new Grid();
        this.grid.setWidth("100%");
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{this.grid});
        String headerNumber = this.i18nService.getTranslation("AllStudentView.gridheader.number", this.getLocale(), new Object[0]);
        String headerGivenName = this.i18nService.getTranslation("AllStudentView.gridheader.givenName", this.getLocale(), new Object[0]);
        String headerLastName = this.i18nService.getTranslation("AllStudentView.gridheader.lastName", this.getLocale(), new Object[0]);
        String headerEmail = this.i18nService.getTranslation("AllStudentView.gridheader.email", this.getLocale(), new Object[0]);
        String headerComment1 = this.i18nService.getTranslation("AllStudentView.gridheader.comment1", this.getLocale(), new Object[0]);
        String headerComment2 = this.i18nService.getTranslation("AllStudentView.gridheader.comment2", this.getLocale(), new Object[0]);
        String headerComment3 = this.i18nService.getTranslation("AllStudentView.gridheader.comment3", this.getLocale(), new Object[0]);
        String headerLoginName = this.i18nService.getTranslation("AllStudentView.gridheader.loginName", this.getLocale(), new Object[0]);
        this.grid.addColumn(Student::getStudentId).setHeader(headerNumber).setSortable(true);
        this.grid.addColumn(Student::getFirstName).setHeader(headerGivenName).setKey("firstName").setSortable(true);
        this.grid.addColumn(Student::getLastName).setHeader(headerLastName).setKey("lastName").setSortable(true);
        this.grid.addColumn(Student::getEmail).setHeader(headerEmail).setKey("Email").setSortable(true);
        this.grid.addColumn(Student::getComment1).setHeader(headerComment1).setKey("comment1").setSortable(true);
        this.grid.addColumn(Student::getComment2).setHeader(headerComment2).setKey("comment2").setSortable(true);
        this.grid.addColumn(Student::getComment3).setHeader(headerComment3).setKey("comment3").setSortable(true);
        this.grid.addColumn(Student::getLoginName).setHeader(headerLoginName).setKey("loginName").setSortable(true);
        this.grid.setDataProvider((DataProvider)this.allStudentInGroupDataProvider);
        this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
        Button addButton = new Button(this.i18nService.getTranslation("AllStudentView.button.add", this.getLocale(), new Object[0]));
        addButton.setId("BtnNewId");
        addButton.addClickListener((ComponentEventListener & Serializable)event -> this.addStudent());
        Button changeButton = new Button(this.i18nService.getTranslation("AllStudentView.button.update", this.getLocale(), new Object[0]));
        changeButton.setId("BtnChangeId");
        changeButton.addClickListener((ComponentEventListener & Serializable)event -> {
            int selectedItemsCount;
            int n = selectedItemsCount = this.grid.getSelectedItems() != null ? this.grid.getSelectedItems().size() : 0;
            if (selectedItemsCount == 1) {
                this.updateStudent();
            } else {
                this.bulkUpdateStudents();
            }
        });
        Button deleteButton = new Button(this.i18nService.getTranslation("AllStudentView.button.delete", this.getLocale(), new Object[0]));
        deleteButton.setId("BtnDeleteId");
        deleteButton.addClickListener((ComponentEventListener & Serializable)event -> this.deleteStudentStart());
        Button uploadButton = new Button(this.i18nService.getTranslation("AllStudentView.button.upload", this.getLocale(), new Object[0]));
        uploadButton.setId("BtnUploadId");
        uploadButton.addClickListener((ComponentEventListener & Serializable)event -> this.uploadStudents());
        Button passwordButton = new Button(this.i18nService.getTranslation("AllStudentView.button.password", this.getLocale(), new Object[0]));
        passwordButton.setId("BtnPasswordId");
        passwordButton.addClickListener((ComponentEventListener & Serializable)event -> this.changePassword());
        this.allButtonList.clear();
        this.allButtonList = new ArrayList<Button>(Arrays.asList(addButton, changeButton, deleteButton, uploadButton, passwordButton));
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{AllStudentView.generateButtonLayout((List)this.allButtonList)});
        if (!this.mainLayoutUI.getLoggedInTeacher().getAdmin().booleanValue()) {
            AllStudentView.disableButtons((List)this.allButtonList);
        }
        this.add(new com.vaadin.flow.component.Component[]{verticalLayout1});
        this.setMargin(true);
        this.setSizeFull();
        this.fillUpTheGrid();
        this.setColumnFiltering(true);
    }

    private void addStudent() {
        StudentDialog addWindow = new StudentDialog(this.mainLayoutUI, this.schoolId, null, this, false);
        addWindow.open();
    }

    private void updateStudent() {
        if (!this.checkExactOneStudentIsSelected()) {
            return;
        }
        StudentDialog updateWindow = new StudentDialog(this.mainLayoutUI, this.schoolId, this.grid.getSelectedItems(), this, false);
        updateWindow.open();
    }

    private void bulkUpdateStudents() {
        StudentDialog updateWindow = new StudentDialog(this.mainLayoutUI, this.schoolId, this.grid.getSelectedItems(), this, true);
        updateWindow.open();
    }

    private boolean checkExactOneStudentIsSelected() {
        if (this.grid.getSelectedItems().isEmpty() || this.grid.getSelectedItems().size() != 1) {
            this.showNotificationMiddle(this.i18nService.getTranslation("AllStudentView.msg.selectStudents", this.getLocale(), new Object[0]), 2);
            return false;
        }
        return true;
    }

    private void uploadStudents() {
        StudentUploadDialog uploadDialog = new StudentUploadDialog(this.mainLayoutUI, this.schoolId, this.studentUploadService, this);
        uploadDialog.open();
    }

    private void changePassword() {
        if (!this.checkExactOneStudentIsSelected()) {
            return;
        }
        PersonIF student = (PersonIF)this.grid.getSelectedItems().iterator().next();
        PasswordChangeDialog passwordChangeDialog = new PasswordChangeDialog(this.mainLayoutUI, student, false);
        passwordChangeDialog.open();
    }

    private void deleteStudentStart() {
        Button deleteButton = new Button(this.i18nService.getTranslation("AllStudentView.button.delete", this.getLocale(), new Object[0]));
        List<Button> additionalButtons = List.of(deleteButton);
        Div message = new Div(new com.vaadin.flow.component.Component[]{new Span(this.i18nService.getTranslation("AllStudentView.msg.deleteReally", this.getLocale(), new Object[]{this.grid.getSelectedItems().size()}))});
        this.infoDialog = new ConfirmDialog(List.of(message), additionalButtons, true);
        deleteButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.infoDialog.setSpinner(buttonClickEvent));
        deleteButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.deleteStudent());
        this.infoDialog.open();
    }

    private void deleteStudent() {
        try {
            this.infoDialog.pushUI();
            Set selectedStudents = this.grid.getSelectedItems();
            this.neo4JBaseService.deleteStudents(selectedStudents);
            this.showNotificationMiddle(this.i18nService.getTranslation("AllStudentView.msg.studentsDeleted", this.getLocale(), new Object[]{selectedStudents.size()}), ConstantsNeoc.Durations.DURATION_SHORT.intValue());
            this.fillUpTheGrid();
        }
        catch (Exception e) {
            logger.error("exception during save {}", (Object)e.getMessage(), (Object)e);
            this.showNotificationMiddle(this.i18nService.getTranslation("AllStudentView.msg.exceptionDeleted", this.getLocale(), new Object[]{e.getMessage()}), ConstantsNeoc.Durations.DURATION_LONG.intValue());
        }
    }

    private void addValueChangeFilterListener(AbstractField.ComponentValueChangeEvent<TextField, String> event, ValueProvider<Student, String> valueProvider) {
        this.checkAllFilterFieldsEmpty((String)event.getValue(), (List)this.filterFields, this.allStudentInGroupDataProvider);
        if (StringUtils.isEmpty((CharSequence)((CharSequence)event.getValue()))) {
            return;
        }
        this.clearFilterFields((TextField)event.getSource(), (String)event.getValue(), (List)this.filterFields, this.allStudentInGroupDataProvider);
        this.allStudentInGroupDataProvider.clearFilters();
        this.allStudentInGroupDataProvider.addFilter(valueProvider, (SerializablePredicate & Serializable)gridFieldValue -> this.compareGridValues((String)event.getValue(), gridFieldValue));
    }

    private void setColumnFiltering(boolean filtered) {
        logger.info("Columnfiltering {}", (Object)filtered);
        if (filtered) {
            this.filteringHeader = this.grid.appendHeaderRow();
            TextField filterFieldFirstName = this.getColumnFilterField();
            filterFieldFirstName.setId("FilterFirstNameId");
            filterFieldFirstName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.addValueChangeFilterListener(event, Student::getFirstName));
            TextField filterFieldLastName = this.getColumnFilterField();
            filterFieldLastName.setId("FilterLastNameId");
            filterFieldLastName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.addValueChangeFilterListener(event, Student::getLastName));
            TextField filterFieldEmail = this.getColumnFilterField();
            filterFieldEmail.setId("FilterEmailId");
            filterFieldEmail.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.addValueChangeFilterListener(event, Student::getEmail));
            TextField filterFieldComment1 = this.getColumnFilterField();
            filterFieldComment1.setId("FilterComment1Id");
            filterFieldComment1.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.addValueChangeFilterListener(event, Student::getComment1));
            TextField filterFieldComment2 = this.getColumnFilterField();
            filterFieldComment2.setId("FilterComment2Id");
            filterFieldComment2.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.addValueChangeFilterListener(event, Student::getComment2));
            TextField filterFieldComment3 = this.getColumnFilterField();
            filterFieldComment3.setId("FilterComment3Id");
            filterFieldComment3.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.addValueChangeFilterListener(event, Student::getComment3));
            TextField filterFieldLoginName = this.getColumnFilterField();
            filterFieldLoginName.setId("FilterLoginNameId");
            filterFieldLoginName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.addValueChangeFilterListener(event, Student::getLoginName));
            Grid.Column colComment1 = this.grid.getColumnByKey("comment1");
            Grid.Column colComment2 = this.grid.getColumnByKey("comment2");
            Grid.Column colComment3 = this.grid.getColumnByKey("comment3");
            Grid.Column colFirstName = this.grid.getColumnByKey("firstName");
            Grid.Column colLastName = this.grid.getColumnByKey("lastName");
            Grid.Column colEmail = this.grid.getColumnByKey("Email");
            Grid.Column colLoginName = this.grid.getColumnByKey("loginName");
            ((HeaderRow.HeaderCell)this.filteringHeader.getCell(colComment1)).setComponent((com.vaadin.flow.component.Component)filterFieldComment1);
            ((HeaderRow.HeaderCell)this.filteringHeader.getCell(colComment2)).setComponent((com.vaadin.flow.component.Component)filterFieldComment2);
            ((HeaderRow.HeaderCell)this.filteringHeader.getCell(colComment3)).setComponent((com.vaadin.flow.component.Component)filterFieldComment3);
            ((HeaderRow.HeaderCell)this.filteringHeader.getCell(colFirstName)).setComponent((com.vaadin.flow.component.Component)filterFieldFirstName);
            ((HeaderRow.HeaderCell)this.filteringHeader.getCell(colLastName)).setComponent((com.vaadin.flow.component.Component)filterFieldLastName);
            ((HeaderRow.HeaderCell)this.filteringHeader.getCell(colEmail)).setComponent((com.vaadin.flow.component.Component)filterFieldEmail);
            ((HeaderRow.HeaderCell)this.filteringHeader.getCell(colLoginName)).setComponent((com.vaadin.flow.component.Component)filterFieldLoginName);
            this.filterFields = new ArrayList<TextField>(List.of(filterFieldComment1, filterFieldComment2, filterFieldComment3, filterFieldFirstName, filterFieldLastName, filterFieldEmail, filterFieldLoginName));
        } else if (!filtered && this.filteringHeader != null) {
            this.allStudentInGroupDataProvider.clearFilters();
            this.filteringHeader = null;
        }
    }

    public void fillUpTheGrid() {
        try {
            String schoolId = this.getSchoolId();
            long startTime = System.currentTimeMillis();
            List studentList = this.neo4JBaseService.getStudentsPerSchool(schoolId);
            this.allStudentList.clear();
            this.allStudentList.addAll(studentList);
            this.allStudentInGroupDataProvider.refreshAll();
            if (logger.isInfoEnabled()) {
                logger.info("suche ben\u00f6tigte {}  msec", (Object)(System.currentTimeMillis() - startTime));
            }
        }
        catch (Exception e) {
            logger.error("Exception during Search of Students {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

