/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.views.teacher;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.spring.annotation.UIScope;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.CreateDeleteCounter;
import de.mahlsdorf.groupservice.model.node.LearningGroup;
import de.mahlsdorf.groupservice.model.node.Student;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.model.ui.ComboShort;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.groupservice.RememberTeacherService;
import de.mahlsdorf.groupservice.service.neo4j.Neo4JStudentToLearningGroupService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Route(value="learningGroups", layout=MainAppLayout.class)
@Component
@UIScope
public class AssignStudentToLearningGroupView
extends BaseView {
    private static final Logger logger = LoggerFactory.getLogger(AssignStudentToLearningGroupView.class);
    private static final String MSG_KEY_VIEWNAME = "AssignStudentView.";
    private final I18nService i18nService = I18nService.getInstance();
    public final String NUMMER = this.i18nService.getTranslation("AssignStudentView.gridheader.number", this.getLocale(), new Object[0]);
    public final String FIRST_NAME = this.i18nService.getTranslation("AssignStudentView.gridheader.givenName", this.getLocale(), new Object[0]);
    public final String LAST_NAME = this.i18nService.getTranslation("AssignStudentView.gridheader.lastName", this.getLocale(), new Object[0]);
    public final String COMMENT_1 = this.i18nService.getTranslation("AssignStudentView.gridheader.comment1", this.getLocale(), new Object[0]);
    public final String COMMENT_2 = this.i18nService.getTranslation("AssignStudentView.gridheader.comment2", this.getLocale(), new Object[0]);
    public final String COMMENT_3 = this.i18nService.getTranslation("AssignStudentView.gridheader.comment3", this.getLocale(), new Object[0]);
    private Grid<Student> gridAllStudents;
    private Grid<Student> gridStudentsInLearningGroup;
    private final List<Student> allStudentList = new ArrayList();
    private final List<Student> allStudentListInLearningGroup = new ArrayList();
    private List<Student> allStudentListUnmodifiable;
    private final List<ComboShort<LearningGroup>> learningGroupComboBoxList = new ArrayList();
    private ComboBox<ComboShort<Teacher>> teacherComboBox;
    private ComboBox<ComboShort<LearningGroup>> learningGroupComboBox;
    private Button saveButton;
    private Button moveToLeftButton;
    private Button moveToRightButton;
    private Checkbox assignCheckBox;
    private ListDataProvider<Student> allStudentDataProvider;
    private StringBuilder comboBoxMessageStringBuilder;
    private boolean comboLearningGroupChanged = false;
    private HeaderRow filteringHeader;
    private HorizontalLayout hLayoutGrids;
    private VerticalLayout moveButtonLayout;
    private Neo4JStudentToLearningGroupService neo4JStudentToLearningGroupService = VaadineoServiceHolder.getINSTANCE().getNeo4JStudentToLearningGroupService();
    private Neo4JBaseService neo4JBaseService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();

    public AssignStudentToLearningGroupView() {
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    public void beforeEnter(BeforeEnterEvent var1) {
        this.filteringHeader = null;
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    private void initLayout() {
        this.removeAll();
        VerticalLayout verticalLayout1 = new VerticalLayout();
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{this.getLoggedInInfoLayout()});
        verticalLayout1.setMargin(true);
        this.teacherComboBox = new ComboBox(this.i18nService.getTranslation("AssignStudentView.combobox.teacherInSchool", this.getLocale(), new Object[0]));
        this.learningGroupComboBox = new ComboBox(this.i18nService.getTranslation("AssignStudentView.combobox.learngroupsOfTeacher", this.getLocale(), new Object[0]));
        this.learningGroupComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)comboBoxLearnGroupComponentValueChangeEvent -> this.learnGroupHasChanged());
        HorizontalLayout hlayoutCombos = new HorizontalLayout();
        hlayoutCombos.setSpacing(true);
        hlayoutCombos.add(new com.vaadin.flow.component.Component[]{this.teacherComboBox, this.learningGroupComboBox});
        this.teacherComboBox.setSizeFull();
        this.learningGroupComboBox.setSizeFull();
        hlayoutCombos.setWidthFull();
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{hlayoutCombos});
        Span label = new Span(this.i18nService.getTranslation("AssignStudentView.label.explain", this.getLocale(), new Object[0]));
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{label});
        this.hLayoutGrids = new HorizontalLayout();
        this.hLayoutGrids.setSpacing(false);
        this.allStudentDataProvider = new ListDataProvider((Collection)this.allStudentList);
        ListDataProvider allStudentInLearnGroupDataProvider = new ListDataProvider((Collection)this.allStudentListInLearningGroup);
        this.gridAllStudents = new Grid();
        this.gridAllStudents.setDataProvider((DataProvider)this.allStudentDataProvider);
        this.gridStudentsInLearningGroup = new Grid();
        this.gridStudentsInLearningGroup.setDataProvider((DataProvider)allStudentInLearnGroupDataProvider);
        this.createStudentGrid(this.gridAllStudents);
        this.createStudentGrid(this.gridStudentsInLearningGroup);
        this.moveToLeftButton = new Button((com.vaadin.flow.component.Component)VaadinIcon.ARROW_LEFT.create());
        this.moveToLeftButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.moveToLeft());
        this.moveToRightButton = new Button((com.vaadin.flow.component.Component)VaadinIcon.ARROW_RIGHT.create());
        this.moveToRightButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.moveToRight());
        this.moveButtonLayout = new VerticalLayout();
        this.moveButtonLayout.addClassName("padding-top-60px");
        this.moveButtonLayout.setSpacing(false);
        this.moveButtonLayout.setMargin(false);
        this.moveButtonLayout.add(new com.vaadin.flow.component.Component[]{this.moveToRightButton, this.moveToLeftButton});
        this.moveButtonLayout.setWidth("80px");
        this.moveButtonLayout.setPadding(false);
        VerticalLayout studentGridLayout = this.getVerticalLayoutForGrid(this.i18nService.getTranslation("AssignStudentView.label.allStudents", this.getLocale(), new Object[0]), this.gridAllStudents);
        VerticalLayout studentLearnGroupGridLayout = this.getVerticalLayoutForGrid(this.i18nService.getTranslation("AssignStudentView.label.allStudentsInLearninggroup", this.getLocale(), new Object[0]), this.gridStudentsInLearningGroup);
        this.hLayoutGrids.add(new com.vaadin.flow.component.Component[]{studentGridLayout, this.moveButtonLayout, studentLearnGroupGridLayout});
        this.hLayoutGrids.setSizeFull();
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{this.hLayoutGrids});
        this.gridAllStudents.setSizeFull();
        this.gridAllStudents.setSelectionMode(Grid.SelectionMode.MULTI);
        this.gridStudentsInLearningGroup.setSizeFull();
        this.gridStudentsInLearningGroup.setSelectionMode(Grid.SelectionMode.MULTI);
        this.saveButton = new Button(this.i18nService.getTranslation("AssignStudentView.button.save", this.getLocale(), new Object[0]));
        this.saveButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.saveLearningGroup());
        Button cancelButton = new Button(this.i18nService.getTranslation("AssignStudentView.button.cancel", this.getLocale(), new Object[0]));
        cancelButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.cancel());
        this.assignCheckBox = new Checkbox(true);
        Span label1 = new Span(this.i18nService.getTranslation("AssignStudentView.label.assign", this.getLocale(), new Object[0]));
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{AssignStudentToLearningGroupView.generateButtonLayout(Arrays.asList(label1, this.assignCheckBox, this.saveButton, cancelButton))});
        this.add(new com.vaadin.flow.component.Component[]{verticalLayout1});
        this.setMargin(true);
        this.setSizeFull();
        this.saveButton.setEnabled(false);
        this.searchForSchool();
        this.setColumnFiltering(true);
        RememberTeacherService.getInstance().setTeacherInComboBox(this.teacherComboBox);
        this.teacherComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)comboBoxTeacherComponentValueChangeEvent -> this.teacherHasChanged());
        this.teacherHasChanged();
    }

    private VerticalLayout getVerticalLayoutForGrid(String label, Grid<Student> gridUnderLabel) {
        VerticalLayout studentGridLayout = new VerticalLayout();
        studentGridLayout.setPadding(false);
        studentGridLayout.setSpacing(false);
        studentGridLayout.setMargin(false);
        Span labelStudentGrid = new Span(label);
        studentGridLayout.add(new com.vaadin.flow.component.Component[]{labelStudentGrid, gridUnderLabel});
        return studentGridLayout;
    }

    private void moveToRight(Collection<Student> items) {
        boolean mustRefresh = false;
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        sb.append(this.i18nService.getTranslation("AssignStudentView.msg.added", this.getLocale(), new Object[0]) + " \n");
        sb1.append(this.i18nService.getTranslation("AssignStudentView.msg.notAdded", this.getLocale(), new Object[0]) + " \n");
        for (Student item : items) {
            if (!this.allStudentListInLearningGroup.contains(item)) {
                this.allStudentListInLearningGroup.add(item);
                sb.append(item.getFirstName()).append(" ").append(item.getLastName()).append("\n");
                mustRefresh = true;
                this.enableSaveButton(true);
                continue;
            }
            logger.info("Item {} bereits in LearningGroup", (Object)item);
            sb1.append(item.getFirstName()).append(" ").append(item.getLastName()).append("\n");
        }
        if (mustRefresh) {
            this.gridStudentsInLearningGroup.getDataProvider().refreshAll();
            this.showNotificationMiddle(sb.toString(), ConstantsNeoc.Durations.DURATION_SHORT.intValue());
        } else {
            this.showNotificationMiddle(sb1.toString(), ConstantsNeoc.Durations.DURATION_SHORT.intValue());
        }
        this.gridAllStudents.deselectAll();
    }

    private void enableSaveButton(boolean enabled) {
        this.saveButton.setEnabled(enabled);
    }

    private void enableSearchUi(boolean enabled) {
        this.teacherComboBox.setEnabled(enabled);
        this.learningGroupComboBox.setEnabled(enabled);
    }

    private void createStudentGrid(Grid<Student> grid) {
        grid.setSizeFull();
        grid.addColumn(Student::getStudentId).setHeader(this.NUMMER).setKey(this.NUMMER).setSortable(true).setResizable(true);
        grid.addColumn(Student::getFirstName).setHeader(this.FIRST_NAME).setKey(this.FIRST_NAME).setSortable(true).setResizable(true);
        grid.addColumn(Student::getLastName).setHeader(this.LAST_NAME).setKey(this.LAST_NAME).setSortable(true).setResizable(true);
        grid.addColumn(Student::getComment1).setHeader(this.COMMENT_1).setKey(this.COMMENT_1).setSortable(true).setResizable(true);
        grid.addColumn(Student::getComment2).setHeader(this.COMMENT_2).setKey(this.COMMENT_2).setSortable(true).setResizable(true);
        grid.addColumn(Student::getComment3).setHeader(this.COMMENT_3).setKey(this.COMMENT_3).setSortable(true).setResizable(true);
    }

    private void searchForSchool() {
        try {
            String schoolId = this.getSchoolId();
            long startTime = System.currentTimeMillis();
            List studentList = this.neo4JBaseService.getStudentsPerSchool(schoolId);
            this.allStudentList.clear();
            this.allStudentListInLearningGroup.clear();
            this.allStudentList.addAll(studentList);
            this.allStudentListUnmodifiable = Collections.unmodifiableList(studentList);
            this.allStudentDataProvider.refreshAll();
            List teacherList = new ArrayList<Teacher>();
            if (Boolean.TRUE.equals(this.mainLayoutUI.getLoggedInTeacher().getAdmin())) {
                teacherList = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService().getTeacherPerSchool(schoolId);
            } else {
                teacherList.add(this.mainLayoutUI.getLoggedInTeacher());
            }
            List csTeacherList = this.createTeacherComboShortList(teacherList);
            this.enableSaveButton(false);
            this.enableSearchUi(true);
            if (teacherList != null && !teacherList.isEmpty()) {
                this.teacherComboBox.setItems((Collection)csTeacherList);
                this.teacherComboBox.setValue((Object)((ComboShort)csTeacherList.get(0)));
            } else {
                this.showNotificationMiddle(this.i18nService.getTranslation("AssignStudentView.msg.noTeacherFound", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_SHORT.intValue());
            }
            logger.info("Suche 'Students and Teacher per School' ben\u00f6tigte {} msec ", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            logger.error("Exception during Search of Students {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void teacherHasChanged() {
        this.comboLearningGroupChanged = false;
        if (this.teacherComboBox.getValue() == null) {
            return;
        }
        String teacherId = ((Teacher)((ComboShort)this.teacherComboBox.getValue()).getId()).getTeacherId();
        List learnGroupList = this.neo4JBaseService.getLearnGroupPerTeacher(teacherId);
        this.learningGroupComboBox.setItems((Collection)this.createLearnGroupComboShortList(learnGroupList));
        RememberTeacherService.getInstance().storeTeacherInSession((Teacher)((ComboShort)this.teacherComboBox.getValue()).getId());
        if (learnGroupList == null || learnGroupList.isEmpty()) {
            this.handleEmptyTeacherList();
            return;
        }
        this.handleFilledTeacherList(learnGroupList);
        if (!this.comboLearningGroupChanged) {
            this.showNotificationMiddle(this.comboBoxMessageStringBuilder.toString(), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
        }
    }

    private void handleFilledTeacherList(List<LearningGroup> learnGroupList) {
        List csLearnGroupList = this.createLearnGroupComboShortList(learnGroupList);
        this.learningGroupComboBoxList.clear();
        this.learningGroupComboBoxList.addAll(csLearnGroupList);
        this.learningGroupComboBox.getDataProvider().refreshAll();
        this.learningGroupComboBox.setValue((Object)((ComboShort)csLearnGroupList.get(0)));
        Teacher teacher = (Teacher)((ComboShort)this.teacherComboBox.getValue()).getId();
        String myMsg = this.i18nService.getTranslation("AssignStudentView.combobox.learngroupsOfTeacher", this.getLocale(), new Object[]{teacher.getFirstName(), teacher.getLastName()});
        this.learningGroupComboBox.setLabel(myMsg);
        this.comboBoxMessageStringBuilder = new StringBuilder();
        this.comboBoxMessageStringBuilder.append(this.i18nService.getTranslation("AssignStudentView.msg.selectLearningGroup", this.getLocale(), new Object[0]) + "\n\n");
    }

    private void handleEmptyTeacherList() {
        this.allStudentListInLearningGroup.clear();
        this.gridStudentsInLearningGroup.getDataProvider().refreshAll();
        this.learningGroupComboBox.clear();
        this.learningGroupComboBoxList.clear();
        this.learningGroupComboBox.getDataProvider().refreshAll();
        String myMsg = this.i18nService.getTranslation("AssignStudentView.msg.noLearningGroupFound", this.getLocale(), new Object[0]);
        this.learningGroupComboBox.setLabel(myMsg);
        this.moveToLeftButton.setEnabled(false);
        this.moveToRightButton.setEnabled(false);
        this.enableSearchUi(true);
        this.showNotificationMiddle(myMsg, ConstantsNeoc.Durations.DURATION_SHORT.intValue());
    }

    private void learnGroupHasChanged() {
        try {
            if (this.learningGroupComboBox.getValue() != null) {
                this.comboLearningGroupChanged = true;
                LearningGroup selectedLearnGroup = (LearningGroup)((ComboShort)this.learningGroupComboBox.getValue()).getId();
                List studentList = this.neo4JBaseService.getStudentsPerLearnGroup(selectedLearnGroup.getGroupId());
                this.allStudentListInLearningGroup.clear();
                this.allStudentListInLearningGroup.addAll(studentList);
                this.gridStudentsInLearningGroup.getDataProvider().refreshAll();
                if (this.comboBoxMessageStringBuilder == null) {
                    this.comboBoxMessageStringBuilder = new StringBuilder();
                }
                this.showNotificationMiddle(this.comboBoxMessageStringBuilder.toString(), ConstantsNeoc.Durations.DURATION_SHORT.intValue());
            } else {
                this.showNotificationMiddle(this.i18nService.getTranslation("AssignStudentView.msg.noLearningGroupFound", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_SHORT.intValue());
            }
        }
        finally {
            this.allStudentList.clear();
            this.allStudentList.addAll(this.allStudentListUnmodifiable);
            this.gridAllStudents.getDataProvider().refreshAll();
        }
    }

    private void moveToLeft() {
        this.enableSaveButton(true);
        this.enableSearchUi(false);
        Set selectedItems = this.gridStudentsInLearningGroup.getSelectedItems();
        if (selectedItems == null || selectedItems.isEmpty()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("AssignStudentView.msg.selectStudentsInRightGrid", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_SHORT.intValue());
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.i18nService.getTranslation("AssignStudentView.msg.removedFromLearningGroup", this.getLocale(), new Object[0]) + "\n\n");
        for (Student item : selectedItems) {
            sb.append(item.getFirstName()).append(" ").append(item.getLastName()).append("\n");
        }
        this.allStudentListInLearningGroup.removeAll(selectedItems);
        this.gridStudentsInLearningGroup.getDataProvider().refreshAll();
        this.gridStudentsInLearningGroup.deselectAll();
        this.showNotificationMiddle(sb.toString(), ConstantsNeoc.Durations.DURATION_SHORT.intValue());
    }

    private void moveToRight() {
        this.enableSaveButton(true);
        this.enableSearchUi(false);
        Set selectedItems = this.gridAllStudents.getSelectedItems();
        if (selectedItems == null || selectedItems.isEmpty()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("AssignStudentView.msg.selectStudentsInLeftGrid", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_SHORT.intValue());
            return;
        }
        this.moveToRight((Collection)selectedItems);
    }

    private void saveLearningGroup() {
        this.enableSaveButton(false);
        this.enableSearchUi(true);
        this.enableSaveButton(false);
        UI ui = UI.getCurrent();
        Locale locale = this.getLocale();
        Dialog spinnerDialog = AssignStudentToLearningGroupView.createSpinnerDialog((Locale)this.getLocale());
        CompletableFuture<Void> voidCompletableFuture = CompletableFuture.runAsync(() -> {
            LearningGroup learnGroup = (LearningGroup)((ComboShort)this.learningGroupComboBox.getValue()).getId();
            HashSet studentsFromGrid = new HashSet(this.allStudentListInLearningGroup);
            String learningGroupId = learnGroup.getGroupId();
            logger.info("startUpdate for LearningGroupNumber {} with InLearningGroupGrid Elements {} ", (Object)learningGroupId, (Object)studentsFromGrid.size());
            CreateDeleteCounter counter = this.neo4JStudentToLearningGroupService.updateLearningGroup(learningGroupId, studentsFromGrid, ((Boolean)this.assignCheckBox.getValue()).booleanValue());
            String msg = this.i18nService.getTranslation("AssignStudentView.msg.saveStatus", locale, new Object[]{counter.getCreated(), counter.getDeleted()});
            ui.access((Command & Serializable)() -> spinnerDialog.close());
            ui.access((Command & Serializable)() -> Notification.show((String)msg, (int)2000, (Notification.Position)Notification.Position.MIDDLE));
        });
        voidCompletableFuture.exceptionally(throwable -> {
            logger.error("############# Exception ex", throwable);
            this.showNotificationMiddle(throwable.getMessage(), ConstantsNeoc.Durations.DURATION_SHORT.intValue());
            return null;
        });
    }

    private void cancel() {
        this.learnGroupHasChanged();
        this.enableSearchUi(true);
        this.enableSaveButton(false);
    }

    private void addValueChangeFilterListener(AbstractField.ComponentValueChangeEvent<TextField, String> event, ValueProvider<Student, String> valueProvider) {
        this.checkAllFilterFieldsEmpty((String)event.getValue(), (List)this.filterFields, this.allStudentDataProvider);
        if (StringUtils.isEmpty((CharSequence)((CharSequence)event.getValue()))) {
            return;
        }
        this.clearFilterFields((TextField)event.getSource(), (String)event.getValue(), (List)this.filterFields, this.allStudentDataProvider);
        this.allStudentDataProvider.clearFilters();
        this.allStudentDataProvider.addFilter(valueProvider, (SerializablePredicate & Serializable)gridFieldValue -> this.compareGridValues((String)event.getValue(), gridFieldValue));
    }

    private void setColumnFiltering(boolean filtered) {
        if (filtered && this.filteringHeader == null) {
            this.filteringHeader = this.gridAllStudents.appendHeaderRow();
            TextField filterFieldFirstName = this.getColumnFilterField();
            filterFieldFirstName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.addValueChangeFilterListener(event, Student::getFirstName));
            TextField filterFieldLastName = this.getColumnFilterField();
            filterFieldLastName.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.addValueChangeFilterListener(event, Student::getLastName));
            TextField filterFieldComment1 = this.getColumnFilterField();
            filterFieldComment1.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.addValueChangeFilterListener(event, Student::getComment1));
            TextField filterFieldComment2 = this.getColumnFilterField();
            filterFieldComment2.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.addValueChangeFilterListener(event, Student::getComment2));
            TextField filterFieldComment3 = this.getColumnFilterField();
            filterFieldComment3.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.addValueChangeFilterListener(event, Student::getComment3));
            Grid.Column colFirstName = this.gridAllStudents.getColumnByKey(this.FIRST_NAME);
            Grid.Column colLastName = this.gridAllStudents.getColumnByKey(this.LAST_NAME);
            Grid.Column colComment1 = this.gridAllStudents.getColumnByKey(this.COMMENT_1);
            Grid.Column colComment2 = this.gridAllStudents.getColumnByKey(this.COMMENT_2);
            Grid.Column colComment3 = this.gridAllStudents.getColumnByKey(this.COMMENT_3);
            ((HeaderRow.HeaderCell)this.filteringHeader.getCell(colFirstName)).setComponent((com.vaadin.flow.component.Component)filterFieldFirstName);
            ((HeaderRow.HeaderCell)this.filteringHeader.getCell(colLastName)).setComponent((com.vaadin.flow.component.Component)filterFieldLastName);
            ((HeaderRow.HeaderCell)this.filteringHeader.getCell(colComment1)).setComponent((com.vaadin.flow.component.Component)filterFieldComment1);
            ((HeaderRow.HeaderCell)this.filteringHeader.getCell(colComment2)).setComponent((com.vaadin.flow.component.Component)filterFieldComment2);
            ((HeaderRow.HeaderCell)this.filteringHeader.getCell(colComment3)).setComponent((com.vaadin.flow.component.Component)filterFieldComment3);
            this.filterFields = new ArrayList<TextField>(Collections.unmodifiableList(Arrays.asList(filterFieldFirstName, filterFieldLastName, filterFieldComment1, filterFieldComment2, filterFieldComment3)));
        } else if (!filtered && this.filteringHeader != null) {
            this.allStudentDataProvider.clearFilters();
            this.filteringHeader = null;
        }
    }
}

