/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.views.teacher;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.spring.annotation.UIScope;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.node.Course;
import de.mahlsdorf.groupservice.model.node.LearningGroup;
import de.mahlsdorf.groupservice.model.node.Subject;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.model.ui.ComboShort;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.groupservice.RememberTeacherService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.dialogs.ConfirmDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.CourseDialog;
import de.mahlsdorf.groupservice.ui.layout.styling.CourseGridStyler;
import de.mahlsdorf.groupservice.ui.layout.utils.CourseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Route(value="manageCourses", layout=MainAppLayout.class)
@Component
@UIScope
public class CourseView
extends BaseView {
    private static final Logger logger = LoggerFactory.getLogger(CourseView.class);
    private static final String MSG_KEY_VIEWNAME = "CourseView.";
    private final List<Course> allCoursesForTeacherAndLearningGroup = new ArrayList();
    private Grid<Course> gridAllCourses;
    private ComboBox<ComboShort<LearningGroup>> learningGroupComboBox;
    private ComboBox<ComboShort<Teacher>> teacherComboBox;
    private ListDataProvider<Course> allCoursesDataProvider;
    private StringBuilder comboBoxMessageStringBuilder;
    private boolean comboLearningGroupChanged = false;
    private final Neo4JBaseService neo4JService;
    private String mySchoolId;
    private final I18nService i18nService;
    private static final String GRID_KEY_NAME = "name";
    private static final String GRID_KEY_COMMENT = "comment";
    private static final String GRID_KEY_SUBJECT = "subject";
    private static final String GRID_KEY_STARTS_AT = "startsAt";
    private static final String GRID_KEY_ENDS_AT = "endAt";
    private static final String GRID_KEY_ID = "id";
    private List<ComboShort<Teacher>> csTeacherList;
    private Map<String, Subject> allSubjectsMap = new HashMap();

    public CourseView(@Autowired Neo4JBaseService neo4JBaseService) {
        this.neo4JService = neo4JBaseService;
        this.i18nService = I18nService.getInstance();
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    public void beforeEnter(BeforeEnterEvent var1) {
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    private void initLayout() {
        this.mySchoolId = this.mainLayoutUI.getSchoolId();
        this.removeAll();
        VerticalLayout verticalLayout1 = new VerticalLayout();
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{this.getLoggedInInfoLayout()});
        verticalLayout1.setMargin(true);
        this.teacherComboBox = new ComboBox(this.i18nService.getTranslation("CourseView.combobox.allTeacher", this.getLocale(), new Object[0]));
        this.learningGroupComboBox = new ComboBox(this.i18nService.getTranslation("CourseView.combobox.allLearninggroups", this.getLocale(), new Object[0]));
        HorizontalLayout hlayoutCombos = new HorizontalLayout();
        hlayoutCombos.setSpacing(true);
        hlayoutCombos.add(new com.vaadin.flow.component.Component[]{this.teacherComboBox, this.learningGroupComboBox});
        this.learningGroupComboBox.setWidthFull();
        this.teacherComboBox.setWidthFull();
        hlayoutCombos.setWidthFull();
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{hlayoutCombos});
        this.allCoursesDataProvider = new ListDataProvider((Collection)this.allCoursesForTeacherAndLearningGroup);
        HorizontalLayout hLayoutGrids = new HorizontalLayout();
        hLayoutGrids.setSpacing(false);
        this.gridAllCourses = new Grid();
        this.gridAllCourses.setDataProvider((DataProvider)this.allCoursesDataProvider);
        this.createCoursesGrid(this.gridAllCourses);
        hLayoutGrids.add(new com.vaadin.flow.component.Component[]{this.gridAllCourses});
        hLayoutGrids.setSizeFull();
        Span label = new Span(this.i18nService.getTranslation("CourseView.label.allCoursesForLearninggroup", this.getLocale(), new Object[0]));
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{label, hLayoutGrids});
        this.gridAllCourses.setSizeFull();
        this.gridAllCourses.setSelectionMode(Grid.SelectionMode.SINGLE);
        Button modifyButton = new Button(this.i18nService.getTranslation("CourseView.button.update", this.getLocale(), new Object[0]));
        modifyButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.modifyCourse());
        Button addButton = new Button(this.i18nService.getTranslation("CourseView.button.add", this.getLocale(), new Object[0]));
        addButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.addCourse());
        Button deleteButton = new Button(this.i18nService.getTranslation("CourseView.button.delete", this.getLocale(), new Object[0]));
        deleteButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.doDeleteStart());
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{CourseView.generateButtonLayout(Arrays.asList(addButton, modifyButton, deleteButton))});
        this.add(new com.vaadin.flow.component.Component[]{verticalLayout1});
        this.setMargin(true);
        this.setSizeFull();
        modifyButton.setEnabled(true);
        this.searchForSchool();
        this.teacherComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.teacherHasChanged());
        this.learningGroupComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)comboBoxLearnGroupComponentValueChangeEvent -> this.learnGroupHasChangedFillUpCourses());
        this.learnGroupHasChangedFillUpCourses();
    }

    private void enableSearchUi(boolean enabled) {
        this.learningGroupComboBox.setEnabled(enabled);
    }

    protected void checkAllFilterFieldsEmpty(String eventValue, List<TextField> filterFields, ListDataProvider dataprovider) {
        super.checkAllFilterFieldsEmpty(eventValue, filterFields, dataprovider);
    }

    private void checkThatTeacherHasSet() {
        ComboShort teacher = (ComboShort)this.teacherComboBox.getValue();
        if (teacher == null) {
            this.teacherComboBox.setValue((Object)((ComboShort)this.csTeacherList.get(0)));
        }
    }

    private void teacherHasChanged() {
        this.comboLearningGroupChanged = false;
        this.checkThatTeacherHasSet();
        String teacherId = ((Teacher)((ComboShort)this.teacherComboBox.getValue()).getId()).getTeacherId();
        RememberTeacherService.getInstance().storeTeacherInSession((Teacher)((ComboShort)this.teacherComboBox.getValue()).getId());
        List learnGroupList = this.neo4JService.getLearnGroupPerTeacher(teacherId);
        BeanComparator comparator = new BeanComparator("learnGroupname");
        Collections.sort(learnGroupList, comparator);
        this.enableSearchUi(true);
        if (learnGroupList != null && !learnGroupList.isEmpty()) {
            List csLearnGroupList = this.createLearnGroupComboShortList(learnGroupList);
            this.learningGroupComboBox.setItems((Collection)csLearnGroupList);
            this.learningGroupComboBox.setValue((Object)((ComboShort)csLearnGroupList.get(0)));
            this.learningGroupComboBox.getDataProvider().refreshAll();
            this.learningGroupComboBox.setValue((Object)((ComboShort)csLearnGroupList.get(0)));
            Teacher teacher = (Teacher)((ComboShort)this.teacherComboBox.getValue()).getId();
            this.learningGroupComboBox.setLabel(this.i18nService.getTranslation("CourseView.label.learngroupsForTeacher", this.getLocale(), new Object[]{teacher.getFirstName(), teacher.getLastName()}));
            this.comboBoxMessageStringBuilder = new StringBuilder();
        } else {
            List csLearnGroupList = this.createLearnGroupComboShortList(learnGroupList);
            this.learningGroupComboBox.setItems((Collection)csLearnGroupList);
            this.learningGroupComboBox.getDataProvider().refreshAll();
            String msg = this.i18nService.getTranslation("CourseView.msg.noLearngroupsFound", this.getLocale(), new Object[0]);
            this.learningGroupComboBox.setLabel(msg);
            this.enableSearchUi(true);
            this.allCoursesForTeacherAndLearningGroup.clear();
            this.gridAllCourses.getDataProvider().refreshAll();
            this.showNotificationMiddle(msg, 2);
        }
        if (!this.comboLearningGroupChanged && learnGroupList != null && !learnGroupList.isEmpty()) {
            this.showNotificationMiddle(this.comboBoxMessageStringBuilder.toString(), 2);
        }
        this.comboLearningGroupChanged = true;
        this.learnGroupHasChangedFillUpCourses();
    }

    private void modifyCourse() {
        if (this.gridAllCourses.getSelectedItems() == null || this.gridAllCourses.getSelectedItems().isEmpty()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("CourseView.msg.selectCourse", this.getLocale(), new Object[0]), 2);
        } else {
            Course selectedCourse = (Course)this.gridAllCourses.getSelectedItems().iterator().next();
            String teacherId = ((LearningGroup)((ComboShort)this.learningGroupComboBox.getValue()).getId()).getGroupId();
            CourseDialog courseDialog = new CourseDialog(this.mainLayoutUI, teacherId, selectedCourse, this);
            courseDialog.open();
        }
    }

    private void doDeleteStart() {
        if (this.gridAllCourses.getSelectedItems() == null || this.gridAllCourses.getSelectedItems().isEmpty()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("CourseView.msg.selectCourse", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            return;
        }
        Button deleteButton = new Button(this.i18nService.getTranslation("CourseView.button.delete", this.getLocale(), new Object[0]));
        deleteButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.deleteCourse());
        List<Button> additionalButtons = List.of(deleteButton);
        Div message = new Div(new com.vaadin.flow.component.Component[]{new Span(this.i18nService.getTranslation("CourseView.msg.deleteReally", this.getLocale(), new Object[0]))});
        ConfirmDialog infoDialog = new ConfirmDialog(List.of(message), additionalButtons);
        infoDialog.open();
    }

    private void deleteCourse() {
        if (this.gridAllCourses.getSelectedItems() == null || this.gridAllCourses.getSelectedItems().isEmpty()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("CourseView.msg.selectCourse", this.getLocale(), new Object[0]), 2);
        } else {
            try {
                Course selectedCourse = (Course)this.gridAllCourses.getSelectedItems().iterator().next();
                String courseId = selectedCourse.getCourseId();
                this.neo4JService.deleteCourseAndTasks(courseId);
                this.showNotificationMiddle(this.i18nService.getTranslation("CourseView.msg.deleted", this.getLocale(), new Object[]{selectedCourse.getName()}), 2);
            }
            catch (Exception e) {
                String msg = this.i18nService.getTranslation("CourseView.msg.deleted", this.getLocale(), new Object[]{e.getMessage()});
                logger.error(msg, (Throwable)e);
                this.showNotificationMiddle(msg + e.getMessage(), 2);
            }
            finally {
                this.learnGroupHasChangedFillUpCourses();
            }
        }
    }

    private void searchForSchool() {
        try {
            long startTime = System.currentTimeMillis();
            this.allCoursesDataProvider.refreshAll();
            List<Object> teacherList = new ArrayList<Teacher>();
            if (!this.mainLayoutUI.getLoggedInTeacher().getAdmin().booleanValue()) {
                teacherList.clear();
                teacherList.add(this.mainLayoutUI.getLoggedInTeacher());
            } else {
                teacherList = this.neo4JService.getTeacherPerSchool(this.mySchoolId);
            }
            this.csTeacherList = this.createTeacherComboShortList(teacherList);
            this.teacherComboBox.setItems((Collection)this.csTeacherList);
            ComboShort selectedTeacher = RememberTeacherService.getInstance().getTeacherComboShort();
            if (selectedTeacher != null) {
                this.teacherComboBox.setValue((Object)((ComboShort)this.csTeacherList.get(0)));
            } else {
                this.teacherComboBox.setValue((Object)selectedTeacher);
            }
            this.teacherHasChanged();
            logger.info("Suche 'Courses in learningGroups {} msec", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            logger.error("Exception during Search Courses {}", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void learnGroupHasChangedFillUpCourses() {
        try {
            if (this.learningGroupComboBox.getValue() != null) {
                this.allSubjectsMap = new CourseUtils(this.neo4JService, this.schoolId).refreshSubjectsMap();
                this.comboLearningGroupChanged = true;
                LearningGroup selectedLearnGroup = (LearningGroup)((ComboShort)this.learningGroupComboBox.getValue()).getId();
                String learnGroupNumber = selectedLearnGroup.getGroupId();
                List courseList = this.neo4JService.getCoursesForLearnGroup(learnGroupNumber);
                this.allCoursesForTeacherAndLearningGroup.clear();
                this.allCoursesForTeacherAndLearningGroup.addAll(courseList);
                this.gridAllCourses.getDataProvider().refreshAll();
                if (this.comboBoxMessageStringBuilder == null) {
                    this.comboBoxMessageStringBuilder = new StringBuilder();
                }
                this.showNotificationMiddle(this.comboBoxMessageStringBuilder.toString(), 1);
                this.comboBoxMessageStringBuilder = new StringBuilder();
            } else {
                this.showNotificationMiddle(this.i18nService.getTranslation("CourseView.msg.selectLearningGroup", this.getLocale(), new Object[0]), 1);
            }
        }
        finally {
            this.gridAllCourses.getDataProvider().refreshAll();
        }
    }

    private void createCoursesGrid(Grid<Course> grid) {
        CourseUtils courseUtils = new CourseUtils(this.neo4JService, this.schoolId);
        grid.setWidthFull();
        String headerName = this.i18nService.getTranslation("CourseView.gridheader.courseName", this.getLocale(), new Object[0]);
        String headerSubject = this.i18nService.getTranslation("CourseView.gridheader.subject", this.getLocale(), new Object[0]);
        String headerComment = this.i18nService.getTranslation("CourseView.gridheader.comment", this.getLocale(), new Object[0]);
        String headerStarted = this.i18nService.getTranslation("CourseView.gridheader.started", this.getLocale(), new Object[0]);
        String headerEnds = this.i18nService.getTranslation("CourseView.gridheader.ends", this.getLocale(), new Object[0]);
        String headerId = this.i18nService.getTranslation("CourseView.gridheader.id", this.getLocale(), new Object[0]);
        grid.addColumn(Course::getName).setHeader(headerName).setKey("name");
        grid.addColumn((Renderer)new ComponentRenderer(Div::new, courseUtils.getCourseSubjectRenderer())).setHeader(headerSubject).setTooltipGenerator(courseUtils.getSubjectToolTipRenderer()).setKey("subject");
        grid.addColumn(Course::getComment).setHeader(headerComment).setKey("comment");
        grid.addColumn((Renderer)new ComponentRenderer(Div::new, this.startCourseConsumerRenderer)).setHeader(headerStarted).setKey("startsAt");
        grid.addColumn((Renderer)new ComponentRenderer(Div::new, this.endCourseConsumerRenderer)).setHeader(headerEnds).setKey("endAt");
        grid.addColumn(Course::getCourseId).setHeader(headerId).setKey("id");
        grid.setClassNameGenerator((SerializableFunction)new CourseGridStyler());
    }

    private void addCourse() {
        if (this.learningGroupComboBox.getValue() == null) {
            this.showNotificationMiddle(I18nService.getInstance().getTranslation("CourseView.msg.selectLearningGroup", this.getLocale(), new Object[0]), 2);
            return;
        }
        String learningGroupId = ((LearningGroup)((ComboShort)this.learningGroupComboBox.getValue()).getId()).getGroupId();
        CourseDialog courseWindow = new CourseDialog(this.mainLayoutUI, learningGroupId, null, this);
        courseWindow.open();
    }
}

