/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.views.teacher;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.spring.annotation.UIScope;
import de.mahlsdorf.groupservice.model.node.LearningGroup;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.model.ui.ComboShort;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.groupservice.RememberTeacherService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.dialogs.ConfirmDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.LearngroupDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.TeacherToLearningGroupAssignmentDialog;
import de.mahlsdorf.groupservice.ui.layout.views.validation.ValidationMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Route(value="learningGroupName", layout=MainAppLayout.class)
@Component
@UIScope
public class LearningGroupNamesView
extends BaseView {
    private static final Logger logger = LoggerFactory.getLogger(LearningGroupNamesView.class);
    private static final String MSG_KEY_VIEWNAME = "LearningGroupNamesView.";
    private VerticalLayout verticalLayout1;
    private Grid<LearningGroup> gridAllLearnGroupPerTeacher;
    private ComboBox<ComboShort<Teacher>> teacherComboBox;
    private List<LearningGroup> learnGroupPerTeacherList = new ArrayList();
    private ListDataProvider<LearningGroup> allLearnGroupDataProvider;
    private String mySchoolId = null;
    private I18nService i18nService;
    private Neo4JBaseService neo4JBaseService;

    public LearningGroupNamesView(@Autowired Neo4JBaseService neo4JBaseService) {
        this.neo4JBaseService = neo4JBaseService;
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    public void beforeEnter(BeforeEnterEvent var1) {
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    private void initLayout() {
        this.removeAll();
        this.i18nService = I18nService.getInstance();
        this.verticalLayout1 = new VerticalLayout();
        this.verticalLayout1.add(new com.vaadin.flow.component.Component[]{this.getLoggedInInfoLayout()});
        this.verticalLayout1.setMargin(true);
        this.mySchoolId = this.getSchoolId();
        this.teacherComboBox = new ComboBox(this.i18nService.getTranslation("LearningGroupNamesView.combobox.allTeacherInSchool", this.getLocale(), new Object[0]));
        this.learnGroupPerTeacherList = new ArrayList();
        this.allLearnGroupDataProvider = new ListDataProvider((Collection)this.learnGroupPerTeacherList);
        this.gridAllLearnGroupPerTeacher = new Grid();
        this.gridAllLearnGroupPerTeacher.setDataProvider((DataProvider)this.allLearnGroupDataProvider);
        HorizontalLayout hlayoutCombos = new HorizontalLayout();
        hlayoutCombos.setSpacing(true);
        hlayoutCombos.add(new com.vaadin.flow.component.Component[]{this.teacherComboBox});
        this.teacherComboBox.setWidth("100%");
        this.gridAllLearnGroupPerTeacher.setSizeFull();
        hlayoutCombos.setWidth("100%");
        this.verticalLayout1.add(new com.vaadin.flow.component.Component[]{hlayoutCombos});
        Span gridDesciptionLabel = new Span(this.i18nService.getTranslation("LearningGroupNamesView.combobox.assignedLerningGroups", this.getLocale(), new Object[]{this.getEditTableText()}));
        ValidationMessage validationMessage = new ValidationMessage();
        this.verticalLayout1.add(new com.vaadin.flow.component.Component[]{gridDesciptionLabel, validationMessage});
        HorizontalLayout hLayoutGrids = new HorizontalLayout();
        hLayoutGrids.setSpacing(false);
        hLayoutGrids.add(new com.vaadin.flow.component.Component[]{this.gridAllLearnGroupPerTeacher});
        this.gridAllLearnGroupPerTeacher.setSizeFull();
        String headerNumber = this.i18nService.getTranslation("LearningGroupNamesView.gridheader.number", this.getLocale(), new Object[0]);
        String headerName = this.i18nService.getTranslation("LearningGroupNamesView.gridheader.name", this.getLocale(), new Object[0]);
        this.gridAllLearnGroupPerTeacher.addColumn(LearningGroup::getGroupId).setHeader(headerNumber).setFlexGrow(0).setAutoWidth(true);
        this.gridAllLearnGroupPerTeacher.addColumn(LearningGroup::getLearnGroupname).setHeader(headerName);
        hLayoutGrids.setSizeFull();
        this.verticalLayout1.add(new com.vaadin.flow.component.Component[]{hLayoutGrids});
        this.gridAllLearnGroupPerTeacher.setSizeFull();
        this.gridAllLearnGroupPerTeacher.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.add(new com.vaadin.flow.component.Component[]{this.verticalLayout1});
        this.setMargin(true);
        this.setSizeFull();
        this.searchForSchool();
        this.teacherHasChanged(true);
        this.teacherComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)comboBoxTeacherComponentValueChangeEvent -> this.teacherHasChanged());
        RememberTeacherService.getInstance().setTeacherInComboBox(this.teacherComboBox);
        Button addButton = new Button(this.i18nService.getTranslation("LearningGroupNamesView.button.add", this.getLocale(), new Object[0]));
        addButton.setId("BtnNewId");
        addButton.addClickListener((ComponentEventListener & Serializable)clickEvent -> this.add());
        Button editButton = new Button(this.i18nService.getTranslation("LearningGroupNamesView.button.update", this.getLocale(), new Object[0]));
        editButton.setId("BtnChangeId");
        editButton.addClickListener((ComponentEventListener & Serializable)clickEvent -> this.change());
        Button assignButton = new Button(this.i18nService.getTranslation("LearningGroupNamesView.button.assign", this.getLocale(), new Object[0]));
        assignButton.setId("BtnAssignId");
        assignButton.addClickListener((ComponentEventListener & Serializable)clickEvent -> this.assign());
        Button deleteLgButton = new Button(this.i18nService.getTranslation("LearningGroupNamesView.button.delete", this.getLocale(), new Object[0]));
        deleteLgButton.setId("BtnDeleteId");
        deleteLgButton.addClickListener((ComponentEventListener & Serializable)clickEvent -> this.doDeleteStart());
        this.verticalLayout1.add(new com.vaadin.flow.component.Component[]{LearningGroupNamesView.generateButtonLayout(Arrays.asList(addButton, editButton, assignButton, deleteLgButton))});
    }

    private boolean checkTeacherSelected() {
        ComboShort teacherId = (ComboShort)this.teacherComboBox.getValue();
        if (teacherId == null) {
            this.showNotificationMiddle(this.i18nService.getTranslation("LearningGroupNamesView.msg.noTeacherSelected", this.getLocale(), new Object[0]), 2);
            return false;
        }
        return true;
    }

    private void add() {
        if (!this.checkTeacherSelected()) {
            return;
        }
        Teacher teacher = (Teacher)((ComboShort)this.teacherComboBox.getValue()).getId();
        LearngroupDialog lgWindow = new LearngroupDialog(this.mainLayoutUI, teacher, null, this);
        lgWindow.open();
    }

    private void change() {
        if (!this.checkTeacherSelected()) {
            return;
        }
        if (this.gridAllLearnGroupPerTeacher.getSelectedItems() == null || this.gridAllLearnGroupPerTeacher.getSelectedItems().isEmpty()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("LearningGroupNamesView.msg.noLearningGroupSelected", this.getLocale(), new Object[0]), 2);
            return;
        }
        Teacher teacher = (Teacher)((ComboShort)this.teacherComboBox.getValue()).getId();
        LearngroupDialog lgWindow = new LearngroupDialog(this.mainLayoutUI, teacher, (LearningGroup)this.gridAllLearnGroupPerTeacher.getSelectedItems().iterator().next(), this);
        lgWindow.open();
    }

    private void assign() {
        Set learnGroupSet = this.gridAllLearnGroupPerTeacher.getSelectedItems();
        if (learnGroupSet.isEmpty()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("LearningGroupNamesView.msg.noLearningGroupSelected", this.getLocale(), new Object[0]), 2);
        } else {
            LearningGroup selectedLearnGroup = (LearningGroup)learnGroupSet.iterator().next();
            TeacherToLearningGroupAssignmentDialog assignDialog = new TeacherToLearningGroupAssignmentDialog(this.mySchoolId, selectedLearnGroup, this);
            assignDialog.open();
        }
    }

    private void doDeleteStart() {
        Set selectedItems = this.gridAllLearnGroupPerTeacher.getSelectedItems();
        if (selectedItems == null || selectedItems.isEmpty()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("LearningGroupNamesView.msg.noLearningGroupSelected", this.getLocale(), new Object[0]), 2);
            return;
        }
        Button deleteButton = new Button(this.i18nService.getTranslation("LearningGroupNamesView.button.delete", this.getLocale(), new Object[0]));
        deleteButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.deleteLearningGroup());
        List<Button> additionalButtons = List.of(deleteButton);
        Div message = new Div(new com.vaadin.flow.component.Component[]{new Span(this.i18nService.getTranslation("LearningGroupNamesView.msg.deleteReally", this.getLocale(), new Object[0]))});
        ConfirmDialog infoDialog = new ConfirmDialog(List.of(message), additionalButtons);
        infoDialog.open();
    }

    private void deleteLearningGroup() {
        LearningGroup learnGroup = (LearningGroup)this.gridAllLearnGroupPerTeacher.getSelectedItems().iterator().next();
        this.neo4JBaseService.deleteLearningGroup(learnGroup.getGroupId());
        this.teacherHasChanged();
        this.showNotificationMiddle(this.i18nService.getTranslation("LearningGroupNamesView.msg.learninggroupDeleted", this.getLocale(), new Object[]{learnGroup.getLearnGroupname()}), 2);
    }

    private void enableSearchUi(boolean enabled) {
        this.teacherComboBox.setEnabled(enabled);
    }

    public void searchForSchool() {
        try {
            String schoolNumber = this.schoolId;
            long startTime = System.currentTimeMillis();
            Teacher remeberedTeacher = RememberTeacherService.getInstance().getTeacher();
            List teacherList = this.neo4JBaseService.getTeacherPerSchool(schoolNumber);
            ArrayList<ComboShort> comboShortList = new ArrayList<ComboShort>();
            if (this.mainLayoutUI.getLoggedInTeacher().getAdmin().booleanValue()) {
                for (Teacher teacher : teacherList) {
                    comboShortList.add(this.createTeacher(teacher));
                }
            } else {
                comboShortList.add(this.createTeacher(this.mainLayoutUI.getLoggedInTeacher()));
            }
            this.enableSearchUi(true);
            if (teacherList != null && teacherList.size() > 0) {
                this.teacherComboBox.setItems(comboShortList);
                if (remeberedTeacher == null) {
                    this.teacherComboBox.setValue((Object)((ComboShort)comboShortList.get(0)));
                } else {
                    this.teacherComboBox.setValue((Object)this.createTeacher(remeberedTeacher));
                }
            } else {
                this.showNotificationMiddle(this.i18nService.getTranslation("LearningGroupNamesView.msg.noTeacherFound", this.getLocale(), new Object[0]), 2);
            }
            logger.info("Suche 'Students and Teacher per School' ben\u00f6tigte " + (System.currentTimeMillis() - startTime) + " msec");
        }
        catch (Exception e) {
            String msg = this.i18nService.getTranslation("LearningGroupNamesView.msg.searchException", this.getLocale(), new Object[]{e.getMessage()});
            logger.error(msg, (Throwable)e);
            this.showNotificationMiddle(msg, 2);
        }
    }

    private ComboShort createTeacher(Teacher teacher) {
        return new ComboShort((Object)teacher, teacher.getFirstName() + " " + teacher.getLastName());
    }

    private void teacherHasChanged() {
        this.teacherHasChanged(false);
    }

    private String getTeacherIdFromComboShort(ComboShort comboShort) {
        return ((Teacher)((ComboShort)this.teacherComboBox.getValue()).getId()).getTeacherId();
    }

    public void teacherHasChanged(boolean firstTime) {
        List learnGroupList;
        String teacherNumber = "";
        if (this.teacherComboBox.getValue() != null) {
            teacherNumber = this.getTeacherIdFromComboShort((ComboShort)this.teacherComboBox.getValue());
        }
        if (!firstTime) {
            RememberTeacherService.getInstance().storeTeacherInSession((Teacher)((ComboShort)this.teacherComboBox.getValue()).getId());
            teacherNumber = this.getTeacherIdFromComboShort((ComboShort)this.teacherComboBox.getValue());
        }
        if ((learnGroupList = this.neo4JBaseService.getLearnGroupPerTeacher(teacherNumber)) == null || learnGroupList.size() == 0) {
            this.learnGroupPerTeacherList.clear();
            this.gridAllLearnGroupPerTeacher.getDataProvider().refreshAll();
            this.enableSearchUi(true);
        } else {
            this.learnGroupPerTeacherList.clear();
            this.learnGroupPerTeacherList.addAll(learnGroupList);
            this.gridAllLearnGroupPerTeacher.getDataProvider().refreshAll();
        }
    }

    public void refreshGrid() {
    }

    private void cancel() {
        this.teacherHasChanged();
        this.enableSearchUi(true);
    }
}

