/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.views.teacher;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.spring.annotation.UIScope;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.node.Subject;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.dialogs.ConfirmDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.SubjectDialog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Route(value="subjects", layout=MainAppLayout.class)
@Component
@UIScope
public class SubjectView
extends BaseView {
    private static final Logger logger = LoggerFactory.getLogger(SubjectView.class);
    private static final String MSG_KEY_VIEWNAME = "SubjectView.";
    private final List<Subject> allSubjectsForSchool = new ArrayList();
    private Grid<Subject> gridAllSubjects;
    private ListDataProvider<Subject> allSubjectDataProvider;
    private final Neo4JBaseService neo4JService;
    private final I18nService i18nService;
    private static final String GRID_KEY_DESCRIPTION = "description";
    private static final String GRID_KEY_SUBJECT = "subject";
    private static final String GRID_KEY_ID = "id";

    public SubjectView(@Autowired Neo4JBaseService neo4JBaseService, @Autowired I18nService i18nService) {
        this.neo4JService = neo4JBaseService;
        this.i18nService = i18nService;
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    public void beforeEnter(BeforeEnterEvent var1) {
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    private void initLayout() {
        this.removeAll();
        VerticalLayout verticalLayout1 = new VerticalLayout();
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{this.getLoggedInInfoLayout()});
        verticalLayout1.setMargin(true);
        this.allSubjectDataProvider = new ListDataProvider((Collection)this.allSubjectsForSchool);
        HorizontalLayout hLayoutGrids = new HorizontalLayout();
        hLayoutGrids.setSpacing(false);
        this.gridAllSubjects = new Grid();
        this.gridAllSubjects.setDataProvider((DataProvider)this.allSubjectDataProvider);
        this.createSubjectGrid(this.gridAllSubjects);
        hLayoutGrids.add(new com.vaadin.flow.component.Component[]{this.gridAllSubjects});
        hLayoutGrids.setSizeFull();
        Span label = new Span(this.i18nService.getTranslation("SubjectView.label.allSubjectsForSchool", this.getLocale(), new Object[0]));
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{label, hLayoutGrids});
        this.gridAllSubjects.setSizeFull();
        this.gridAllSubjects.setSelectionMode(Grid.SelectionMode.SINGLE);
        Button modifyButton = new Button(this.i18nService.getTranslation("SubjectView.button.update", this.getLocale(), new Object[0]));
        modifyButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.modifySubject());
        Button addButton = new Button(this.i18nService.getTranslation("SubjectView.button.add", this.getLocale(), new Object[0]));
        addButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.addSubject());
        Button deleteButton = new Button(this.i18nService.getTranslation("SubjectView.button.delete", this.getLocale(), new Object[0]));
        deleteButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.doDeleteStart());
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{SubjectView.generateButtonLayout(Arrays.asList(addButton, modifyButton, deleteButton))});
        this.add(new com.vaadin.flow.component.Component[]{verticalLayout1});
        this.setMargin(true);
        this.setSizeFull();
        modifyButton.setEnabled(true);
        this.fillUpTheGrid();
        if (!this.loggedInTeacher.getAdmin().booleanValue()) {
            addButton.setEnabled(false);
            modifyButton.setEnabled(false);
            deleteButton.setEnabled(false);
            this.showNotificationMiddle(I18nService.getInstance().getTranslation("SubjectView.msg.editOnlyAsAdmin", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
        }
    }

    protected void checkAllFilterFieldsEmpty(String eventValue, List<TextField> filterFields, ListDataProvider dataprovider) {
        super.checkAllFilterFieldsEmpty(eventValue, filterFields, dataprovider);
    }

    private void modifySubject() {
        if (this.gridAllSubjects.getSelectedItems() == null || this.gridAllSubjects.getSelectedItems().isEmpty()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("SubjectView.msg.selectSubject", this.getLocale(), new Object[0]), 2);
        } else {
            Subject selectedSubject = (Subject)this.gridAllSubjects.getSelectedItems().iterator().next();
            SubjectDialog subjectDialog = new SubjectDialog(this.neo4JService, this.schoolId, selectedSubject, this);
            subjectDialog.open();
        }
    }

    private void doDeleteStart() {
        if (this.gridAllSubjects.getSelectedItems() == null || this.gridAllSubjects.getSelectedItems().isEmpty()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("SubjectView.msg.selectSubject", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            return;
        }
        Button deleteButton = new Button(this.i18nService.getTranslation("SubjectView.button.delete", this.getLocale(), new Object[0]));
        deleteButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.deleteSubject());
        List<Button> additionalButtons = List.of(deleteButton);
        Div message = new Div(new com.vaadin.flow.component.Component[]{new Span(this.i18nService.getTranslation("SubjectView.msg.deleteReally", this.getLocale(), new Object[0]))});
        ConfirmDialog infoDialog = new ConfirmDialog(List.of(message), additionalButtons);
        infoDialog.open();
    }

    private void deleteSubject() {
        if (this.gridAllSubjects.getSelectedItems() == null || this.gridAllSubjects.getSelectedItems().isEmpty()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("SubjectView.msg.selectCourse", this.getLocale(), new Object[0]), 2);
        } else {
            try {
                Subject selectedSubject = (Subject)this.gridAllSubjects.getSelectedItems().iterator().next();
                String subjectId = selectedSubject.getSubjectId();
                this.neo4JService.deleteSubjectById(subjectId);
                this.showNotificationMiddle(this.i18nService.getTranslation("SubjectView.msg.deleted", this.getLocale(), new Object[]{selectedSubject.getSubjectName()}), 2);
                this.fillUpTheGrid();
            }
            catch (Exception e) {
                String msg = this.i18nService.getTranslation("SubjectView.msg.deletedWithException", this.getLocale(), new Object[]{e.getMessage()});
                logger.error(msg, (Throwable)e);
                this.showNotificationMiddle(msg + e.getMessage(), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            }
        }
    }

    public void fillUpTheGrid() {
        try {
            List subjectList = this.neo4JService.findSubjectsBySchoolId(this.getSchoolId());
            this.allSubjectsForSchool.clear();
            this.allSubjectsForSchool.addAll(subjectList);
            this.gridAllSubjects.getDataProvider().refreshAll();
        }
        catch (Exception e) {
            logger.error("Exception during Search Courses {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void createSubjectGrid(Grid<Subject> grid) {
        grid.setWidthFull();
        String headerSubject = this.i18nService.getTranslation("SubjectView.gridheader.subject", this.getLocale(), new Object[0]);
        String headerComment = this.i18nService.getTranslation("SubjectView.gridheader.description", this.getLocale(), new Object[0]);
        String headerId = this.i18nService.getTranslation("SubjectView.gridheader.id", this.getLocale(), new Object[0]);
        grid.addColumn(Subject::getSubjectName).setHeader(headerSubject).setKey("subject");
        grid.addColumn(Subject::getDescription).setHeader(headerComment).setKey("description");
        grid.addColumn(Subject::getSubjectId).setHeader(headerId).setKey("id");
    }

    private void addSubject() {
        this.showNotificationMiddle("add Subject ", ConstantsNeoc.Durations.DURATION_SHORT.intValue());
        SubjectDialog subjectDialog = new SubjectDialog(this.neo4JService, this.schoolId, null, this);
        subjectDialog.open();
    }
}

