/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.views.teacher;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.grid.dnd.GridDropLocation;
import com.vaadin.flow.component.grid.dnd.GridDropMode;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.spring.annotation.UIScope;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.node.Course;
import de.mahlsdorf.groupservice.model.node.LearningGroup;
import de.mahlsdorf.groupservice.model.node.Task;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.model.ui.ComboShort;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.groupservice.RememberTeacherService;
import de.mahlsdorf.groupservice.service.groupservice.Task2ToolAssignerService;
import de.mahlsdorf.groupservice.service.groupservice.TaskIconUrlChecker;
import de.mahlsdorf.groupservice.service.lti13.TccConverterService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.dialogs.Lti13DeeplinkDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.Lti13TccUploadDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.TaskDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.TaskToStudentAssignmentDialog;
import de.mahlsdorf.groupservice.ui.layout.styling.TaskGridRenderer;
import de.mahlsdorf.groupservice.ui.layout.styling.TaskGridStyler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Route(value="manageTasks", layout=MainAppLayout.class)
@Component
@UIScope
public class TaskView
extends BaseView {
    private static final Logger logger = LoggerFactory.getLogger(TaskView.class);
    private static final String MSG_KEY_VIEWNAME = "TaskView.";
    public static final String PROPERTY_TITLE = "title";
    public static final String MSG_PART_DELETE = "delete";
    public static final String MSG_PART_SELECT_TASK = "selectTask";
    private final List<ComboShort<Course>> allCoursesForTeacherAndLearningGroupList = new ArrayList();
    private final List<Task> allTasksForCourse = new ArrayList();
    private Grid<Task> gridAllTasksForCourse;
    private ComboBox<ComboShort<Teacher>> teacherComboBox;
    private ComboBox<ComboShort<LearningGroup>> learningGroupComboBox;
    private List<ComboShort<LearningGroup>> csLearningGroupListForList;
    private ComboBox<ComboShort<Course>> courseComboBox;
    private Button modifyButton;
    private Button addButton;
    private Button addHeadlineButton;
    private Button deleteButton;
    private Button addLtiButton;
    private Button importTccButton;
    private Button assignButton;
    private final List<com.vaadin.flow.component.Component> buttonList = new ArrayList();
    private ListDataProvider<ComboShort<Course>> allCoursesDataProvider;
    private ListDataProvider<ComboShort<LearningGroup>> dataProviderLearningGroup;
    private final Neo4JBaseService neo4JService;
    private RememberTeacherService rememberTeacherService;
    private StringBuilder comboBoxMessageStringBuilder = new StringBuilder();
    private static final String STRUCTURE = "structure";
    private TccConverterService tccConverterService;
    private Task2ToolAssignerService task2ToolAssigner;
    private I18nService i18nService;
    private Task draggedItem;
    private Checkbox reorderCheckBox;
    private Button assignBulkButton;
    private final TaskIconUrlChecker taskIconUrlChecker;
    private Dialog dialog;
    private boolean dragAndDropEnabled = false;

    public TaskView(TaskIconUrlChecker taskUrl, @Autowired Neo4JBaseService neo4JBaseService) {
        this.taskIconUrlChecker = taskUrl;
        this.neo4JService = neo4JBaseService;
        this.rememberTeacherService = RememberTeacherService.getInstance();
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    public void beforeEnter(BeforeEnterEvent var1) {
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    private void initLayout() {
        this.removeAll();
        this.buttonList.clear();
        this.i18nService = I18nService.getInstance();
        this.csLearningGroupListForList = new ArrayList();
        VerticalLayout verticalLayout1 = new VerticalLayout();
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{this.getLoggedInInfoLayout()});
        verticalLayout1.setMargin(false);
        this.teacherComboBox = new ComboBox(this.i18nService.getTranslation("TaskView.combobox.allTeacherInSchool", this.getLocale(), new Object[0]));
        this.learningGroupComboBox = new ComboBox(this.i18nService.getTranslation("TaskView.combobox.allLearningGroupsAssigned", this.getLocale(), new Object[0]));
        this.courseComboBox = new ComboBox(this.i18nService.getTranslation("TaskView.combobox.allCoursesForLearningGroup", this.getLocale(), new Object[0]));
        HorizontalLayout hlayoutCombos = new HorizontalLayout();
        hlayoutCombos.setSpacing(true);
        hlayoutCombos.setMargin(false);
        hlayoutCombos.add(new com.vaadin.flow.component.Component[]{this.teacherComboBox, this.learningGroupComboBox, this.courseComboBox});
        this.teacherComboBox.setSizeFull();
        this.learningGroupComboBox.setSizeFull();
        this.courseComboBox.setSizeFull();
        this.allCoursesDataProvider = new ListDataProvider((Collection)this.allCoursesForTeacherAndLearningGroupList);
        this.dataProviderLearningGroup = new ListDataProvider((Collection)this.csLearningGroupListForList);
        hlayoutCombos.setWidthFull();
        hlayoutCombos.setSpacing(true);
        this.reorderCheckBox = new Checkbox(this.i18nService.getTranslation("TaskView.label.reorderByDragAndDrop", this.getLocale(), new Object[0]));
        this.reorderCheckBox.addClickListener((ComponentEventListener & Serializable)checkboxClickEvent -> this.startStopReorder());
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{hlayoutCombos});
        HorizontalLayout hLayoutGrids = new HorizontalLayout();
        hLayoutGrids.setSpacing(false);
        this.gridAllTasksForCourse = new Grid();
        this.createTaskGridForLaunchLink(this.gridAllTasksForCourse);
        hLayoutGrids.add(new com.vaadin.flow.component.Component[]{this.gridAllTasksForCourse});
        this.gridAllTasksForCourse.addThemeVariants(new GridVariant[]{GridVariant.LUMO_COMPACT});
        hLayoutGrids.setSizeFull();
        Span label = new Span(this.i18nService.getTranslation("TaskView.label.tasksForCourse", this.getLocale(), new Object[0]));
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{label, hLayoutGrids});
        this.gridAllTasksForCourse.setSizeFull();
        this.gridAllTasksForCourse.setSelectionMode(Grid.SelectionMode.MULTI);
        this.modifyButton = new Button(this.i18nService.getTranslation("TaskView.button.update", this.getLocale(), new Object[0]));
        this.modifyButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.modifyTask());
        this.modifyButton.getElement().setProperty("title", this.i18nService.getTranslation("TaskView.tooltip.update", this.getLocale(), new Object[0]));
        this.addButton = new Button(this.i18nService.getTranslation("TaskView.button.add", this.getLocale(), new Object[0]));
        this.addButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.addTask());
        this.addButton.getElement().setProperty("title", this.i18nService.getTranslation("TaskView.tooltip.add", this.getLocale(), new Object[0]));
        this.addLtiButton = new Button(this.i18nService.getTranslation("TaskView.button.deeplink", this.getLocale(), new Object[0]));
        this.addLtiButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.addLtiTask());
        this.addLtiButton.getElement().setProperty("title", this.i18nService.getTranslation("TaskView.tooltip.deeplink", this.getLocale(), new Object[0]));
        this.importTccButton = new Button(this.i18nService.getTranslation("TaskView.button.tccImport", this.getLocale(), new Object[0]));
        this.importTccButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.importTcc());
        this.importTccButton.getElement().setProperty("title", this.i18nService.getTranslation("TaskView.tooltip.tccImport", this.getLocale(), new Object[0]));
        this.assignButton = new Button(this.i18nService.getTranslation("TaskView.button.assign", this.getLocale(), new Object[0]));
        this.assignButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.assignTask());
        this.assignButton.getElement().setProperty("title", this.i18nService.getTranslation("TaskView.tooltip.assign", this.getLocale(), new Object[0]));
        this.assignBulkButton = new Button(this.i18nService.getTranslation("TaskView.button.assignBulk", this.getLocale(), new Object[0]));
        this.assignBulkButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.assignBulkTask());
        this.assignBulkButton.getElement().setProperty("title", this.i18nService.getTranslation("TaskView.tooltip.assignBulk", this.getLocale(), new Object[0]));
        this.deleteButton = new Button(this.i18nService.getTranslation("TaskView.button.delete", this.getLocale(), new Object[0]));
        this.deleteButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.createConfirmDeleteDialog());
        this.deleteButton.getElement().setProperty("title", this.i18nService.getTranslation("TaskView.tooltip.delete", this.getLocale(), new Object[0]));
        this.buttonList.add(this.assignBulkButton);
        this.buttonList.add(this.assignButton);
        this.addHeadlineButton = new Button(this.i18nService.getTranslation("TaskView.button.addHeadline", this.getLocale(), new Object[0]));
        this.addHeadlineButton.addClickListener((ComponentEventListener & Serializable)click -> this.addHeadline());
        this.addHeadlineButton.getElement().setProperty("title", this.i18nService.getTranslation("TaskView.tooltip.addHeadline", this.getLocale(), new Object[0]));
        this.buttonList.add(this.addHeadlineButton);
        if (this.mainLayoutUI.isFeatureLti13Enabled()) {
            this.buttonList.add(this.addLtiButton);
        }
        this.buttonList.add(this.addButton);
        if (this.mainLayoutUI.isFeatureLti13Enabled()) {
            this.buttonList.add(this.addLtiButton);
            this.buttonList.add(this.importTccButton);
        }
        this.buttonList.add(this.modifyButton);
        this.buttonList.add(this.deleteButton);
        this.buttonList.add(0, this.reorderCheckBox);
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{TaskView.generateButtonLayout((List)this.buttonList)});
        this.add(new com.vaadin.flow.component.Component[]{verticalLayout1});
        this.setMargin(true);
        this.setSizeFull();
        this.modifyButton.setEnabled(true);
        this.searchForSchool();
        this.teacherComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)comboBoxTeacherComponentValueChangeEvent -> this.teacherHasChanged());
        this.learningGroupComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.learningGroupHasChanged());
        this.courseComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)comboBoxCourseComponentValueChangeEvent -> this.courseHasChanged());
        RememberTeacherService.getInstance().setTeacherInComboBox(this.teacherComboBox);
        this.teacherHasChanged();
        this.learningGroupHasChanged();
        this.enableButtons();
    }

    private void enableButtons() {
        boolean enables;
        boolean nEnables = enables = this.courseComboBox.getValue() != null && this.learningGroupComboBox.getValue() != null;
        this.buttonList.forEach(e -> {
            if (e instanceof Button) {
                ((Button)e).setEnabled(nEnables);
            }
        });
    }

    private void enableComboBoxes(boolean enable) {
        this.teacherComboBox.setEnabled(enable);
        this.learningGroupComboBox.setEnabled(enable);
        this.courseComboBox.setEnabled(enable);
    }

    private void addLtiTask() {
        Lti13DeeplinkDialog dialogDL = new Lti13DeeplinkDialog(this.mainLayoutUI, this.mainLayoutUI.getLoggedInTeacher().getTeacherId(), ((Course)((ComboShort)this.courseComboBox.getValue()).getId()).getCourseId(), this);
        dialogDL.open();
    }

    private void importTcc() {
        Lti13TccUploadDialog dialogImportTcc = new Lti13TccUploadDialog(this.mainLayoutUI, this, this.tccConverterService, (Course)((ComboShort)this.courseComboBox.getValue()).getId(), this.task2ToolAssigner, this.neo4JService);
        dialogImportTcc.open();
    }

    private void assignTask() {
        if (this.gridAllTasksForCourse.getSelectedItems() != null && !this.gridAllTasksForCourse.getSelectedItems().isEmpty()) {
            if (this.gridAllTasksForCourse.getSelectedItems().size() != 1) {
                this.showNotificationMiddle(this.i18nService.getTranslation("TaskView.msg.selectTask", this.getLocale(), new Object[0]), 1);
                return;
            }
            List learnGroup = this.neo4JService.getLearnGroupForCourse(((Course)((ComboShort)this.courseComboBox.getValue()).getId()).getCourseId());
            TaskToStudentAssignmentDialog taskToStudentAssignmentDialog = new TaskToStudentAssignmentDialog(this, new ArrayList(this.gridAllTasksForCourse.getSelectedItems()), (LearningGroup)learnGroup.get(0), false);
            taskToStudentAssignmentDialog.open();
        } else {
            this.showNotificationMiddle(this.i18nService.getTranslation("TaskView.msg.selectTask", this.getLocale(), new Object[0]), 1);
        }
    }

    private void assignBulkTask() {
        if (this.gridAllTasksForCourse.getSelectedItems() != null && !this.gridAllTasksForCourse.getSelectedItems().isEmpty()) {
            if (this.gridAllTasksForCourse.getSelectedItems().isEmpty()) {
                this.showNotificationMiddle(this.i18nService.getTranslation("TaskView.msg.selectMinOneTask", this.getLocale(), new Object[0]), 1);
                return;
            }
            List learnGroup = this.neo4JService.getLearnGroupForCourse(((Course)((ComboShort)this.courseComboBox.getValue()).getId()).getCourseId());
            TaskToStudentAssignmentDialog taskToStudentAssignmentDialog = new TaskToStudentAssignmentDialog(this, new ArrayList(this.gridAllTasksForCourse.getSelectedItems()), (LearningGroup)learnGroup.get(0), true);
            taskToStudentAssignmentDialog.open();
        } else {
            this.showNotificationMiddle(this.i18nService.getTranslation("TaskView.msg.selectTask", this.getLocale(), new Object[0]), 1);
        }
    }

    private void enableSearchUi(boolean enabled) {
        this.teacherComboBox.setEnabled(enabled);
    }

    private void modifyTask() {
        if (this.gridAllTasksForCourse.getSelectedItems() == null || this.gridAllTasksForCourse.getSelectedItems().isEmpty() || this.gridAllTasksForCourse.getSelectedItems().size() != 1) {
            this.showNotificationMiddle(this.i18nService.getTranslation("TaskView.msg.selectTask", this.getLocale(), new Object[0]), 1);
        } else {
            Task selectedTask = (Task)this.gridAllTasksForCourse.getSelectedItems().iterator().next();
            String courseId = ((Course)((ComboShort)this.courseComboBox.getValue()).getId()).getCourseId();
            TaskDialog taskDialog = new TaskDialog(this.mainLayoutUI, courseId, selectedTask, this, selectedTask.getType(), this.allTasksForCourse.size());
            taskDialog.open();
        }
    }

    private void createConfirmDeleteDialog() {
        if (this.gridAllTasksForCourse.getSelectedItems() == null || this.gridAllTasksForCourse.getSelectedItems().isEmpty()) {
            return;
        }
        this.dialog = new Dialog();
        String question = this.i18nService.getTranslation("TaskView.msg.reallyDeleteTasks", this.getLocale(), new Object[0]);
        Button dialogDeleteButton = new Button(this.i18nService.getTranslation("TaskView.button.delete", this.getLocale(), new Object[0]));
        dialogDeleteButton.addClickListener((ComponentEventListener & Serializable)click -> {
            this.deleteSelectedTasks();
            this.dialog.close();
        });
        Button cancelButton = new Button(this.i18nService.getTranslation("TaskView.button.cancel", this.getLocale(), new Object[0]));
        cancelButton.addClickListener((ComponentEventListener & Serializable)click -> this.dialog.close());
        this.dialog.add(new com.vaadin.flow.component.Component[]{this.createConfirmDialogLayout(question, List.of(dialogDeleteButton, cancelButton))});
        this.dialog.open();
    }

    private void deleteSelectedTasks() {
        if (this.gridAllTasksForCourse.getSelectedItems() == null || this.gridAllTasksForCourse.getSelectedItems().isEmpty()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("TaskView.msg.selectTask", this.getLocale(), new Object[0]), 2);
        } else {
            int count = 0;
            for (Task selectedTask : this.gridAllTasksForCourse.getSelectedItems()) {
                String taskId = selectedTask.getTaskId();
                this.neo4JService.deleteTasks(taskId);
                ++count;
            }
            this.showNotificationMiddle(this.i18nService.getTranslation("TaskView.msg.tasksDeleted", this.getLocale(), new Object[]{count}), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            this.courseHasChanged();
        }
    }

    private void searchForSchool() {
        try {
            String schoolId = this.getSchoolId();
            this.allCoursesDataProvider.refreshAll();
            List teacherList = new ArrayList<Teacher>();
            if (this.mainLayoutUI.getLoggedInTeacher().getAdmin().booleanValue()) {
                teacherList = this.neo4JService.getTeacherPerSchool(schoolId);
            } else {
                teacherList.add(this.mainLayoutUI.getLoggedInTeacher());
            }
            List csTeacherList = this.createTeacherComboShortList(teacherList);
            if (teacherList != null && !teacherList.isEmpty()) {
                this.teacherComboBox.setItems((Collection)csTeacherList);
                this.teacherComboBox.setValue((Object)((ComboShort)csTeacherList.get(0)));
            } else {
                this.showNotificationMiddle(this.i18nService.getTranslation("TaskView.msg.noTeacherFound", this.getLocale(), new Object[0]), 2);
            }
        }
        catch (Exception e) {
            logger.error("Exception during Search Courses {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void teacherHasChanged() {
        String teacherId = ((Teacher)((ComboShort)this.teacherComboBox.getValue()).getId()).getTeacherId();
        RememberTeacherService.getInstance().storeTeacherInSession((Teacher)((ComboShort)this.teacherComboBox.getValue()).getId());
        List lgGroup = this.neo4JService.getLearnGroupPerTeacher(teacherId);
        List csLearnGroupList = this.createLearnGroupComboShortList(lgGroup);
        this.csLearningGroupListForList.clear();
        this.csLearningGroupListForList.addAll(csLearnGroupList);
        this.learningGroupComboBox.setItems((Collection)csLearnGroupList);
        if (this.csLearningGroupListForList != null && !this.csLearningGroupListForList.isEmpty()) {
            this.learningGroupComboBox.setValue((Object)((ComboShort)this.csLearningGroupListForList.get(0)));
        } else {
            this.learningGroupComboBox.setValue(null);
            this.showNotificationMiddle(this.i18nService.getTranslation("TaskView.msg.noLearninggroupFound", this.getLocale(), new Object[0]), 2);
            this.courseHasChanged();
            this.learningGroupHasChangedFillUpCourses();
        }
        this.enableButtons();
    }

    private void learningGroupHasChanged() {
        long startTime = System.currentTimeMillis();
        if (this.learningGroupComboBox.getValue() != null) {
            String learningGroupId = ((LearningGroup)((ComboShort)this.learningGroupComboBox.getValue()).getId()).getGroupId();
            List courseList = this.neo4JService.getCoursesForLearnGroup(learningGroupId);
            this.allCoursesForTeacherAndLearningGroupList.clear();
            List csCourseList = this.createCourseComboShortList(courseList);
            this.allCoursesForTeacherAndLearningGroupList.addAll(csCourseList);
            this.courseComboBox.setItems((Collection)csCourseList);
            String noCourse = this.i18nService.getTranslation("TaskView.msg.noCourseFound", this.getLocale(), new Object[0]);
            if (courseList == null || courseList.isEmpty()) {
                this.courseComboBox.clear();
                this.courseComboBox.setValue(null);
                this.showNotificationMiddle(noCourse, 2);
            } else {
                this.courseComboBox.setValue((Object)((ComboShort)csCourseList.get(0)));
            }
            this.courseHasChanged();
            this.enableSearchUi(true);
            logger.info("Suche 'Courses in learningGroups {} msec", (Object)(System.currentTimeMillis() - startTime));
            this.learningGroupHasChangedFillUpCourses();
        } else {
            this.showNotificationMiddle(this.i18nService.getTranslation("TaskView.msg.noLerninggroupSelected", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            this.allCoursesForTeacherAndLearningGroupList.clear();
        }
        this.enableButtons();
    }

    private void courseHasChanged() {
        if (this.courseComboBox.getValue() != null && ((Course)((ComboShort)this.courseComboBox.getValue()).getId()).getCourseId() != null) {
            this.enableModifyButtons(true);
            this.learningGroupHasChangedFillUpCourses();
        } else {
            this.enableModifyButtons(false);
        }
    }

    private void enableAllButtons(boolean enabled) {
        this.enableModifyButtons(enabled);
        this.deleteButton.setEnabled(enabled);
        this.addLtiButton.setEnabled(enabled);
        this.importTccButton.setEnabled(enabled);
        this.assignButton.setEnabled(enabled);
        this.assignBulkButton.setEnabled(enabled);
        this.addHeadlineButton.setEnabled(enabled);
    }

    private void enableModifyButtons(boolean enabled) {
        this.addButton.setEnabled(enabled);
        this.modifyButton.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void learningGroupHasChangedFillUpCourses() {
        try {
            if (this.courseComboBox.getValue() != null) {
                if (this.learningGroupComboBox.getValue() == null) {
                    this.courseComboBox.setValue(null);
                    return;
                }
                LearningGroup selectedLearningGroup = (LearningGroup)((ComboShort)this.learningGroupComboBox.getValue()).getId();
                String learnGroupId = selectedLearningGroup.getGroupId();
                List courseList = this.neo4JService.getCoursesForLearnGroup(learnGroupId);
                List csCourseList = this.createCourseComboShortList(courseList);
                this.allCoursesForTeacherAndLearningGroupList.clear();
                this.allCoursesForTeacherAndLearningGroupList.addAll(csCourseList);
                this.courseComboBox.getDataProvider().refreshAll();
                this.allTasksForCourse.clear();
                this.fillUpGridWithTasksForSelectedCourse();
                if (this.comboBoxMessageStringBuilder == null) {
                    this.comboBoxMessageStringBuilder = new StringBuilder();
                }
                this.modifyButton.setEnabled(true);
                this.addButton.setEnabled(true);
            } else {
                this.allTasksForCourse.clear();
                this.modifyButton.setEnabled(false);
                this.addButton.setEnabled(false);
            }
        }
        finally {
            this.gridAllTasksForCourse.getDataProvider().refreshAll();
        }
    }

    public void fillUpGridWithTasksForSelectedCourse() {
        if (this.courseComboBox.getValue() != null) {
            String courseId = ((Course)((ComboShort)this.courseComboBox.getValue()).getId()).getCourseId();
            List result = this.neo4JService.getTasksForCourse(courseId);
            this.allTasksForCourse.clear();
            this.allTasksForCourse.addAll(result);
            ListDataProvider allTaskDataProvider = new ListDataProvider((Collection)this.allTasksForCourse);
            this.gridAllTasksForCourse.setDataProvider((DataProvider)allTaskDataProvider);
            this.gridAllTasksForCourse.getDataProvider().refreshAll();
            this.showNotificationMiddle(this.comboBoxMessageStringBuilder.toString(), 1);
        } else {
            this.allTasksForCourse.clear();
            this.gridAllTasksForCourse.getDataProvider().refreshAll();
        }
        this.comboBoxMessageStringBuilder = new StringBuilder();
    }

    private void createTaskGridForLaunchLink(Grid<Task> grid) {
        SerializableBiConsumer & Serializable launchRenderer = (SerializableBiConsumer & Serializable)(div, task) -> {
            if (task.getType().equals("LineItem")) {
                div.setText("");
            } else if ("headline".equals(task.getType())) {
                String text = task.getName();
                div.add(text);
            } else {
                String divText = "/platformapi/v1/launch?taskId=" + task.getTaskId() + "&userId=" + this.getLoggedInTeacher().getTeacherId() + "&teacher=true";
                Anchor anchor = new Anchor();
                anchor.setHref(divText);
                anchor.setText(task.getName());
                anchor.setTarget("_myWindow");
                div.add(new com.vaadin.flow.component.Component[]{anchor});
            }
        };
        grid.setSizeFull();
        String headerStructure = this.i18nService.getTranslation("TaskView.gridheader.structure", this.getLocale(), new Object[0]);
        String headerIcon = this.i18nService.getTranslation("TaskView.gridheader.icon", this.getLocale(), new Object[0]);
        String headerLaunch = this.i18nService.getTranslation("TaskView.gridheader.launch", this.getLocale(), new Object[0]);
        String headerDescription = this.i18nService.getTranslation("TaskView.gridheader.description", this.getLocale(), new Object[0]);
        String headerPoints = this.i18nService.getTranslation("TaskView.gridheader.points", this.getLocale(), new Object[0]);
        String headerType = this.i18nService.getTranslation("TaskView.gridheader.type", this.getLocale(), new Object[0]);
        String headerId = this.i18nService.getTranslation("TaskView.gridheader.id", this.getLocale(), new Object[0]);
        grid.addColumn(Task::getStructure).setHeader(headerStructure).setSortable(true).setFlexGrow(0).setAutoWidth(true).setKey("structure");
        grid.addColumn((Renderer)new ComponentRenderer(Div::new, new TaskGridRenderer((TaskIconUrlChecker)this.taskIconUrlChecker).taskIconRenderer)).setHeader(headerIcon).setFlexGrow(0).setAutoWidth(true);
        ((Grid.Column)grid.addColumn((Renderer)new ComponentRenderer(Div::new, (SerializableBiConsumer)launchRenderer)).setResizable(true)).setSortable(true).setHeader(headerLaunch).setFlexGrow(1).setAutoWidth(true);
        grid.addColumn((Renderer)new ComponentRenderer(Div::new, TaskGridRenderer.taskTypeDescriptionRenderer)).setHeader(headerDescription).setTooltipGenerator(Task::getDescription).setSortable(true).setFlexGrow(1);
        grid.addColumn((Renderer)new ComponentRenderer(Div::new, TaskGridRenderer.pointRenderer)).setHeader(headerPoints).setSortable(true).setFlexGrow(0).setAutoWidth(true);
        grid.addColumn((Renderer)new ComponentRenderer(Div::new, TaskGridRenderer.taskTypeRenderer)).setHeader(headerType).setSortable(true).setFlexGrow(0).setAutoWidth(true);
        grid.addColumn((Renderer)new ComponentRenderer(Div::new, TaskGridRenderer.taskTypeIdRenderer)).setHeader(headerId).setSortable(true).setFlexGrow(0).setAutoWidth(true);
        Grid.Column sortCol = grid.getColumnByKey("structure");
        GridSortOrder order = new GridSortOrder(sortCol, SortDirection.ASCENDING);
        grid.sort(Collections.singletonList(order));
        grid.setClassNameGenerator((SerializableFunction)new TaskGridStyler());
    }

    private void startStopReorder() {
        if (((Boolean)this.reorderCheckBox.getValue()).booleanValue()) {
            this.enableDragAndDrop(this.gridAllTasksForCourse);
            this.showNotificationMiddle(this.i18nService.getTranslation("TaskView.msg.dragAndDropEnabled", this.getLocale(), new Object[0]), 2);
            this.enableAllButtons(false);
        } else {
            this.gridAllTasksForCourse.setRowsDraggable(false);
            this.disableDragAndDrop(this.gridAllTasksForCourse);
            this.enableAllButtons(true);
            this.showNotificationMiddle(this.i18nService.getTranslation("TaskView.msg.dragAndDropDisabled", this.getLocale(), new Object[0]), 2);
            StringBuilder sb = new StringBuilder();
            for (Task task : this.allTasksForCourse) {
                try {
                    this.neo4JService.updateTask(task);
                }
                catch (Exception e) {
                    sb.append("Exception ").append(task.getTaskId()).append(e.getMessage());
                }
            }
            if (!sb.isEmpty()) {
                this.showNotificationMiddle(sb.toString(), 3);
            }
            this.showNotificationMiddle(this.i18nService.getTranslation("TaskView.msg.reorderedTasksSaved", this.getLocale(), new Object[0]), 2);
        }
    }

    private void disableDragAndDrop(Grid<Task> grid) {
        this.enableComboBoxes(true);
        grid.setSelectionMode(Grid.SelectionMode.MULTI);
    }

    private void enableDragAndDrop(Grid<Task> grid) {
        this.enableComboBoxes(false);
        grid.setSelectionMode(Grid.SelectionMode.NONE);
        grid.setRowsDraggable(true);
        this.recalculateStructure();
        if (!this.dragAndDropEnabled) {
            logger.debug("enable drop listener");
            grid.addDragStartListener((ComponentEventListener & Serializable)event -> {
                this.draggedItem = (Task)event.getDraggedItems().get(0);
                grid.setDropMode(GridDropMode.BETWEEN);
                logger.info("drag start " + this.draggedItem);
            });
            grid.addDragEndListener((ComponentEventListener & Serializable)event -> {
                this.draggedItem = null;
                grid.setDropMode(null);
                logger.info("drag end");
            });
            grid.addDropListener((ComponentEventListener & Serializable)event -> {
                logger.info("gdrag drop listener");
                Task dropOverItem = (Task)event.getDropTargetItem().get();
                if (!dropOverItem.equals((Object)this.draggedItem)) {
                    this.allTasksForCourse.remove(this.draggedItem);
                    int dropIndex = this.allTasksForCourse.indexOf(dropOverItem) + (event.getDropLocation() == GridDropLocation.BELOW ? 1 : 0);
                    logger.info("droop index {}, dragged item {} ", (Object)dropIndex, (Object)this.draggedItem);
                    this.logTasks(this.allTasksForCourse);
                    logger.debug("before add draged item");
                    this.allTasksForCourse.add(dropIndex, this.draggedItem);
                    logger.info("drop index {}, dragged item {} ", (Object)dropIndex, (Object)this.draggedItem);
                    this.logTasks(this.allTasksForCourse);
                    logger.info("after add");
                    grid.getDataProvider().refreshAll();
                    this.logTasks(this.allTasksForCourse);
                    logger.debug("after refresh");
                }
                this.recalculateStructure();
            });
            this.dragAndDropEnabled = true;
        } else {
            logger.debug("drag and drop already enabled");
        }
    }

    private void logTasks(List<Task> tasks) {
        if (logger.isDebugEnabled()) {
            tasks.forEach(x -> logger.debug("Structure {}  Name{}", (Object)x.getStructure(), (Object)x.getName()));
        }
    }

    private void recalculateStructure() {
        int counter = 0;
        for (Task task : this.allTasksForCourse) {
            task.setStructure(String.format("%04d", counter));
            ++counter;
        }
    }

    private void addTask() {
        this.openTaskDialog("url");
    }

    private void addHeadline() {
        this.openTaskDialog("headline");
    }

    private void openTaskDialog(String taskType) {
        String courseId = ((Course)((ComboShort)this.courseComboBox.getValue()).getId()).getCourseId();
        if (courseId == null) {
            this.showNotificationMiddle(this.i18nService.getTranslation("TaskView.msg.noCourseSelected", this.getLocale(), new Object[0]), 2);
        } else {
            TaskDialog taskDialog = new TaskDialog(this.mainLayoutUI, courseId, null, this, taskType, this.allTasksForCourse.size());
            taskDialog.open();
        }
    }

    @Autowired
    public void setRememberTeacherService(RememberTeacherService rememberTeacherService) {
        this.rememberTeacherService = rememberTeacherService;
    }

    @Autowired
    public void setTccConverterService(TccConverterService tccConverterService) {
        this.tccConverterService = tccConverterService;
    }

    @Autowired
    public void setTask2ToolAssigner(Task2ToolAssignerService task2ToolAssigner) {
        this.task2ToolAssigner = task2ToolAssigner;
    }
}

