/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.views.teacher;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Pre;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.spring.annotation.UIScope;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.node.Course;
import de.mahlsdorf.groupservice.model.node.LearningGroup;
import de.mahlsdorf.groupservice.model.node.Task;
import de.mahlsdorf.groupservice.model.node.TaskResult;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.model.ui.ComboShort;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.groupservice.RememberTeacherService;
import de.mahlsdorf.groupservice.service.groupservice.TaskIconUrlChecker;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.styling.TaskGridRenderer;
import de.mahlsdorf.groupservice.ui.layout.styling.TaskGridStyler;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Route(value="manageTasksAndGrades", layout=MainAppLayout.class)
@Component
@UIScope
public class TaskViewWithGradeAsSubView
extends BaseView {
    private static final Logger logger = LoggerFactory.getLogger(TaskViewWithGradeAsSubView.class);
    private static final String MSG_KEY_VIEWNAME = "TaskViewWithGradeAsSubView.";
    private static final String STRUCTURE = "structure";
    private final List<ComboShort<Course>> allCoursesForTeacherAndLearningGroupList = new ArrayList();
    private final List<Task> allTasksForCourse = new ArrayList();
    private final Neo4JBaseService neo4JService;
    private final List<Button> buttonList = new ArrayList();
    private final TaskIconUrlChecker taskIconUrlChecker;
    private Grid<Task> gridAllTasksForCourse;
    private ComboBox<ComboShort<Teacher>> teacherComboBox;
    private ComboBox<ComboShort<LearningGroup>> learningGroupComboBox;
    private List<ComboShort<LearningGroup>> learningGroupListForDataProvider;
    private ComboBox<ComboShort<Course>> courseComboBox;
    private final RememberTeacherService rememberTeacherService;
    private StringBuilder comboBoxMessageStringBuilder = new StringBuilder();
    private I18nService i18nService;
    private Dialog dialog;
    private Neo4JBaseService neo4JBaseService;

    public TaskViewWithGradeAsSubView(TaskIconUrlChecker taskUrl, Neo4JBaseService neo4JBaseService) {
        this.taskIconUrlChecker = taskUrl;
        this.neo4JBaseService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
        this.rememberTeacherService = RememberTeacherService.getInstance();
        this.neo4JService = neo4JBaseService;
    }

    public void beforeEnter(BeforeEnterEvent var1) {
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    private void initLayout() {
        this.removeAll();
        this.buttonList.clear();
        this.i18nService = I18nService.getInstance();
        this.learningGroupListForDataProvider = new ArrayList();
        VerticalLayout verticalLayout1 = new VerticalLayout();
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{this.getLoggedInInfoLayout()});
        verticalLayout1.setMargin(false);
        this.teacherComboBox = new ComboBox(this.i18nService.getTranslation("TaskViewWithGradeAsSubView.combobox.allTeacherInSchool", this.getLocale(), new Object[0]));
        this.learningGroupComboBox = new ComboBox(this.i18nService.getTranslation("TaskViewWithGradeAsSubView.combobox.allLearningGroupsAssigned", this.getLocale(), new Object[0]));
        this.courseComboBox = new ComboBox(this.i18nService.getTranslation("TaskViewWithGradeAsSubView.combobox.allCoursesForLearningGroup", this.getLocale(), new Object[0]));
        HorizontalLayout hlayoutCombos = new HorizontalLayout();
        hlayoutCombos.setSpacing(true);
        hlayoutCombos.setMargin(false);
        hlayoutCombos.add(new com.vaadin.flow.component.Component[]{this.teacherComboBox, this.learningGroupComboBox, this.courseComboBox});
        this.teacherComboBox.setSizeFull();
        this.learningGroupComboBox.setSizeFull();
        this.courseComboBox.setSizeFull();
        hlayoutCombos.setWidthFull();
        hlayoutCombos.setSpacing(true);
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{hlayoutCombos});
        HorizontalLayout hLayoutGrids = new HorizontalLayout();
        hLayoutGrids.setSpacing(false);
        this.gridAllTasksForCourse = new Grid();
        this.createTaskGridForLaunchLink(this.gridAllTasksForCourse);
        hLayoutGrids.add(new com.vaadin.flow.component.Component[]{this.gridAllTasksForCourse});
        hLayoutGrids.setSizeFull();
        Span label = new Span(this.i18nService.getTranslation("TaskViewWithGradeAsSubView.label.tasksForCourse", this.getLocale(), new Object[0]));
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{label, hLayoutGrids});
        this.gridAllTasksForCourse.setSizeFull();
        this.gridAllTasksForCourse.setSelectionMode(Grid.SelectionMode.SINGLE);
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{TaskViewWithGradeAsSubView.generateButtonLayout((List)this.buttonList)});
        this.add(new com.vaadin.flow.component.Component[]{verticalLayout1});
        this.setMargin(true);
        this.setSizeFull();
        this.searchForSchool();
        this.teacherComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)comboBoxTeacherComponentValueChangeEvent -> this.teacherHasChanged());
        this.learningGroupComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.learningGroupHasChanged());
        this.courseComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)comboBoxCourseComponentValueChangeEvent -> this.courseHasChanged());
        RememberTeacherService.getInstance().setTeacherInComboBox(this.teacherComboBox);
        this.teacherHasChanged();
        this.learningGroupHasChanged();
        this.enableButtons();
    }

    private void enableButtons() {
        boolean enables;
        boolean nEnables = enables = this.courseComboBox.getValue() != null && this.learningGroupComboBox.getValue() != null;
        this.buttonList.forEach(e -> e.setEnabled(nEnables));
    }

    private void createConfirmDeleteDialog() {
        if (this.gridAllTasksForCourse.getSelectedItems() == null || this.gridAllTasksForCourse.getSelectedItems().isEmpty()) {
            return;
        }
        this.dialog = new Dialog();
        String question = this.i18nService.getTranslation("TaskViewWithGradeAsSubView.msg.reallyDeleteTasks", this.getLocale(), new Object[0]);
        Button deleteButton = new Button(this.i18nService.getTranslation("TaskViewWithGradeAsSubView.button.delete", this.getLocale(), new Object[0]));
        deleteButton.addClickListener((ComponentEventListener & Serializable)click -> this.deleteSelectedTasks());
        Button cancelButton = new Button(this.i18nService.getTranslation("TaskViewWithGradeAsSubView.button.cancel", this.getLocale(), new Object[0]));
        cancelButton.addClickListener((ComponentEventListener & Serializable)click -> this.dialog.close());
        this.dialog.add(new com.vaadin.flow.component.Component[]{this.createConfirmDialogLayout(question, List.of(deleteButton, cancelButton))});
        this.dialog.open();
    }

    private void deleteSelectedTasks() {
        if (this.gridAllTasksForCourse.getSelectedItems() == null || this.gridAllTasksForCourse.getSelectedItems().isEmpty()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("TaskViewWithGradeAsSubView.msg.selectTask", this.getLocale(), new Object[0]), 2);
        } else {
            int count = 0;
            for (Task selectedTask : this.gridAllTasksForCourse.getSelectedItems()) {
                String taskId = selectedTask.getTaskId();
                this.neo4JService.deleteTasks(taskId);
                ++count;
            }
            this.showNotificationMiddle(this.i18nService.getTranslation("TaskViewWithGradeAsSubView.msg.tasksDeleted", this.getLocale(), new Object[]{count}), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            this.courseHasChanged();
        }
    }

    private void searchForSchool() {
        try {
            String schoolId = this.getSchoolId();
            List teacherList = new ArrayList<Teacher>();
            if (this.mainLayoutUI.getLoggedInTeacher().getAdmin().booleanValue()) {
                teacherList = this.neo4JBaseService.getTeacherPerSchool(schoolId);
            } else {
                teacherList.add(this.mainLayoutUI.getLoggedInTeacher());
            }
            List csTeacherList = this.createTeacherComboShortList(teacherList);
            if (teacherList != null && !teacherList.isEmpty()) {
                this.teacherComboBox.setItems((Collection)csTeacherList);
                this.teacherComboBox.setValue((Object)((ComboShort)csTeacherList.get(0)));
            } else {
                this.showNotificationMiddle(this.i18nService.getTranslation("TaskViewWithGradeAsSubView.msg.noTeacherFound", this.getLocale(), new Object[0]), 2);
            }
        }
        catch (Exception e) {
            logger.error("Exception during Search Courses {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void teacherHasChanged() {
        String teacherId = ((Teacher)((ComboShort)this.teacherComboBox.getValue()).getId()).getTeacherId();
        RememberTeacherService.getInstance().storeTeacherInSession((Teacher)((ComboShort)this.teacherComboBox.getValue()).getId());
        List lgGroup = this.neo4JBaseService.getLearnGroupPerTeacher(teacherId);
        List csLearnGroupList = this.createLearnGroupComboShortList(lgGroup);
        this.learningGroupListForDataProvider.clear();
        this.learningGroupListForDataProvider.addAll(csLearnGroupList);
        this.learningGroupComboBox.setItems((Collection)csLearnGroupList);
        if (csLearnGroupList != null && csLearnGroupList.size() > 0) {
            this.learningGroupComboBox.setValue((Object)((ComboShort)csLearnGroupList.get(0)));
        } else {
            this.learningGroupComboBox.setValue(null);
            this.showNotificationMiddle(this.i18nService.getTranslation("TaskViewWithGradeAsSubView.msg.noLearninggroupFound", this.getLocale(), new Object[0]), 2);
            this.courseHasChanged();
            this.learningGroupHasChangedFillUpCourses();
        }
        this.enableButtons();
    }

    private void learningGroupHasChanged() {
        long startTime = System.currentTimeMillis();
        if (this.learningGroupComboBox.getValue() != null) {
            String learningGroupId = ((LearningGroup)((ComboShort)this.learningGroupComboBox.getValue()).getId()).getGroupId();
            List courseList = this.neo4JBaseService.getCoursesForLearnGroup(learningGroupId);
            this.allCoursesForTeacherAndLearningGroupList.clear();
            List csCourseList = this.createCourseComboShortList(courseList);
            this.allCoursesForTeacherAndLearningGroupList.addAll(csCourseList);
            this.courseComboBox.getDataProvider().refreshAll();
            this.courseComboBox.setItems((Collection)csCourseList);
            String noCourse = this.i18nService.getTranslation("TaskViewWithGradeAsSubView.msg.noCourseFound", this.getLocale(), new Object[0]);
            if (courseList == null || courseList.isEmpty()) {
                this.courseComboBox.clear();
                this.courseComboBox.setValue(null);
                this.showNotificationMiddle(noCourse, 2);
            } else {
                this.courseComboBox.setValue((Object)((ComboShort)csCourseList.get(0)));
            }
            this.courseHasChanged();
            logger.info("Suche 'Courses in learningGroups {} msec", (Object)(System.currentTimeMillis() - startTime));
            this.learningGroupHasChangedFillUpCourses();
        } else {
            this.allCoursesForTeacherAndLearningGroupList.clear();
        }
        this.enableButtons();
    }

    private void courseHasChanged() {
        if (this.courseComboBox.getValue() != null && ((Course)((ComboShort)this.courseComboBox.getValue()).getId()).getCourseId() != null) {
            this.learningGroupHasChangedFillUpCourses();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void learningGroupHasChangedFillUpCourses() {
        try {
            if (this.courseComboBox.getValue() != null) {
                if (this.learningGroupComboBox.getValue() == null) {
                    this.courseComboBox.setValue(null);
                    return;
                }
                LearningGroup selectedLearningGroup = (LearningGroup)((ComboShort)this.learningGroupComboBox.getValue()).getId();
                String learnGroupId = selectedLearningGroup.getGroupId();
                List courseList = this.neo4JBaseService.getCoursesForLearnGroup(learnGroupId);
                List csCourseList = this.createCourseComboShortList(courseList);
                this.allCoursesForTeacherAndLearningGroupList.clear();
                this.allCoursesForTeacherAndLearningGroupList.addAll(csCourseList);
                this.courseComboBox.getDataProvider().refreshAll();
                this.allTasksForCourse.clear();
                this.fillUpGridWithTasksForSelectedCourse();
                if (this.comboBoxMessageStringBuilder == null) {
                    this.comboBoxMessageStringBuilder = new StringBuilder();
                }
            } else {
                this.allTasksForCourse.clear();
            }
        }
        finally {
            this.gridAllTasksForCourse.getDataProvider().refreshAll();
        }
    }

    public void fillUpGridWithTasksForSelectedCourse() {
        if (this.courseComboBox.getValue() != null) {
            String courseId = ((Course)((ComboShort)this.courseComboBox.getValue()).getId()).getCourseId();
            List result = this.neo4JBaseService.getTasksForCourse(courseId);
            this.allTasksForCourse.clear();
            this.allTasksForCourse.addAll(result);
            ListDataProvider allTaskDataProvider = new ListDataProvider((Collection)this.allTasksForCourse);
            this.gridAllTasksForCourse.setDataProvider((DataProvider)allTaskDataProvider);
            this.gridAllTasksForCourse.getDataProvider().refreshAll();
            this.showNotificationMiddle(this.comboBoxMessageStringBuilder.toString(), 1);
        } else {
            this.allTasksForCourse.clear();
            this.gridAllTasksForCourse.getDataProvider().refreshAll();
        }
        this.comboBoxMessageStringBuilder = new StringBuilder();
    }

    private void createTaskGridForLaunchLink(Grid<Task> grid) {
        SerializableBiConsumer & Serializable launchRenderer = (SerializableBiConsumer & Serializable)(div, task) -> {
            if (task.getType().equals("LineItem")) {
                div.setText("");
            } else {
                div.setText(task.getName());
            }
        };
        grid.setSizeFull();
        String headerStructure = this.i18nService.getTranslation("TaskViewWithGradeAsSubView.gridheader.structure", this.getLocale(), new Object[0]);
        String headerIcon = this.i18nService.getTranslation("TaskViewWithGradeAsSubView.gridheader.icon", this.getLocale(), new Object[0]);
        String headerLaunch = this.i18nService.getTranslation("TaskViewWithGradeAsSubView.gridheader.launch", this.getLocale(), new Object[0]);
        String headerDescription = this.i18nService.getTranslation("TaskViewWithGradeAsSubView.gridheader.description", this.getLocale(), new Object[0]);
        String headerPoints = this.i18nService.getTranslation("TaskViewWithGradeAsSubView.gridheader.points", this.getLocale(), new Object[0]);
        String headerType = this.i18nService.getTranslation("TaskViewWithGradeAsSubView.gridheader.type", this.getLocale(), new Object[0]);
        String headerId = this.i18nService.getTranslation("TaskViewWithGradeAsSubView.gridheader.id", this.getLocale(), new Object[0]);
        grid.addColumn(Task::getStructure).setHeader(headerStructure).setSortable(true).setFlexGrow(0).setAutoWidth(true).setKey("structure");
        grid.addColumn((Renderer)new ComponentRenderer(Div::new, new TaskGridRenderer((TaskIconUrlChecker)this.taskIconUrlChecker).taskIconRenderer)).setHeader(headerIcon).setFlexGrow(0).setAutoWidth(true);
        ((Grid.Column)grid.addColumn((Renderer)new ComponentRenderer(Div::new, (SerializableBiConsumer)launchRenderer)).setResizable(true)).setSortable(true).setHeader(headerLaunch).setFlexGrow(1).setAutoWidth(true);
        grid.addColumn(Task::getDescription).setHeader(headerDescription).setSortable(true).setFlexGrow(1);
        grid.addColumn((Renderer)new ComponentRenderer(Div::new, TaskGridRenderer.pointRenderer)).setHeader(headerPoints).setSortable(true).setFlexGrow(0).setAutoWidth(true);
        grid.addColumn(Task::getType).setHeader(headerType).setSortable(true).setFlexGrow(0).setAutoWidth(true);
        grid.addColumn(Task::getTaskId).setHeader(headerId).setSortable(true).setFlexGrow(0).setAutoWidth(true);
        Grid.Column sortCol = grid.getColumnByKey("structure");
        GridSortOrder order = new GridSortOrder(sortCol, SortDirection.ASCENDING);
        grid.sort(Collections.singletonList(order));
        grid.setClassNameGenerator((SerializableFunction)new TaskGridStyler());
        grid.setItemDetailsRenderer((Renderer)new ComponentRenderer((SerializableFunction & Serializable)taskSelected -> this.renderTaskGradesLayout(taskSelected)));
    }

    private com.vaadin.flow.component.Component renderTaskGradesLayout(Task task) {
        if (task.getType().equals("headline")) {
            return new Pre("");
        }
        VerticalLayout vLayout = new VerticalLayout();
        Html html = new Html(this.renderSingleTaskResults(task.getTaskId()));
        vLayout.add(new com.vaadin.flow.component.Component[]{html});
        return vLayout;
    }

    private String renderSingleTaskResults(String taskId) {
        List taskResults = this.neo4JBaseService.getTaskResultsForTask(taskId);
        Collections.sort(taskResults);
        StringBuilder sb = new StringBuilder();
        String tdAlignedEnd = "<td style=\"text-align:end\">";
        String thAlignedEnd = "<th style=\"text-align:end\">";
        sb.append("<table style=\"width:100%\">");
        Locale locale = UI.getCurrent().getLocale();
        String countTH = this.i18nService.getTranslation("TaskViewWithGradeAsSubView.tableresultheader.count", locale, new Object[0]);
        String firstNameTH = this.i18nService.getTranslation("TaskViewWithGradeAsSubView.tableresultheader.firstName", locale, new Object[0]);
        String lastNameTH = this.i18nService.getTranslation("TaskViewWithGradeAsSubView.tableresultheader.lastName", locale, new Object[0]);
        String scoreTH = this.i18nService.getTranslation("TaskViewWithGradeAsSubView.tableresultheader.score", locale, new Object[0]);
        String commentTH = this.i18nService.getTranslation("TaskViewWithGradeAsSubView.tableresultheader.comment", locale, new Object[0]);
        String executedTH = this.i18nService.getTranslation("TaskViewWithGradeAsSubView.tableresultheader.executed", locale, new Object[0]);
        String createdTH = this.i18nService.getTranslation("TaskViewWithGradeAsSubView.tableresultheader.created", locale, new Object[0]);
        sb.append("<tr>" + thAlignedEnd + countTH + "</th>" + thAlignedEnd + firstNameTH + "</th>" + thAlignedEnd + lastNameTH + "</th>" + thAlignedEnd + scoreTH + "</th>" + thAlignedEnd + commentTH + "</th>" + thAlignedEnd + executedTH + "</th>" + thAlignedEnd + createdTH + "</th></tr>");
        int count = 0;
        for (TaskResult line : taskResults) {
            String marker = "</td><td style=\"text-align:end\">";
            if (line.getScoreGiven() < 1.0E-9) {
                marker = "</td><td style=\"color:red;text-align:end\">";
            }
            String comment = line.getComment();
            if (line.getComment().equals("nicht ausgef\u00fchrt")) {
                comment = this.i18nService.getTranslation("TaskViewWithGradeAsSubView.column.notExecuted", locale, new Object[0]);
            }
            sb.append("<tr>" + tdAlignedEnd + count + "</td>" + tdAlignedEnd + line.getStudentFirstName() + "</td>" + tdAlignedEnd + line.getStudentLastName() + marker + line.getScoreGiven() + "</td>" + tdAlignedEnd + comment + "</td>" + tdAlignedEnd + (Serializable)(line.getModifiedLocalDateTime() == null ? "" : line.getModifiedLocalDateTime()) + "</td>" + tdAlignedEnd + line.getCreated() + "</td></tr>");
            ++count;
        }
        sb.append("</table>");
        return sb.toString();
    }
}

