/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.views.teacher;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.spring.annotation.UIScope;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.node.PersonIF;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.dialogs.ConfirmDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.PasswordChangeDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.TeacherDialog;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Route(value="allTeacher", layout=MainAppLayout.class)
@Component
@UIScope
public class TeacherView
extends BaseView {
    private static final Logger logger = LoggerFactory.getLogger(TeacherView.class);
    private static final String MSG_KEY_VIEWNAME = "TeacherView.";
    VerticalLayout verticalLayout1;
    private Grid<Teacher> grid;
    private I18nService i18nService;
    private Neo4JBaseService neo4JBaseService;

    public TeacherView(@Autowired Neo4JBaseService neo4JBaseService) {
        this.neo4JBaseService = neo4JBaseService;
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.i18nService = I18nService.getInstance();
            this.initLayout();
        }
    }

    public void beforeEnter(BeforeEnterEvent var1) {
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    private void initLayout() {
        this.i18nService = I18nService.getInstance();
        this.removeAll();
        this.verticalLayout1 = new VerticalLayout();
        Span descLabel = new Span(this.i18nService.getTranslation("TeacherView.label.allTeacher", this.getLocale(), new Object[0]));
        this.verticalLayout1.add(new com.vaadin.flow.component.Component[]{descLabel});
        this.verticalLayout1.add(new com.vaadin.flow.component.Component[]{this.getLoggedInInfoLayout()});
        this.verticalLayout1.setMargin(true);
        this.schoolId = this.getSchoolId();
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setSpacing(true);
        this.verticalLayout1.add(new com.vaadin.flow.component.Component[]{horizontalLayout});
        this.grid = new Grid();
        this.grid.setWidth("100%");
        this.verticalLayout1.add(new com.vaadin.flow.component.Component[]{this.grid});
        this.createTeacherGrid();
        Button addButton = new Button(this.i18nService.getTranslation("TeacherView.button.add", this.getLocale(), new Object[0]));
        addButton.setId("BtnNewId");
        addButton.addClickListener((ComponentEventListener & Serializable)clickEvent -> this.addTeacher());
        Button editButton = new Button(this.i18nService.getTranslation("TeacherView.button.update", this.getLocale(), new Object[0]));
        editButton.setId("BtnChangeId");
        editButton.addClickListener((ComponentEventListener & Serializable)clickEvent -> this.updateTeacher());
        Button deleteButton = new Button(this.i18nService.getTranslation("TeacherView.button.delete", this.getLocale(), new Object[0]));
        deleteButton.setId("BtnDeleteId");
        deleteButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.doDeleteStart());
        if (!this.mainLayoutUI.getLoggedInTeacher().getAdmin().booleanValue()) {
            deleteButton.setEnabled(false);
        }
        Button passwordButton = new Button(this.i18nService.getTranslation("TeacherView.button.password", this.getLocale(), new Object[0]));
        passwordButton.setId("BtnPasswordId");
        passwordButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.changePassword());
        this.verticalLayout1.add(new com.vaadin.flow.component.Component[]{TeacherView.generateButtonLayout(Arrays.asList(addButton, editButton, deleteButton, passwordButton))});
        this.add(new com.vaadin.flow.component.Component[]{this.verticalLayout1});
        this.setMargin(true);
        this.setSizeFull();
        this.fillUpTheGrid();
    }

    private void createTeacherGrid() {
        String headerNumber = this.i18nService.getTranslation("TeacherView.gridheader.number", this.getLocale(), new Object[0]);
        String headerGivenName = this.i18nService.getTranslation("TeacherView.gridheader.givenName", this.getLocale(), new Object[0]);
        String headerLastname = this.i18nService.getTranslation("TeacherView.gridheader.lastName", this.getLocale(), new Object[0]);
        String headerLoginName = this.i18nService.getTranslation("TeacherView.gridheader.loginName", this.getLocale(), new Object[0]);
        String headerAdmin = this.i18nService.getTranslation("TeacherView.gridheader.admin", this.getLocale(), new Object[0]);
        this.grid.addColumn(Teacher::getTeacherId).setHeader(headerNumber).setSortable(true);
        this.grid.addColumn(Teacher::getFirstName).setHeader(headerGivenName).setSortable(true);
        this.grid.addColumn(Teacher::getLastName).setHeader(headerLastname).setSortable(true);
        this.grid.addColumn(Teacher::getLoginName).setHeader(headerLoginName).setSortable(true);
        this.grid.addColumn(Teacher::getAdmin).setHeader(headerAdmin).setSortable(true);
    }

    private void addTeacher() {
        TeacherDialog teacherWindow = new TeacherDialog(this.mainLayoutUI, this.schoolId, null, this, this.loggedInTeacher);
        teacherWindow.open();
    }

    private void updateTeacher() {
        Set selectedItems = this.grid.getSelectedItems();
        if (this.checkNoTeacherIsSelected(selectedItems)) {
            return;
        }
        Teacher selectedTeacher = (Teacher)selectedItems.iterator().next();
        TeacherDialog teacherWindow = new TeacherDialog(this.mainLayoutUI, this.schoolId, selectedTeacher, this, this.mainLayoutUI.getLoggedInTeacher());
        if (teacherWindow.isEditAllowed(selectedTeacher, this.mainLayoutUI.getLoggedInTeacher())) {
            teacherWindow.open();
        }
    }

    private void doDeleteStart() {
        Set selectedTeachers = this.grid.getSelectedItems();
        if (this.checkNoTeacherIsSelected(selectedTeachers)) {
            return;
        }
        Teacher selectedTeacher = (Teacher)selectedTeachers.iterator().next();
        List learnGroups = this.neo4JBaseService.getLearnGroupPerTeacher(selectedTeacher.getTeacherId());
        if (!learnGroups.isEmpty()) {
            logger.info("Teacher {}  hat noch Lerngruppen, bitte vorher l\u00f6schen ", (Object)selectedTeacher.getTeacherId());
            this.showNotificationMiddle(this.i18nService.getTranslation("TeacherView.msg.teacherHasLearnGroups", this.getLocale(), new Object[]{learnGroups}), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            return;
        }
        if (this.checkIsDeleteLastAdmin(selectedTeacher)) {
            return;
        }
        Button deleteButton = new Button(this.i18nService.getTranslation("TeacherView.button.delete", this.getLocale(), new Object[0]));
        deleteButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.deleteTeacher());
        List<Button> additionalButtons = List.of(deleteButton);
        Div message = new Div(new com.vaadin.flow.component.Component[]{new Span(this.i18nService.getTranslation("TeacherView.msg.deleteReally", this.getLocale(), new Object[]{this.grid.getSelectedItems().size()}))});
        ConfirmDialog infoDialog = new ConfirmDialog(List.of(message), additionalButtons);
        infoDialog.open();
    }

    private boolean checkIsDeleteLastAdmin(Teacher selectedTeacher) {
        List allTeacher = this.neo4JBaseService.getTeacherPerSchool(this.mainLayoutUI.getSchoolId());
        HashSet adminTeacher = new HashSet();
        allTeacher.forEach(teacher -> {
            if (teacher.getAdmin().booleanValue() && !teacher.equals((Object)selectedTeacher)) {
                adminTeacher.add(teacher);
            }
        });
        if (adminTeacher.isEmpty()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("TeacherView.msg.cantDeleteLastAdmin", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            return true;
        }
        return false;
    }

    private void deleteTeacher() {
        Teacher selectedTeacher = (Teacher)this.grid.getSelectedItems().iterator().next();
        this.neo4JBaseService.deleteTeacher(selectedTeacher.getTeacherId());
        this.showNotificationMiddle(this.i18nService.getTranslation("TeacherView.msg.deleted", this.getLocale(), new Object[]{selectedTeacher.getFirstName(), selectedTeacher.getLastName()}), 2);
        this.fillUpTheGrid();
    }

    private void changePassword() {
        boolean notSelected = this.checkNoTeacherIsSelected(this.grid.getSelectedItems());
        if (notSelected) {
            return;
        }
        PersonIF teacher = (PersonIF)this.grid.getSelectedItems().iterator().next();
        PasswordChangeDialog passwordChangeDialog = new PasswordChangeDialog(this.mainLayoutUI, teacher, false);
        passwordChangeDialog.open();
    }

    private boolean checkNoTeacherIsSelected(Set<Teacher> selectedItems) {
        if (selectedItems == null || selectedItems.isEmpty()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("TeacherView.msg.selectTeacher", this.getLocale(), new Object[0]), 2);
            return true;
        }
        return false;
    }

    public void fillUpTheGrid() {
        try {
            String schoolId = this.schoolId;
            long startTime = System.currentTimeMillis();
            List teacherList = this.neo4JBaseService.getTeacherPerSchool(schoolId);
            this.grid.setItems((Collection)teacherList);
            if (logger.isInfoEnabled()) {
                logger.info(String.format("suche ben\u00f6tigte msec %s", System.currentTimeMillis() - startTime));
            }
        }
        catch (Exception e) {
            logger.error("Exception during Search of Students {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

