/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.views.teacher;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.spring.annotation.UIScope;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.node.Tool;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.dialogs.Lti13DynamicRegistrationDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.ToolDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.ToolInfoDialog;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Route(value="allTools", layout=MainAppLayout.class)
@Component
@UIScope
public class ToolView
extends BaseView {
    private static final Logger logger = LoggerFactory.getLogger(ToolView.class);
    private static final String MSG_KEY_VIEWNAME = "ToolView.";
    private Grid<Tool> grid;
    private final I18nService i18nService = I18nService.getInstance();
    private Dialog confirmDialog;
    private Tool selectedTool;
    private String startRegistrationUrl;
    private Neo4JBaseService neo4JBaseService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();

    public ToolView(@Value(value="${dynreg.starturl}") String startRegistrationUrl) {
        this.startRegistrationUrl = startRegistrationUrl;
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    public void beforeEnter(BeforeEnterEvent var1) {
        if (this.isUserLoggedInOrNavigateToHome()) {
            this.initLayout();
        }
    }

    private void initLayout() {
        if (!this.mainLayoutUI.isFeatureLti13Enabled()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("ToolView.msg.notAllowed", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            return;
        }
        this.removeAll();
        Span caption = new Span(this.i18nService.getTranslation("ToolView.label.descriptonView", this.getLocale(), new Object[0]));
        VerticalLayout verticalLayout1 = new VerticalLayout();
        verticalLayout1.setMargin(true);
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{this.getLoggedInInfoLayout()});
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{caption});
        this.grid = new Grid();
        this.grid.setWidth("100%");
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{this.grid});
        String gridheaderToolId = this.i18nService.getTranslation("ToolView.gridheader.toolId", this.getLocale(), new Object[0]);
        String gridheaderToolName = this.i18nService.getTranslation("ToolView.gridheader.toolName", this.getLocale(), new Object[0]);
        String gridheaderToolDescription = this.i18nService.getTranslation("ToolView.gridheader.toolDescription", this.getLocale(), new Object[0]);
        String gridheaderToolClientId = this.i18nService.getTranslation("ToolView.gridheader.clientId", this.getLocale(), new Object[0]);
        String gridheaderDeeplinkUrl = this.i18nService.getTranslation("ToolView.gridheader.deeplinkUrl", this.getLocale(), new Object[0]);
        this.grid.addColumn(Tool::getToolId).setHeader(gridheaderToolId).setSortable(true).setResizable(true);
        this.grid.addColumn(Tool::getToolName).setHeader(gridheaderToolName).setSortable(true).setResizable(true);
        this.grid.addColumn(Tool::getToolDescription).setHeader(gridheaderToolDescription).setSortable(true).setResizable(true);
        this.grid.addColumn(Tool::getClientId).setHeader(gridheaderToolClientId).setSortable(true).setResizable(true);
        this.grid.addColumn(Tool::getDeeplinkUrl).setHeader(gridheaderDeeplinkUrl).setSortable(true).setResizable(true);
        Button addButton = new Button(this.i18nService.getTranslation("ToolView.button.add", this.getLocale(), new Object[0]));
        addButton.addClickListener((ComponentEventListener & Serializable)event -> this.addTool());
        Button editButton = new Button(this.i18nService.getTranslation("ToolView.button.update", this.getLocale(), new Object[0]));
        editButton.addClickListener((ComponentEventListener & Serializable)event -> this.editTool());
        Button deleteButton = new Button(this.i18nService.getTranslation("ToolView.button.delete", this.getLocale(), new Object[0]));
        deleteButton.addClickListener((ComponentEventListener & Serializable)event -> this.deleteToolStart());
        Button infoButton = new Button(this.i18nService.getTranslation("ToolView.button.Info", this.getLocale(), new Object[0]));
        infoButton.addClickListener((ComponentEventListener & Serializable)click -> this.showInfo());
        Button dynamicRegistrationButton = new Button(this.i18nService.getTranslation("ToolView.button.DynReg", this.getLocale(), new Object[0]));
        dynamicRegistrationButton.addClickListener((ComponentEventListener & Serializable)e -> this.startDynReg());
        List<Button> buttonList = Arrays.asList(dynamicRegistrationButton, infoButton, addButton, editButton, deleteButton);
        verticalLayout1.add(new com.vaadin.flow.component.Component[]{ToolView.generateButtonLayout(buttonList)});
        if (!this.mainLayoutUI.getLoggedInTeacher().getAdmin().booleanValue()) {
            ToolView.disableButtons(buttonList);
        }
        this.add(new com.vaadin.flow.component.Component[]{verticalLayout1});
        this.setMargin(true);
        this.setSizeFull();
        this.fillUpTheGrid();
    }

    private void startDynReg() {
        this.showNotificationMiddle("dyn regstart ", ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
        Lti13DynamicRegistrationDialog dialog = new Lti13DynamicRegistrationDialog(this.mainLayoutUI, this, this.startRegistrationUrl);
        dialog.open();
    }

    private void addTool() {
        ToolDialog addWindow = new ToolDialog(this.schoolId, null, this, this.neo4JBaseService);
        addWindow.open();
    }

    private void showInfo() {
        if (!this.isToolSelected()) {
            return;
        }
        Tool selectedTool = (Tool)this.grid.getSelectedItems().iterator().next();
        ToolInfoDialog toolInfoDialog = new ToolInfoDialog(selectedTool, this.mainLayoutUI.getHostUri());
        toolInfoDialog.open();
    }

    private void editTool() {
        if (!this.isToolSelected()) {
            return;
        }
        Tool tool = (Tool)this.grid.getSelectedItems().iterator().next();
        ToolDialog addWindow = new ToolDialog(this.schoolId, tool, this, this.neo4JBaseService);
        addWindow.open();
    }

    private void deleteToolStart() {
        if (!this.isToolSelected()) {
            return;
        }
        try {
            this.selectedTool = (Tool)this.grid.getSelectedItems().iterator().next();
            List result = this.neo4JBaseService.getTaskByToolId(this.selectedTool.getToolId());
            if (result.size() > 0) {
                this.showNotificationMiddle(this.i18nService.getTranslation("ToolView.msg.tasksExisting", this.getLocale(), new Object[]{this.selectedTool.getToolName(), result.size()}), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
                return;
            }
            this.confirmDialog = this.createConfirmDialog();
        }
        catch (Exception e) {
            logger.error("exception during save {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private boolean isToolSelected() {
        if (this.grid.getSelectedItems().isEmpty()) {
            this.showNotificationMiddle(this.i18nService.getTranslation("ToolView.msg.selectTool", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            return false;
        }
        return true;
    }

    private void deleteTool() {
        try {
            this.neo4JBaseService.deleteTool(this.selectedTool.getToolId());
            this.showNotificationMiddle(this.i18nService.getTranslation("ToolView.msg.deleted", this.getLocale(), new Object[]{this.selectedTool.getToolName()}), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            this.fillUpTheGrid();
        }
        catch (Exception e) {
            this.showNotificationMiddle(this.i18nService.getTranslation("ToolView.msg.exceptionDelete", this.getLocale(), new Object[]{e.getMessage()}), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
        }
        finally {
            this.confirmDialog.close();
        }
    }

    private Dialog createConfirmDialog() {
        Dialog dialog = new Dialog();
        String question = this.i18nService.getTranslation("ToolView.msg.reallyDeleteTool", this.getLocale(), new Object[]{this.selectedTool.getToolId() + " " + this.selectedTool.getToolName()});
        Button deleteButton = new Button(this.i18nService.getTranslation("ToolView.button.Delete", this.getLocale(), new Object[0]));
        deleteButton.addClickListener((ComponentEventListener & Serializable)click -> this.deleteTool());
        Button cancelButton = new Button(this.i18nService.getTranslation("ToolView.button.Cancel", this.getLocale(), new Object[0]));
        cancelButton.addClickListener((ComponentEventListener & Serializable)click -> dialog.close());
        dialog.add(new com.vaadin.flow.component.Component[]{this.createConfirmDialogLayout(question, List.of(deleteButton, cancelButton))});
        dialog.open();
        return dialog;
    }

    public void fillUpTheGrid() {
        try {
            String schoolId = this.getSchoolId();
            long startTime = System.currentTimeMillis();
            List toolList = this.neo4JBaseService.getToolsForSchool(schoolId);
            this.grid.setItems((Collection)toolList);
            logger.info("suche ben\u00f6tigte {} msec ", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            logger.error("Exception during Search of Tools {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

