/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.utils;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaTimeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JavaTimeUtils.class);

    private JavaTimeUtils() {
    }

    public static Long getEpochInSecondsInUtc() {
        ZonedDateTime local = ZonedDateTime.now();
        ZonedDateTime gmt = local.withZoneSameInstant(ZoneId.of("GMT"));
        long diffInSec = TimeZone.getDefault().getRawOffset() / 1000;
        long diffDstInSec = TimeZone.getDefault().getDSTSavings() / 1000;
        LOG.info("Time {} UTC Dif in Sec {} DST Dif In Sec {} ", new Object[]{gmt.toEpochSecond(), diffInSec, diffDstInSec});
        long epoch = gmt.toEpochSecond();
        LOG.info("UTC Date is from caluclated Epoch {} as Date  {}", (Object)epoch, (Object)new Date(epoch * 1000L));
        return epoch;
    }
}

