/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.validator;

import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValueContext;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.validator.MyAbstractValidator;
import java.time.LocalDate;
import java.util.Locale;

public class DatePickerValidator
extends MyAbstractValidator<LocalDate> {
    private static final String msgKeyBase = "DatePickerValidator.msg.";
    private static final I18nService i18nService = I18nService.getInstance();
    private Locale locale;
    private LocalDate before = LocalDate.now();
    private LocalDate after = LocalDate.now();
    private boolean isBefore = false;
    private DatePicker beforeDP;
    private DatePicker afterDP;

    public DatePickerValidator(String errorMessage) {
        super(errorMessage);
    }

    public DatePickerValidator(DatePicker beforeDP, DatePicker afterDP, boolean isBefore, Locale locale) {
        super("start be before end");
        this.locale = locale;
        String msg = i18nService.getTranslation(msgKeyBase.concat("startBeforeEnd"), locale, new Object[0]);
        this.setErrorMessage(msg);
        this.before = (LocalDate)beforeDP.getValue();
        this.after = (LocalDate)afterDP.getValue();
        this.beforeDP = beforeDP;
        this.afterDP = afterDP;
        this.isBefore = isBefore;
    }

    public ValidationResult apply(LocalDate value, ValueContext valueContext) {
        return this.toResult((Object)value, this.isValid(value));
    }

    protected boolean isValid(LocalDate value) {
        this.before = (LocalDate)this.beforeDP.getValue();
        this.after = (LocalDate)this.afterDP.getValue();
        if (this.before == null) {
            return false;
        }
        if (this.after == null) {
            return false;
        }
        if (this.isBefore) {
            return value.isBefore(this.after);
        }
        return this.before.isBefore(value);
    }
}

