/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.validator;

import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValueContext;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.validator.MyAbstractValidator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolIdValidator
extends MyAbstractValidator<String> {
    private static final Logger LOG = LoggerFactory.getLogger(ToolIdValidator.class);
    private static final String msgKeyBase = "ToolIdValidator.msg.";
    private static final I18nService i18nService = I18nService.getInstance();
    private final boolean isNew;
    private Locale locale;
    private Neo4JBaseService neo4JBaseService;

    public ToolIdValidator(String toolId, boolean isNew, Locale locale, Neo4JBaseService neo4JBaseService) {
        super("required");
        this.neo4JBaseService = neo4JBaseService;
        this.locale = locale;
        String msg = i18nService.getTranslation(msgKeyBase.concat("duplicateId"), locale, new Object[0]);
        this.setErrorMessage(msg);
        this.isNew = isNew;
    }

    public ValidationResult apply(String value, ValueContext valueContext) {
        return this.toResult((Object)value, this.isValid(value));
    }

    protected boolean isValid(String value) {
        LOG.info("Id-to check {}", (Object)value);
        boolean isNotExistent = false;
        boolean patternMatch = true;
        if (this.isNew) {
            List existingToolListWithId = this.neo4JBaseService.getToolsById(value);
            Pattern toolIdPattern = Pattern.compile("[a-zA-Z0-9]{4,}");
            isNotExistent = existingToolListWithId.isEmpty();
            Matcher m = toolIdPattern.matcher(value);
            if (!m.matches()) {
                String msg = i18nService.getTranslation(msgKeyBase.concat("pattern"), this.locale, new Object[0]);
                this.setErrorMessage(msg);
                patternMatch = false;
                return false;
            }
            return isNotExistent && patternMatch;
        }
        return true;
    }
}

