/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.validator;

import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValueContext;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.validator.MyAbstractValidator;
import java.util.Locale;
import org.apache.commons.validator.routines.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlVaadinValidator
extends MyAbstractValidator<String> {
    private static final Logger LOG = LoggerFactory.getLogger(UrlVaadinValidator.class);
    private static final String msgKeyBase = "UrlVaadinValidator.msg.";
    private static final I18nService i18nService = I18nService.getInstance();
    private Locale locale;

    public UrlVaadinValidator(String errorMessage) {
        super(errorMessage);
    }

    public UrlVaadinValidator(String Url, Locale locale) {
        super("required");
        this.locale = locale;
        String msg = i18nService.getTranslation(msgKeyBase.concat("noUrl"), locale, new Object[0]);
        this.setErrorMessage(msg);
    }

    public ValidationResult apply(String value, ValueContext valueContext) {
        return this.toResult((Object)value, this.isValid(value));
    }

    protected boolean isValid(String value) {
        LOG.info("Id-to check {}", (Object)value);
        String[] urls = value.split("\n");
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes, 8L);
        for (String url : urls) {
            if (urlValidator.isValid(url)) continue;
            return false;
        }
        return true;
    }
}

