/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.configuration.filter;

import de.mahlsdorf.lti13.advantage.service.security.AccessTokenStore;
import de.mahlsdorf.lti13.exception.exception.ApiLti13Exception;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class AgsAndNamesAndRolesFilter
extends OncePerRequestFilter {
    private static final Logger myLogger = LoggerFactory.getLogger(AgsAndNamesAndRolesFilter.class);
    private AccessTokenStore accessTokenStore;

    public AgsAndNamesAndRolesFilter() {
        this.logger.info((Object)"creating filter for Security Assignment And Grades  and Names And Roles  ");
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (!this.checkAgsAndNamesAndRolesAuthorisation(httpServletRequest, httpServletResponse)) {
            throw new ServletException("not allowed");
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    boolean checkAgsAndNamesAndRolesAuthorisation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String path = httpServletRequest.getServletPath();
        if (myLogger.isTraceEnabled()) {
            myLogger.trace("ServletPath {}", (Object)path);
        }
        if (path.startsWith("/platformapi/v1/lti13/namesandroles/") || path.startsWith("/platformapi/v1/lti13/lineitems/")) {
            try {
                this.accessTokenStore.checkAccessToken(httpServletRequest);
            }
            catch (ApiLti13Exception e) {
                httpServletResponse.setStatus(e.getHttpStatus().value());
                return false;
            }
            catch (Exception e) {
                httpServletResponse.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
                return false;
            }
        } else if (myLogger.isTraceEnabled()) {
            myLogger.trace("ServletPath {}", (Object)path);
        }
        return true;
    }

    @Autowired
    public void setAccessTokenStore(AccessTokenStore accessTokenStore) {
        this.accessTokenStore = accessTokenStore;
    }
}

