/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.controller;

import de.mahlsdorf.groupservice.model.lti13.dynreg.DynRegMessagesSupportedDTO;
import de.mahlsdorf.groupservice.model.lti13.dynreg.DynRegPlatformConfigurationDTO;
import de.mahlsdorf.groupservice.model.lti13.dynreg.DynRegPlatformRegistrationDTO;
import de.mahlsdorf.groupservice.model.lti13.dynreg.DynRegToolConfigurationAckDTO;
import de.mahlsdorf.groupservice.model.lti13.dynreg.DynRegToolMessagesSupportedDTO;
import de.mahlsdorf.groupservice.model.lti13.dynreg.DynRegToolRegistrationDTO;
import de.mahlsdorf.groupservice.model.node.Tool;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.dynreg.DynamicRegistrationService;
import de.mahlsdorf.groupservice.service.security.KeyPairGenerator;
import de.mahlsdorf.lti13.advantage.constants.ConstantsPlatform;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(path={"/platformapi/v1/lti13/"})
public class DynamicRegistrationController {
    private static final String PARAM_SCHOOLID = "schoolId";
    private final Neo4JBaseService neo4JBaseService;
    private final CacheManager cacheManager;
    public static final String PLATFORM_FORMAT = "platform/%s/";
    private static final Logger LOG = LoggerFactory.getLogger(DynamicRegistrationController.class);
    private final String baseUrl;
    private final String platformBaseUrlLtiApi;
    private final DynamicRegistrationService dynamicRegistrationService;

    public DynamicRegistrationController(@Value(value="${platform.hosturi}") String baseUrl, DynamicRegistrationService dynamicRegistrationService, @Autowired Neo4JBaseService neo4JBaseService, @Autowired CacheManager cacheManager) {
        this.baseUrl = baseUrl;
        this.platformBaseUrlLtiApi = this.baseUrl.concat("platformapi/v1/lti13/");
        this.dynamicRegistrationService = dynamicRegistrationService;
        this.neo4JBaseService = neo4JBaseService;
        this.cacheManager = cacheManager;
    }

    @GetMapping(path={".well-known/opendid-configuration"})
    public ResponseEntity<DynRegPlatformRegistrationDTO> getConfiguration(@RequestParam String toolId) {
        LOG.info("return openId Configuration for Tool {}", (Object)toolId);
        DynRegPlatformRegistrationDTO dto = new DynRegPlatformRegistrationDTO();
        this.createPlatformRegistrationDto(dto, toolId);
        return ResponseEntity.ok((Object)dto);
    }

    @GetMapping(path={"registerStart"})
    public ResponseEntity<String> getRegistrationStartForm(@RequestParam String toolRegistrationUrl, @RequestParam String toolId, @RequestParam String schoolId) {
        String formHtml = (String)this.dynamicRegistrationService.initDynRegistration(toolRegistrationUrl, toolId).getBody();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PARAM_SCHOOLID, schoolId);
        this.cacheManager.getCache("registrationCache").put((Object)toolId, map);
        return ResponseEntity.ok((Object)formHtml);
    }

    @PostMapping(path={"registerTool"})
    public ResponseEntity<DynRegToolConfigurationAckDTO> registerTool(@RequestBody DynRegToolRegistrationDTO toolRegistrionDto, @RequestParam String toolId) {
        LOG.info("ToolRegistrationDTO {}", (Object)toolRegistrionDto);
        try {
            SimpleValueWrapper mapper = (SimpleValueWrapper)this.cacheManager.getCache("registrationCache").get((Object)toolId);
            Map map = (Map)mapper.get();
            String schoolId = (String)map.get(PARAM_SCHOOLID);
            DynRegToolConfigurationAckDTO result = new DynRegToolConfigurationAckDTO();
            Tool toolToCreate = new Tool();
            toolToCreate.setToolId(toolId);
            toolToCreate.setToolDescription(toolRegistrionDto.getToolConfiguration().getDescription());
            toolToCreate.setToolName(toolRegistrionDto.getToolConfiguration().getDescription());
            toolToCreate.setClientId(toolId);
            toolToCreate.setDeploymentId(toolRegistrionDto.getToolConfiguration().getDeployment_id());
            toolToCreate.setToolUrl(toolRegistrionDto.getToolConfiguration().getDomain());
            toolToCreate.setLoginInitUrl(toolRegistrionDto.getInitiate_login_uri());
            toolToCreate.setToolJwksUrl(toolRegistrionDto.getJwks_uri());
            String redirectUris = StringUtils.join((Iterable)toolRegistrionDto.getRedirect_uris(), (String)"\n");
            toolToCreate.setRedirectUrls(redirectUris);
            List messagesSupported = toolRegistrionDto.getToolConfiguration().getMessages_supported();
            String deepLinkUrl = "none";
            for (DynRegToolMessagesSupportedDTO message : messagesSupported) {
                if (!message.getType().equals("LtiDeepLinkingRequest")) continue;
                deepLinkUrl = message.getTarget_link_uri();
            }
            toolToCreate.setDeeplinkUrl(deepLinkUrl);
            Tool tempTool = new Tool();
            tempTool.setToolId("kid");
            tempTool = KeyPairGenerator.getInstance().createNewKeyPair(tempTool);
            toolToCreate.setPublicKeyAsPem(tempTool.getPublicKeyAsPem());
            toolToCreate.setPrivateKeyAsPem(tempTool.getPrivateKeyAsPem());
            toolToCreate.setKeyId(tempTool.getKeyId());
            this.neo4JBaseService.createToolAndRelation(toolToCreate, schoolId);
            LOG.info("New Tool with Id {} for school {} created ", (Object)toolId, (Object)schoolId);
            BeanUtils.copyProperties((Object)toolRegistrionDto, (Object)result);
            result.setClient_id(toolId);
            return ResponseEntity.ok((Object)result);
        }
        catch (Exception e) {
            LOG.error("Exception during registration  Message {}", (Object)e.getMessage(), (Object)e);
            return ResponseEntity.badRequest().build();
        }
    }

    private void createPlatformRegistrationDto(DynRegPlatformRegistrationDTO registrationDTO, String toolId) {
        registrationDTO.setIssuer(this.baseUrl);
        registrationDTO.setId_token_signing_alg_values_supported(List.of("RS256"));
        registrationDTO.setClaims_supported(List.of());
        String tokenUrl = String.format(this.platformBaseUrlLtiApi.concat("platform/%s/token"), toolId);
        registrationDTO.setToken_endpoint(tokenUrl);
        String loginInUrl = String.format(this.platformBaseUrlLtiApi.concat("platform/%s/auth"), toolId);
        registrationDTO.setAuthorization_endpoint(loginInUrl);
        String jwksUri = String.format(this.platformBaseUrlLtiApi.concat("platform/%s/jwks"), toolId);
        registrationDTO.setJwks_uri(jwksUri);
        String regUrlPlatform = String.format(this.platformBaseUrlLtiApi.concat("registerTool?toolId=%s"), toolId);
        registrationDTO.setRegistration_endpoint(regUrlPlatform);
        registrationDTO.setToken_endpoint_auth_methods_supported(List.of("private_key_jwt"));
        registrationDTO.setScopes_supported(ConstantsPlatform.SUPPORTED_SCOPES);
        registrationDTO.setClaims_supported(ConstantsPlatform.SUPPORTED_CLAIMS);
        DynRegPlatformConfigurationDTO platformConfigurationDTO = new DynRegPlatformConfigurationDTO();
        platformConfigurationDTO.setProduct_family_code("LTI_VAADIN_NEO4j");
        platformConfigurationDTO.setVersion("0.0.1");
        platformConfigurationDTO.setVariables(ConstantsPlatform.ALLOWED_VARIABLES);
        DynRegMessagesSupportedDTO ltiLaunchMessage = new DynRegMessagesSupportedDTO();
        ltiLaunchMessage.setType("https://purl.imsglobal.org/spec/lti/claim/message_type");
        DynRegMessagesSupportedDTO ltiDeeplinkMessage = new DynRegMessagesSupportedDTO();
        ltiDeeplinkMessage.setType("LtiDeepLinkingRequest");
        platformConfigurationDTO.setMessages_supported(List.of(ltiLaunchMessage, ltiDeeplinkMessage));
        registrationDTO.setPlatformConfiguration(platformConfigurationDTO);
    }
}

