/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.controller;

import de.mahlsdorf.lti13.advantage.service.jwks.JwksService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(path={"/platformapi/v1/lti13/"})
public class JWKSController {
    private static final Logger logger = LoggerFactory.getLogger(JWKSController.class);
    private final Map<String, String> cacheToolKeys = new HashMap();
    private JwksService jwksService;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"}, value={"platform/{platformId}/jwks"})
    public ResponseEntity<String> getJwksJsonForPlatform(@PathVariable String platformId) {
        String errorMessage = "";
        String cachedJwks = "";
        try {
            cachedJwks = this.jwksService.generateMyJwksAsPlatformFromPrivateKeyForTool(platformId);
            if (cachedJwks == null) {
                return ResponseEntity.notFound().build();
            }
            return ResponseEntity.ok((Object)cachedJwks);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            logger.error("Exception during genereation of jwks for platformid {} message:{} ", new Object[]{platformId, errorMessage, e});
            return ResponseEntity.badRequest().body((Object)("Fehler bei der JWKS Generierung " + errorMessage));
        }
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"}, value={"tool/{toolId}/jwks"})
    public ResponseEntity<String> getJwksJsonForTool(@PathVariable String toolId) {
        String errorMessage = "";
        String cachedJwks = "";
        try {
            if (!this.cacheToolKeys.containsKey(toolId)) {
                cachedJwks = this.jwksService.generateMyJwksAsPlatformFromPrivateKeyForTool(toolId);
                if (cachedJwks == null) {
                    return ResponseEntity.notFound().build();
                }
                this.cacheToolKeys.put(toolId, cachedJwks);
            } else {
                cachedJwks = (String)this.cacheToolKeys.get(toolId);
                logger.debug("use cached jwks for toolid {} key: {} ", (Object)toolId, (Object)cachedJwks);
            }
            return ResponseEntity.ok((Object)cachedJwks);
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            logger.error("Exception during genereation of jwks {} {} ", new Object[]{toolId, errorMessage, e});
            return ResponseEntity.badRequest().body((Object)("Fehler bei der JWKS Generierung " + errorMessage));
        }
    }

    @Autowired
    public void setJwksService(JwksService jwksService) {
        this.jwksService = jwksService;
    }
}

