/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.controller;

import de.mahlsdorf.lti13.advantage.service.ags.Lti13LineItemsService;
import de.mahlsdorf.lti13.exception.exception.ApiLti13Exception;
import de.mahlsdorf.lti13.lti13models.model.lti.grades.Lti13LineItem;
import de.mahlsdorf.lti13.lti13models.model.lti.grades.Lti13LineItemResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/platformapi/v1/lti13/"})
public class LineItemsController {
    private static final Logger logger = LoggerFactory.getLogger(LineItemsController.class);
    private Lti13LineItemsService lineItemsService;

    @GetMapping(path={"lineitems/{toolId}/{courseId}"}, produces={"application/vnd.ims.lis.v2.lineitemcontainer+json"})
    public ResponseEntity<List<Lti13LineItem>> getLineItemsForCourseAndTool(@PathVariable String courseId, @PathVariable String toolId) {
        try {
            logger.info("get LineItems for ToolId {} and CourseId {} ", (Object)toolId, (Object)courseId);
            return this.lineItemsService.getLineItemsForToolAndCourse(courseId, toolId);
        }
        catch (ApiLti13Exception e) {
            logger.error("Got Exception while getting LineItems ", (Throwable)e);
            return ResponseEntity.status((int)e.getHttpStatus().value()).build();
        }
        catch (Exception e) {
            logger.error("Gto Exception while getting LineItems ", (Throwable)e);
            return ResponseEntity.status((int)HttpStatus.INTERNAL_SERVER_ERROR.value()).build();
        }
    }

    @PostMapping(path={"lineitems/{toolId}/{courseId}"}, produces={"application/vnd.ims.lis.v2.lineitem+json"})
    public ResponseEntity<String> createALineItem(@RequestBody String lineItemToCreate, @PathVariable String courseId, @PathVariable String toolId) {
        try {
            logger.info("create a LineItems for ToolId {} and CourseId {}  and LineItem {}", new Object[]{toolId, courseId, lineItemToCreate});
            return this.lineItemsService.createALineItemsForToolAndCourse(courseId, toolId, lineItemToCreate);
        }
        catch (ApiLti13Exception e) {
            logger.error("Got Exception while creating LineItems ", (Throwable)e);
            return ResponseEntity.status((int)e.getHttpStatus().value()).build();
        }
        catch (Exception e) {
            logger.error("got Exception while create LineItems JSON {}", (Object)lineItemToCreate, (Object)e);
            return ResponseEntity.status((int)HttpStatus.INTERNAL_SERVER_ERROR.value()).build();
        }
    }

    @GetMapping(path={"lineitem/{toolId}/{courseId}/{taskId}/results"}, produces={"application/vnd.ims.lis.v2.resultcontainer+json"})
    public ResponseEntity<List<Lti13LineItemResult>> getLineItemsResults(@PathVariable String toolId, @PathVariable String courseId, @PathVariable String taskId) {
        try {
            return this.lineItemsService.getLineItemsResults(toolId, courseId, taskId);
        }
        catch (ApiLti13Exception e) {
            return ResponseEntity.status((int)e.getHttpStatus().value()).build();
        }
        catch (Exception e) {
            logger.error("Exception while Getting Results for LineItem tool {} course {} task {}", new Object[]{toolId, courseId, taskId, e});
            return ResponseEntity.status((int)500).build();
        }
    }

    @Autowired
    public void setLineItemsService(Lti13LineItemsService lineItemsService) {
        this.lineItemsService = lineItemsService;
    }
}

