/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.controller;

import de.mahlsdorf.lti13.advantage.service.token.TokenService;
import de.mahlsdorf.lti13.exception.exception.ApiLti13Exception;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(path={"platformapi/v1/lti13/"})
public class LoginInitController {
    private static final Logger logger = LoggerFactory.getLogger(LoginInitController.class);
    private TokenService tokenService;

    @RequestMapping(method={RequestMethod.POST}, value={"platform/{platformId}/login_init"})
    public ResponseEntity<Object> launchLtiForAllAsPost(@RequestBody MultiValueMap<String, String> formData, @PathVariable String platformId, HttpServletRequest request, HttpServletResponse response) {
        return this.getAccessToken(formData, platformId, request, response);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"platform/{platformId}/login_init"})
    public ResponseEntity<Object> launchLtiForAllAsGet(@RequestBody MultiValueMap<String, String> formData, @PathVariable String platformId, HttpServletRequest request, HttpServletResponse response) {
        return this.getAccessToken(formData, platformId, request, response);
    }

    private ResponseEntity getAccessToken(MultiValueMap<String, String> formData, String platformId, HttpServletRequest request, HttpServletResponse response) {
        try {
            logger.info("FormData {} platformId {} ", formData, (Object)platformId);
            String token = this.tokenService.grantAccessToken(formData, platformId);
            logger.info("granted Token {}", (Object)token);
            return ResponseEntity.status((int)500).body((Object)"not implemented");
        }
        catch (ApiLti13Exception e) {
            logger.error("Exception {} HttpStatus {}", (Object)e.getMessage(), (Object)e.getHttpStatus().value());
            return ResponseEntity.status((int)e.getHttpStatus().value()).body((Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error("Exception {} HttpStatus {}", (Object)e.getMessage(), (Object)500);
            return ResponseEntity.status((int)500).body((Object)e.getMessage());
        }
    }

    @Autowired
    public void setTokenService(TokenService tokenService) {
        this.tokenService = tokenService;
    }
}

