/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.controller;

import de.mahlsdorf.lti13.advantage.service.namesandroles.NamesAndRolesService;
import de.mahlsdorf.lti13.exception.exception.ApiLti13Exception;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/platformapi/v1/lti13/namesandroles/"})
public class NamesAndRolesController {
    private static final Logger logger = LoggerFactory.getLogger(NamesAndRolesController.class);
    private NamesAndRolesService namesAndRolesService;

    @GetMapping(path={"{toolId}/{courseId}/"}, produces={"application/vnd.ims.lti-nrps.v2.membershipcontainer+json"})
    public ResponseEntity<String> getNamesAndRoles(@PathVariable String courseId, @PathVariable String toolId, HttpServletRequest request, HttpServletResponse response) {
        try {
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                if (!logger.isInfoEnabled()) continue;
                logger.info("Header Names and Roles  {}:{},", (Object)headerName, (Object)request.getHeader(headerName));
            }
            logger.info("returning Names and Roles for course {} and ToolId {} ", (Object)courseId, (Object)toolId);
            return this.namesAndRolesService.getNamesAndRolesForCourse(courseId);
        }
        catch (ApiLti13Exception e) {
            logger.info("LTI Exception while getting Names and Roles for Course {}", (Object)courseId, (Object)e);
            return ResponseEntity.status((HttpStatusCode)e.getHttpStatus()).body((Object)e.getMessage());
        }
    }

    @Autowired
    public void setNamesAndRolesService(NamesAndRolesService namesAndRolesService) {
        this.namesAndRolesService = namesAndRolesService;
    }
}

