/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.controller;

import de.mahlsdorf.groupservice.model.lti13.oidclogin.OidcLaunchCacheDataDTO;
import de.mahlsdorf.groupservice.model.lti13.oidclogin.OidcLaunchTypeEnum;
import de.mahlsdorf.groupservice.model.node.Course;
import de.mahlsdorf.groupservice.model.node.Task;
import de.mahlsdorf.groupservice.model.node.Tool;
import de.mahlsdorf.groupservice.service.lti13.LaunchDeepLinkService;
import de.mahlsdorf.groupservice.service.lti13.LaunchService;
import de.mahlsdorf.groupservice.service.lti13.Lti13OidcHelper;
import de.mahlsdorf.lti13.advantage.internalmodel.launch.LaunchInfo;
import de.mahlsdorf.lti13.advantage.service.ltirequest.LtiLaunchService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(path={"platformapi/v1/lti13/platform/{toolId}/"})
public class OidcLoginController {
    public static final String PATH_OIDC_LOGIN = "auth";
    private static final Logger LOG = LoggerFactory.getLogger(OidcLoginController.class);
    private final LaunchService launchService;
    private final LtiLaunchService ltiLaunchService;
    private final CacheManager cacheManager;
    private final Lti13OidcHelper lti13OidcHelper;
    private final LaunchDeepLinkService launchDeepLinkService;

    public OidcLoginController(@Autowired LaunchService launchService, @Autowired CacheManager cacheManager, @Autowired LtiLaunchService ltiLaunchService, @Autowired Lti13OidcHelper lti13OidcHelper, @Autowired LaunchDeepLinkService launchDeepLinkService) {
        this.launchService = launchService;
        this.cacheManager = cacheManager;
        this.ltiLaunchService = ltiLaunchService;
        this.lti13OidcHelper = lti13OidcHelper;
        this.launchDeepLinkService = launchDeepLinkService;
    }

    @PostMapping(value={"auth"})
    public ResponseEntity<String> doPostAuth(@PathVariable String toolId, HttpServletRequest request, HttpServletResponse response) {
        return this.getIdToken(toolId, request, response);
    }

    @GetMapping(value={"auth"})
    public ResponseEntity<String> doGetAuth(@PathVariable String toolId, HttpServletRequest request, HttpServletResponse response) {
        return this.getIdToken(toolId, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<String> getIdToken(@PathVariable String toolId, HttpServletRequest request, HttpServletResponse response) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("got OidcLogin for Tool '{}'", (Object)toolId);
        }
        if (LOG.isDebugEnabled()) {
            Enumeration headerEnum = request.getHeaderNames();
            while (headerEnum.hasMoreElements()) {
                String headerName = (String)headerEnum.nextElement();
                LOG.debug("Header {}  Value {} ", (Object)headerName, (Object)request.getHeader(headerName));
            }
        }
        String ltiMessageHint = request.getParameter("lti_message_hint");
        OidcLaunchCacheDataDTO cacheData = this.lti13OidcHelper.getValueFromCache(ltiMessageHint);
        try {
            if (OidcLaunchTypeEnum.LTI_LAUNCH.equals((Object)cacheData.getLauchType())) {
                LaunchInfo launchInfo = LaunchService.getLaunchInfo((String)cacheData.getUserId(), (boolean)cacheData.isTeacher(), (Task)cacheData.getTask(), (Tool)cacheData.getTool(), (Course)cacheData.getCourse(), (HttpServletRequest)request);
                ResponseEntity responseEntity = this.ltiLaunchService.createLtiLaunchRequest(launchInfo, request);
                return responseEntity;
            }
            if (OidcLaunchTypeEnum.LTI_DEEP_LINK_LAUNCH.equals((Object)cacheData.getLauchType())) {
                Locale locale = Locale.GERMAN;
                ResponseEntity responseEntity = ResponseEntity.ok((Object)this.launchDeepLinkService.launchDeeplinking(cacheData.getTool(), cacheData.getTeacher(), cacheData.getCourse(), request, response, locale, false));
                return responseEntity;
            }
            LOG.error("Wrong Launch Type {} ", (Object)cacheData.getLauchType());
            ResponseEntity locale = ResponseEntity.badRequest().build();
            return locale;
        }
        catch (Exception e) {
            LOG.error("Exception while create LTI Launch Request ", (Throwable)e);
            ResponseEntity responseEntity = ResponseEntity.badRequest().body((Object)("Exception while create Launch request " + e.getMessage()));
            return responseEntity;
        }
        finally {
            this.cacheManager.getCache("ltiLauchCache").evict((Object)ltiMessageHint);
            if (LOG.isDebugEnabled()) {
                LOG.debug("deleted cache Entry for OIDC Session {}", (Object)ltiMessageHint);
            }
        }
    }
}

