/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.controller;

import de.mahlsdorf.lti13.advantage.service.ags.Lti13ScoreService;
import de.mahlsdorf.lti13.exception.exception.ApiLti13Exception;
import de.mahlsdorf.lti13.lti13models.model.lti.grades.Lti13Score;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(path={"/platformapi/v1/lti13/lineitem/"})
public class ScoreController {
    private static final Logger LOG = LoggerFactory.getLogger(ScoreController.class);
    public static final String SCORE = "scores";
    public static final String RESULT = "result";
    private static final Logger logger = LoggerFactory.getLogger(ScoreController.class);
    private Lti13ScoreService scoreService;

    @PostMapping(value={"{toolId}/{courseId}/{taskId}/scores"})
    public ResponseEntity<String> getScoreFromPlatform(HttpServletRequest request, @RequestBody Lti13Score ltiScore, @PathVariable String toolId, @PathVariable String courseId, @PathVariable String taskId) {
        try {
            logger.info("got Score {} for tool '{}' and Course '{}' and Task '{}' ", new Object[]{ltiScore, toolId, courseId, taskId});
            this.scoreService.storeScore(ltiScore, courseId, taskId, request);
            logger.info("Score successful stored {} ", (Object)ltiScore);
        }
        catch (ApiLti13Exception e) {
            logger.error("Exception while storing Score ", (Throwable)e);
            return ResponseEntity.status((int)e.getHttpStatus().value()).body((Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error("Exception {} HttpStatus {}", new Object[]{e.getMessage(), 500, e});
            return ResponseEntity.status((int)500).body((Object)e.getMessage());
        }
        ResponseEntity result = ResponseEntity.status((int)HttpStatus.NO_CONTENT.value()).contentLength(0L).body((Object)"");
        LOG.info("########################## result of score is {}", (Object)result);
        return result;
    }

    @Autowired
    public void setScoreService(Lti13ScoreService scoreService) {
        this.scoreService = scoreService;
    }
}

