/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.mahlsdorf.groupservice.model.node.Tool;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.lti13.advantage.service.MyJwtEncoder;
import de.mahlsdorf.lti13.advantage.service.jwks.JwksService;
import de.mahlsdorf.lti13.exception.exception.ApiLti13Exception;
import de.mahlsdorf.lti13.lti13models.model.Lti13JwtModel;
import io.fusionauth.jwt.JWTException;
import io.fusionauth.jwt.JWTUtils;
import io.fusionauth.jwt.Signer;
import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.JWT;
import io.fusionauth.jwt.rsa.RSASigner;
import io.fusionauth.jwt.rsa.RSAVerifier;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class JwtEncoderDecoder
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(JwtEncoderDecoder.class);
    private JwksService jwksService;
    private Neo4JBaseService neo4JBaseService;

    public JwtEncoderDecoder(@Autowired JwksService jwksService, @Autowired Neo4JBaseService neo4JBaseService) {
        this.jwksService = jwksService;
        this.neo4JBaseService = neo4JBaseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lti13JwtModel decodeLTILauchLink(String jwtToken, String platformId) throws ApiLti13Exception {
        Lti13JwtModel model = new Lti13JwtModel();
        Tool tool = (Tool)this.neo4JBaseService.getToolsById(platformId).get(0);
        int count = 0;
        JWT jwt = null;
        String kid = JWTUtils.decodeHeader((String)jwtToken).get("kid");
        while (count < 2) {
            try {
                String key = this.jwksService.getPemFilePublicKey(tool, count != 0, kid);
                logger.debug("PlatformId:{} Key {} ", (Object)platformId, (Object)key);
                RSAVerifier verifier = RSAVerifier.newVerifier((String)key);
                jwt = JWT.getDecoder().decode(jwtToken, new Verifier[]{verifier});
                break;
            }
            catch (JWTException je) {
                if (count != 1) continue;
                throw new ApiLti13Exception("JWT cant be decoded for platformId " + platformId, "jwtDecoderError", HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (ApiLti13Exception e) {
                throw e;
            }
            catch (Exception e) {
                if (count != 1) continue;
                logger.error("cant decode jwt, reread jwks did not help ", (Throwable)e);
                throw new ApiLti13Exception(e.getMessage() + " platformId " + platformId, "jwtDecoderError", HttpStatus.INTERNAL_SERVER_ERROR);
            }
            finally {
                ++count;
            }
        }
        TreeMap claims = new TreeMap(jwt.getAllClaims());
        model.setClaims(claims);
        return model;
    }

    public String createAndEncodeJWTForLaunchRequest(@NotNull Object ltiLaunchRequestObject, @NotNull StringBuilder sb1, @NotNull String toolId) throws Exception {
        Tool tool = (Tool)this.neo4JBaseService.getToolsById(toolId).get(0);
        RSASigner signer = RSASigner.newSHA256Signer((String)tool.getPrivateKeyAsPem());
        return this.getJWT(ltiLaunchRequestObject, sb1, (Signer)signer, tool.getKeyId());
    }

    private String getJWT(@NotNull Object objectToEncode, @NotNull StringBuilder sb1, Signer signer, String keyId) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String asJson = gson.toJson(objectToEncode);
        Map claims = (Map)gson.fromJson(asJson, Map.class);
        sb1.append(asJson);
        return MyJwtEncoder.getInstance().encodeObject((Object)claims, signer, null, keyId);
    }
}

