/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.service;

import io.fusionauth.jwt.JWTEncoder;
import io.fusionauth.jwt.Signer;
import io.fusionauth.jwt.domain.Header;
import io.fusionauth.jwt.domain.JWT;
import io.fusionauth.jwt.json.Mapper;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class MyJwtEncoder
extends JWTEncoder {
    private static MyJwtEncoder instance;

    private MyJwtEncoder() {
    }

    public static MyJwtEncoder getInstance() {
        if (instance == null) {
            instance = new MyJwtEncoder();
        }
        return instance;
    }

    public String encode(JWT jwt, Signer signer) {
        return this.encode(jwt, signer, null);
    }

    public String encodeObject(Object jwt, Signer signer, Consumer<Header> consumer) {
        return this.encodeObject(jwt, signer, consumer, null);
    }

    public String encodeObject(Object jwt, Signer signer, Consumer<Header> consumer, String keyId) {
        Objects.requireNonNull(jwt);
        Objects.requireNonNull(signer);
        ArrayList<String> parts = new ArrayList<String>(3);
        Header header = new Header();
        if (!StringUtils.isEmpty((Object)keyId)) {
            header.set("kid", keyId);
        }
        if (consumer != null) {
            consumer.accept(header);
        }
        header.algorithm = signer.getAlgorithm();
        parts.add(this.base64EncodeString(Mapper.serialize((Object)header)));
        parts.add(this.base64EncodeString(Mapper.serialize((Object)jwt)));
        byte[] signature = signer.sign(this.myJoin(parts));
        parts.add(this.base64EncodeString(signature));
        return this.myJoin(parts);
    }

    private String base64EncodeString(byte[] bytes) {
        return new String(Base64.getUrlEncoder().withoutPadding().encode(bytes));
    }

    private String myJoin(Collection<String> collection) {
        return collection.stream().collect(Collectors.joining("."));
    }
}

