/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.service;

import de.mahlsdorf.lti13.exception.exception.ApiLti13Exception;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class NamedParameterReplacementService {
    private static final Logger logger = LoggerFactory.getLogger(NamedParameterReplacementService.class);
    Pattern NAMED_PARAMETER_PATTERN = Pattern.compile("(.*?)\\$\\{(.*?)\\}(.*)");

    public static void main(String[] args) {
        logger.info("start");
        String stringToParse = "dasistmein/${name}/${user}/ddddd/${name}/${xyz}wasauchimmer${name}";
        NamedParameterReplacementService test = new NamedParameterReplacementService();
        logger.debug("gefundene Parameter {} ", (Object)test.getParameterNames(stringToParse));
        HashMap<String, String> replacementValues = new HashMap<String, String>();
        replacementValues.put("name", "AlexanderBecker");
        replacementValues.put("user", "1");
        try {
            String result = test.replaceNamedParameter(replacementValues, stringToParse);
            logger.debug("ausgang  {}", (Object)stringToParse);
            logger.debug("ergebnis {}", (Object)result);
        }
        catch (Exception e) {
            logger.error("Exception during replacement ", (Throwable)e);
        }
    }

    public Set<String> getParameterNames(String stringToParse) {
        HashSet<String> result = new HashSet<String>();
        Matcher m = this.NAMED_PARAMETER_PATTERN.matcher(stringToParse);
        int start = 0;
        while (true) {
            int length = stringToParse.length();
            if (!m.find(start)) break;
            String parameter = m.group(2);
            logger.info("found parameter {} ", (Object)parameter);
            start = m.start(2) + 1;
            if (start > length) break;
            result.add(parameter);
        }
        return result;
    }

    public String replaceNamedParameter(Map<String, String> replacementValues, String stringToParse) throws ApiLti13Exception {
        int length;
        Matcher m;
        String result = stringToParse;
        int start = 0;
        do {
            logger.debug("result {}", (Object)result);
            m = this.NAMED_PARAMETER_PATTERN.matcher(result);
            length = stringToParse.length();
            if (!m.find(start)) break;
            String parameter = m.group(2);
            logger.debug("found parameter {} ", (Object)parameter);
            String startString = result.substring(0, m.start(2) - 2);
            String replacement = replacementValues.get(parameter);
            if (StringUtils.isEmpty((CharSequence)replacement)) {
                String message = String.format("no replacment value found for parameter %s. leaving parameter untouched String before replacements %s", parameter, stringToParse);
                logger.error(message);
                throw new ApiLti13Exception(message, "nameReplacementError", HttpStatus.INTERNAL_SERVER_ERROR);
            }
            result = startString.concat(replacement).concat(m.group(3));
        } while ((start = m.start(2) + 1) < length);
        return result;
    }
}

