/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.service.ags;

import com.google.gson.Gson;
import de.mahlsdorf.groupservice.model.CreateDeleteCounter;
import de.mahlsdorf.groupservice.model.node.Student;
import de.mahlsdorf.groupservice.model.node.Task;
import de.mahlsdorf.groupservice.model.node.TaskResult;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.neo4j.Neo4JStudentToTaskService;
import de.mahlsdorf.lti13.exception.exception.ApiLti13Exception;
import de.mahlsdorf.lti13.lti13models.model.lti.grades.Lti13LineItem;
import de.mahlsdorf.lti13.lti13models.model.lti.grades.Lti13LineItemResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class Lti13LineItemsService {
    private static final Logger logger = LoggerFactory.getLogger(Lti13LineItemsService.class);
    private Neo4JBaseService neo4JBaseService;
    private Neo4JStudentToTaskService neo4JStudentToTaskService;
    private String baseUrl;

    public ResponseEntity<List<Lti13LineItem>> getLineItemsForToolAndCourse(String courseId, String toolId) throws ApiLti13Exception {
        long startTime = System.currentTimeMillis();
        ArrayList<Lti13LineItem> result = new ArrayList<Lti13LineItem>();
        List taskList = this.neo4JBaseService.getTasksForCourse(courseId);
        for (Task task : taskList) {
            if (!task.getToolId().equals(toolId)) continue;
            Lti13LineItem lineItem = new Lti13LineItem();
            lineItem.setId(this.createLineItemUrl(task.getTaskId(), courseId, toolId));
            lineItem.setLabel(task.getName());
            lineItem.setLtiLinkId(task.getLtiLtiLinkId());
            lineItem.setResourceId(task.getLtiLiResourceId());
            lineItem.setScoreMaximum(Float.valueOf(Float.parseFloat("" + task.getLtiLineItemMaxPoints())));
            lineItem.setTag(task.getLtiLiLineItemTag());
            result.add(lineItem);
        }
        if (logger.isDebugEnabled()) {
            int count = 0;
            for (Lti13LineItem lineItem : result) {
                logger.debug("returning LineItem count {} lineItem {}", (Object)count, (Object)lineItem);
                ++count;
            }
        }
        logger.info("return {} LineItems for Course {} toolId {} in {} msec ", new Object[]{result.size(), courseId, toolId, System.currentTimeMillis() - startTime});
        return ResponseEntity.ok(result);
    }

    public ResponseEntity<String> createALineItemsForToolAndCourse(String courseId, String toolId, String lineItemToCreateString) throws ApiLti13Exception {
        long startTime = System.currentTimeMillis();
        Gson gson = new Gson();
        Lti13LineItem ltiLineItemToCreate = null;
        try {
            ltiLineItemToCreate = (Lti13LineItem)gson.fromJson(lineItemToCreateString, Lti13LineItem.class);
        }
        catch (Exception e) {
            logger.error("Exception while getting LineItem ", (Throwable)e);
            throw new ApiLti13Exception("LineItem Json is incoreect" + e.getMessage(), "ERROR", HttpStatus.BAD_REQUEST);
        }
        logger.info("This is the LineItem to create \n{}", (Object)ltiLineItemToCreate);
        String taskId = UUID.randomUUID().toString();
        Task task = new Task();
        task.setTaskId(taskId);
        task.setType("LineItem");
        task.setToolId(toolId);
        task.setLtiResourceLinkId(ltiLineItemToCreate.getResourceLinkId());
        task.setLtiLiResourceId(ltiLineItemToCreate.getResourceId());
        task.setLtiLtiLinkId(ltiLineItemToCreate.getLtiLinkId());
        task.setLtiLiLineItemTag(ltiLineItemToCreate.getTag());
        task.setLtiLineItemMaxPoints(Double.valueOf(Double.parseDouble("" + ltiLineItemToCreate.getScoreMaximum())));
        task.setName(ltiLineItemToCreate.getLabel());
        try {
            this.neo4JBaseService.createTaskAndRelation(task, courseId);
            String lineItemUrl = this.createLineItemUrl(taskId, courseId, toolId);
            ltiLineItemToCreate.setId(lineItemUrl);
            logger.info("LtiLineItem {} from Tool {} for Course {} created", new Object[]{lineItemUrl, toolId, courseId});
            List studentsForCourseList = this.neo4JBaseService.getStudentForCourseViaLearningGroup(courseId);
            logger.debug("Found {} students for course ", (Object)studentsForCourseList.size());
            if (logger.isDebugEnabled()) {
                int count = 0;
                for (Student student : studentsForCourseList) {
                    logger.info("Student count {} Student {} ", (Object)count, (Object)student);
                    ++count;
                }
            }
            HashSet studentsFromGrid = new HashSet(studentsForCourseList);
            CreateDeleteCounter counter = this.neo4JStudentToTaskService.updateTaskToStudentConnections(task, studentsFromGrid, new CreateDeleteCounter());
            logger.info("assigned {} to LineItem {} ", (Object)counter.getCreated(), (Object)ltiLineItemToCreate);
        }
        catch (Exception e) {
            logger.error("Exception while creating Task for LineItem to Create {} ", (Object)lineItemToCreateString, (Object)e);
            this.neo4JBaseService.deleteTasks(taskId);
            throw new ApiLti13Exception(e.getMessage(), "ERROR", HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return ResponseEntity.ok((Object)lineItemToCreateString);
    }

    public ResponseEntity<List<Lti13LineItemResult>> getLineItemsResults(String toolId, String courseId, String taskId) throws ApiLti13Exception {
        try {
            ArrayList<Lti13LineItemResult> resultList = new ArrayList<Lti13LineItemResult>();
            List taskResultList = this.neo4JBaseService.getTaskResultsForTaskInCourseForAllStudents(courseId, taskId);
            for (TaskResult taskResult : taskResultList) {
                Lti13LineItemResult lineItemResult = new Lti13LineItemResult();
                lineItemResult.setId(this.createLineItemUrl(taskId, courseId, toolId) + taskResult.getUserId());
                lineItemResult.setResultMaximum("Maus Have Max" + taskResult.getScoreGiven());
                lineItemResult.setResultScore("" + taskResult.getScoreGiven());
                lineItemResult.setComment(taskResult.getComment());
                lineItemResult.setScoreOf(this.createLineItemUrl(taskId, courseId, toolId));
                lineItemResult.setUserId(taskResult.getUserId());
                lineItemResult.setTimestamp(taskResult.getCreated());
                resultList.add(lineItemResult);
            }
            return ResponseEntity.ok(resultList);
        }
        catch (Exception e) {
            logger.error("Exception while getting LineItems for taskId {}", (Object)taskId, (Object)e);
            throw new ApiLti13Exception(e.getMessage(), "ERROR", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public String createLineItemUrl(String taskId, String courseId, String toolId) {
        return this.baseUrl + "platformapi/v1/lti13/lineitem/" + toolId + "/" + courseId + "/" + taskId;
    }

    public String createLineItemsUrl(String toolId, String courseId) {
        return this.baseUrl + "platformapi/v1/lti13/lineitems/" + toolId + "/" + courseId;
    }

    @Autowired
    public void setNeo4JBaseService(Neo4JBaseService neo4JBaseService) {
        this.neo4JBaseService = neo4JBaseService;
    }

    @Autowired
    public void setNeo4JStudentToTaskService(Neo4JStudentToTaskService neo4JStudentToTaskService) {
        this.neo4JStudentToTaskService = neo4JStudentToTaskService;
    }

    @Value(value="${platform.hosturi}")
    public void setPlatformHostUri(String baseUrl) {
        this.baseUrl = baseUrl;
    }
}

