/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.service.ags;

import de.mahlsdorf.groupservice.model.node.Task;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.lti13.advantage.service.token.TokenService;
import de.mahlsdorf.lti13.exception.exception.ApiLti13Exception;
import de.mahlsdorf.lti13.lti13models.model.lti.grades.Lti13Score;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class Lti13ScoreService {
    private static final Logger logger = LoggerFactory.getLogger(Lti13ScoreService.class);
    public static final String ERROR_CODE = "ERROR";
    private final Map<String, String> scoreMap = new HashMap();
    private TokenService tokenService;
    private Neo4JBaseService neo4JBaseService;

    public void storeScore(Lti13Score ltiScore, String courseId, String taskId, HttpServletRequest request) throws ApiLti13Exception {
        String userId;
        String token = request.getHeader("Authorization");
        token = token.replaceAll("Bearer ", "");
        logger.info("realToken is '{}'", (Object)token);
        if (!this.tokenService.isTokenValid(token)) {
            throw new ApiLti13Exception("Not authorized ", ERROR_CODE, HttpStatus.UNAUTHORIZED);
        }
        try {
            userId = ltiScore.getUserId();
        }
        catch (Exception e2) {
            logger.error("Exception while parse UserId ", (Throwable)e2);
            throw new ApiLti13Exception("Wrong UserId ", ERROR_CODE, HttpStatus.BAD_REQUEST);
        }
        logger.error("###### TODO replace this with checking result in createTaskResult Method");
        List taskForStudent = this.neo4JBaseService.getTasksPerStudentAndCourse(ltiScore.getUserId(), courseId);
        List foundTasks = taskForStudent.stream().filter(e -> taskId.equals(e.getTaskId())).collect(Collectors.toList());
        if (foundTasks.isEmpty()) {
            logger.error("User {} has no task {} ", (Object)ltiScore.getUserId(), (Object)taskId);
            throw new ApiLti13Exception("Wrong task and userId combination ", ERROR_CODE, HttpStatus.BAD_REQUEST);
        }
        Task task = this.neo4JBaseService.getTaskById(taskId);
        this.neo4JBaseService.createTaskResult(task, userId, ltiScore);
        logger.info("TaskId {} UserId {} LtiScore {} written", new Object[]{taskId, userId, ltiScore});
    }

    @Autowired
    public void setTokenService(TokenService tokenService) {
        this.tokenService = tokenService;
    }

    @Autowired
    public void setNeo4JBaseService(Neo4JBaseService neo4JBaseService) {
        this.neo4JBaseService = neo4JBaseService;
    }
}

