/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.service.jwks;

import com.google.gson.Gson;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import de.mahlsdorf.groupservice.model.node.Tool;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.lti13.advantage.internalmodel.JwksCacheKey;
import de.mahlsdorf.lti13.advantage.service.RestTemplateFactory;
import de.mahlsdorf.lti13.advantage.service.jwks.RSAUtils;
import de.mahlsdorf.lti13.exception.exception.ApiLti13Exception;
import de.mahlsdorf.lti13.lti13models.model.jwks.Lti13JwksModel;
import java.io.Serializable;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.jwt.util.JWKHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@EnableCaching
@Service
public class JwksService
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(JwksService.class);
    private static final String MSG_KEY = "JwksService.";
    public static final String KEY_TYPE_RSA = "RSA";
    private I18nService i18nService;
    private Neo4JBaseService neo4jService;
    private Locale locale;
    private final Map<JwksCacheKey, String> pubKeyMap = new HashMap();
    private RestTemplateFactory restTemplateFactory;

    public JwksService(@Autowired Neo4JBaseService neo4JBaseService, @Autowired RestTemplateFactory restTemplateFactory) {
        this.neo4jService = neo4JBaseService;
        this.i18nService = I18nService.getInstance();
        this.locale = Locale.ENGLISH;
        this.restTemplateFactory = restTemplateFactory;
    }

    public String getPemFilePublicKey(Tool tool, boolean forceReread, String kid) throws ApiLti13Exception {
        String myKid = kid;
        if (kid == null) {
            myKid = "";
        }
        String toolId = tool.getToolId();
        JwksCacheKey cacheKey = new JwksCacheKey(tool.getToolId(), myKid);
        String pemFile = (String)this.pubKeyMap.get(cacheKey);
        logger.debug("pemfile identifier {} pemfile is {}", (Object)cacheKey, (Object)pemFile);
        if (forceReread || StringUtils.isEmpty((CharSequence)pemFile)) {
            String keySetUrl = tool.getToolJwksUrl();
            if (!StringUtils.isEmpty((CharSequence)keySetUrl)) {
                logger.info("getting Public Key for platformId {} from jwks URL {}", (Object)toolId, (Object)keySetUrl);
                logger.debug("found for Platform {} the KeysetURL {}", (Object)toolId, (Object)keySetUrl);
                pemFile = this.getJwksStringFromKeySetUrl(toolId, kid, keySetUrl);
                logger.debug("PlatformId {} PEM File is {}", (Object)toolId, (Object)pemFile);
            } else {
                logger.warn("found for tool no keyset url and now we try to use definition of public key from tool definition for tool {} ", (Object)toolId);
                logger.debug("alternative PemFile from definition is \n{}", (Object)pemFile);
            }
            this.pubKeyMap.put(cacheKey, pemFile);
        } else {
            logger.info("took cachedFile for PEM file for platform {} \n", (Object)toolId);
        }
        return pemFile;
    }

    public String getJwksStringFromKeySetUrl(String toolId, String kid, String keySetUrl) throws ApiLti13Exception {
        String jwksString = "";
        Gson gson = new Gson();
        try {
            RestTemplate restTemplate = this.restTemplateFactory.getRestTemplate();
            logger.info("try to get jwks for toolId {} Kid {} from URL {}", new Object[]{toolId, kid, keySetUrl});
            ResponseEntity response = restTemplate.getForEntity(keySetUrl, Lti13JwksModel.class, new Object[0]);
            logger.debug("Response from JWKS :\n{}", response.getBody());
            if (response.getBody() == null) {
                String message = "response body from jwks call was empty ";
                logger.error(message);
                throw new ApiLti13Exception(message, "jwksIoException", HttpStatus.BAD_REQUEST);
            }
            jwksString = JwksService.getJwksString((String)kid, (String)jwksString, (Gson)gson, (ResponseEntity)response);
            this.checkJwksString(kid, jwksString);
            logger.info("Json String :{} ", (Object)jwksString);
            String pemFile = this.convertJwksPublicKeyToPemFile(jwksString, toolId);
            logger.debug("converted PEM File is \n{}", (Object)pemFile);
            return pemFile;
        }
        catch (Exception e) {
            logger.error("Exception while getting JWKS from URL platformId {} KeyId {} keysetUrl {}", new Object[]{toolId, kid, keySetUrl, e});
            String message = this.i18nService.getTranslation("JwksService.msg.jwksIoException", this.locale, new Object[]{toolId, kid, keySetUrl, e.getMessage()});
            throw new ApiLti13Exception(message, "jwksIoException", HttpStatus.BAD_REQUEST);
        }
    }

    private void checkJwksString(String kid, String jwksString) throws ApiLti13Exception {
        if (StringUtils.isEmpty((CharSequence)jwksString)) {
            String message = this.i18nService.getTranslation("JwksService.msg.noJwks", this.locale, new Object[]{kid});
            logger.error(message);
            throw new ApiLti13Exception(message, "noJwks", HttpStatus.BAD_REQUEST);
        }
    }

    private static String getJwksString(String kid, String jwksString, Gson gson, ResponseEntity<Lti13JwksModel> response) {
        if (StringUtils.isEmpty((CharSequence)kid)) {
            jwksString = gson.toJson(((Lti13JwksModel)response.getBody()).getKeys().get(0));
            logger.info("no kid given take first key jwks='{}'", (Object)jwksString);
        } else {
            for (Map jwksMap : ((Lti13JwksModel)response.getBody()).getKeys()) {
                if (!kid.equals(jwksMap.get("kid"))) continue;
                jwksString = gson.toJson((Object)jwksMap);
                if (!logger.isDebugEnabled()) break;
                logger.debug("got the jwks for kid '{}' is '{}", (Object)kid, (Object)jwksString);
                break;
            }
        }
        return jwksString;
    }

    private String convertJwksPublicKeyToPemFile(String jwksString, String plattformId) {
        Gson gson = new Gson();
        KeyPair myKeyPair = null;
        boolean hasError = false;
        try {
            myKeyPair = JWKHelper.buildRSAKeyPairFromJwk((String)jwksString);
        }
        catch (Exception e) {
            logger.error("Exception while converting jwk to pem ", (Throwable)e);
            hasError = true;
        }
        if (hasError) {
            Map jwkMap = (Map)gson.fromJson(jwksString, Map.class);
            String modifiedString = "";
            logger.info("jwk with x5c x5t is \n{}", (Object)jwksString);
            try {
                modifiedString = gson.toJson((Object)jwkMap);
                logger.info("modefied String :\n{}", (Object)modifiedString);
                myKeyPair = JWKHelper.buildRSAKeyPairFromJwk((String)modifiedString);
                if (logger.isDebugEnabled()) {
                    logger.debug("keypair public key as pem \n{} ", (Object)RSAUtils.getPEMFromPublicKey((PublicKey)myKeyPair.getPublic()));
                }
                hasError = false;
            }
            catch (Exception e) {
                logger.error("Exception while decode modified String ", (Throwable)e);
                hasError = true;
            }
        }
        String modifiedString = "";
        if (hasError) {
            try {
                Map jwkMap = (Map)gson.fromJson(jwksString, Map.class);
                logger.info("remove x5c and x5t from JWK and try again to get the public key ");
                jwkMap.remove("x5c");
                jwkMap.remove("x5t");
                modifiedString = gson.toJson((Object)jwkMap);
                logger.info("modified String after removing x5c and x5t :\n{}", (Object)modifiedString);
                myKeyPair = JWKHelper.buildRSAKeyPairFromJwk((String)modifiedString);
            }
            catch (Exception e) {
                logger.error("Exception while decode JWK after removing x5c and x5t jwk {} ", (Object)modifiedString, (Object)e);
                throw e;
            }
        }
        logger.debug("platformId {}  Key Algorithm {}", (Object)plattformId, (Object)myKeyPair.getPublic().getAlgorithm());
        return RSAUtils.getPEMFromPublicKey((PublicKey)myKeyPair.getPublic());
    }

    private String generateJWKSFromPrivateKeyWithPem(String privateKeyAsPem, String platformId, String type, String keyId) {
        Gson gson = new Gson();
        try {
            if (privateKeyAsPem == null) {
                logger.warn("{} :'{}' pemfile for private key is null  retuning null", (Object)type, (Object)platformId);
                return null;
            }
            RSAPrivateKey rsaprivateKey = (RSAPrivateKey)RSAUtils.getPrivateKeyFromPEM((String)privateKeyAsPem);
            logger.info("{} {} {} RSAPrivate Key Alg: {} private Exponent {}", new Object[]{type, platformId, rsaprivateKey.getClass(), rsaprivateKey.getAlgorithm(), rsaprivateKey.getPrivateExponent()});
            RSAPrivateCrtKey privk = (RSAPrivateCrtKey)rsaprivateKey;
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(privk.getModulus(), privk.getPublicExponent());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            RSAKey key = new RSAKey.Builder(rsaPublicKey).keyUse(KeyUse.SIGNATURE).keyID(keyId).build();
            JWKSet jwkSet = new JWKSet((JWK)key);
            String jwks = gson.toJson((Object)jwkSet.toJSONObject());
            logger.info("jwks calculated is JWKS:'{}'", (Object)jwks);
            return jwks;
        }
        catch (Exception e) {
            logger.error("Exception during JWKS generation ", (Throwable)e);
            return null;
        }
    }

    public void evictJwksForPlatform(String platformId) {
        logger.info("evict JWKS for Platform {} ", (Object)platformId);
    }

    public String generateMyJwksAsPlatformFromPrivateKeyForTool(String toolId) {
        try {
            logger.info("generate jwks for platformid '{}' ", (Object)toolId);
            List toolList = this.neo4jService.getToolsById(toolId);
            if (toolList.isEmpty()) {
                logger.info("nothing found for tool with id {} ", (Object)toolId);
                return null;
            }
            Tool tool = (Tool)toolList.get(0);
            if (logger.isDebugEnabled()) {
                logger.debug("platformId {} platformDefiniton  is {}", (Object)tool.getToolId(), (Object)tool);
                logger.debug("myPrivateKey {}", (Object)tool.getPrivateKeyAsPem());
            }
            String jwks = this.generateJWKSFromPrivateKeyWithPem(tool.getPrivateKeyAsPem(), toolId, "platform", tool.getKeyId());
            if (logger.isDebugEnabled()) {
                logger.debug("platformid '{}' generated jwks is {}", (Object)toolId, (Object)jwks);
            }
            return jwks;
        }
        catch (Exception e) {
            logger.error("Exception during JWKS generation for platform '{}' returning null", (Object)toolId, (Object)e);
            return null;
        }
    }
}

