/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.service.ltirequest;

import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.lti13.LtiDeeplinkRequest;
import de.mahlsdorf.groupservice.utils.JavaTimeUtils;
import de.mahlsdorf.lti13.advantage.helper.HtmlTagWriter;
import de.mahlsdorf.lti13.advantage.internalmodel.launch.LaunchInfo;
import de.mahlsdorf.lti13.advantage.service.JwtEncoderDecoder;
import de.mahlsdorf.lti13.advantage.service.ags.Lti13LineItemsService;
import de.mahlsdorf.lti13.advantage.service.ltirequest.CustomParameterService;
import de.mahlsdorf.lti13.exception.exception.ApiLti13Exception;
import de.mahlsdorf.lti13.lti13models.model.lti.deeplink.claims.Lti13ClaimDeepLinkingSettings;
import de.mahlsdorf.lti13.lti13models.model.lti.launchrequest.LtiLaunchRequest;
import de.mahlsdorf.lti13.lti13models.model.lti.launchrequest.claims.Lti13ClaimContext;
import de.mahlsdorf.lti13.lti13models.model.lti.launchrequest.claims.Lti13ClaimLaunchPresentation;
import de.mahlsdorf.lti13.lti13models.model.lti.launchrequest.claims.Lti13ClaimLineItemEndpoint;
import de.mahlsdorf.lti13.lti13models.model.lti.launchrequest.claims.Lti13ClaimNamesAndRoles;
import de.mahlsdorf.lti13.lti13models.model.lti.launchrequest.claims.Lti13ClaimResourceLink;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class LtiLaunchService
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(LtiLaunchService.class);
    public static final String LTI_LAUNCH_LABEL = "LTI Launch";
    private String baseUrl;
    private JwtEncoderDecoder jwtEncoderDecoder;
    private boolean deeplinkingAcceptMutiple;
    private transient Lti13LineItemsService lineItemsService;
    private transient CustomParameterService customParameterService;

    private LtiLaunchRequest createLtiLaunchRequestDTO(LaunchInfo launchInfo) {
        LtiLaunchRequest ltiLaunchRequest = new LtiLaunchRequest();
        ltiLaunchRequest.setIss(this.baseUrl);
        Long epochInUtc = JavaTimeUtils.getEpochInSecondsInUtc();
        ltiLaunchRequest.setIat(epochInUtc);
        ltiLaunchRequest.setExp(Long.valueOf(epochInUtc + 300L));
        ltiLaunchRequest.setNonce(launchInfo.getNonce());
        ltiLaunchRequest.setAud(launchInfo.getAud());
        ltiLaunchRequest.setLtiClaimTargetLinkUri(launchInfo.getLaunchUri());
        Lti13ClaimLineItemEndpoint claimEndpoint = new Lti13ClaimLineItemEndpoint();
        ltiLaunchRequest.setDeploymentId(launchInfo.getTool().getDeploymentId());
        ltiLaunchRequest.setLtiClaimRoles(Collections.singletonList("http://purl.imsglobal.org/vocab/lis/v2/membership#Learner"));
        if (launchInfo.isTeacher()) {
            ltiLaunchRequest.setLtiClaimRoles(Collections.singletonList("http://purl.imsglobal.org/vocab/lis/v2/institution/person#Instructor"));
        } else {
            String lineItemUrl = this.lineItemsService.createLineItemUrl(launchInfo.getTask().getTaskId(), launchInfo.getCourseInfo().getId(), launchInfo.getTool().getToolId());
            logger.info("LTI Launch lineItemUrl:{}", (Object)lineItemUrl);
            claimEndpoint.setLineItemUrl(lineItemUrl);
        }
        String lineItemsUrl = this.lineItemsService.createLineItemsUrl(launchInfo.getTool().getToolId(), launchInfo.getCourseInfo().getId());
        logger.info("LTI Launch LineItemsUrl:{}", (Object)lineItemsUrl);
        claimEndpoint.setLineItemsUrl(lineItemsUrl);
        ltiLaunchRequest.setLtiClaimEndpoint(claimEndpoint);
        Lti13ClaimNamesAndRoles ltiClaimNamesAndRoles = new Lti13ClaimNamesAndRoles();
        String namesAmdRolesUrl = this.baseUrl + "platformapi/v1/lti13/namesandroles/" + launchInfo.getTool().getToolId() + "/" + launchInfo.getCourseInfo().getId() + "/";
        logger.info("LTI Launch NamesAndRolesUrl:{}", (Object)namesAmdRolesUrl);
        ltiClaimNamesAndRoles.setContentMenbershipUrl(namesAmdRolesUrl);
        ltiClaimNamesAndRoles.setServiceVersions(Collections.singletonList("2.0"));
        ltiLaunchRequest.setLtiClaimNamesAndRoles(ltiClaimNamesAndRoles);
        Lti13ClaimLaunchPresentation ltiClaimLaunchPresentation = new Lti13ClaimLaunchPresentation();
        ltiLaunchRequest.setSub(launchInfo.getUserId());
        ltiClaimLaunchPresentation.setReturnUrl(this.baseUrl + "platformapi/v1/lti13/return/");
        ltiLaunchRequest.setLtiClaimLaunchPresentation(ltiClaimLaunchPresentation);
        ltiLaunchRequest.setLtiClaimExt(new HashMap());
        Map customMap = new HashMap();
        String customParameterString = launchInfo.getTask().getLtiCustomParams();
        if (!StringUtils.isEmpty((CharSequence)customParameterString)) {
            try {
                customMap = this.customParameterService.convertToMapFormString(customParameterString);
            }
            catch (Exception e) {
                logger.error("Exception while converting customParameterMap from String '{}'", (Object)customParameterString, (Object)e);
                customMap = new HashMap();
            }
        }
        ltiLaunchRequest.setLtiClaimCustom(customMap);
        ltiLaunchRequest.setLtiClaimVersion("1.3.0");
        ltiLaunchRequest.setLtiClaimMessageType("LtiResourceLinkRequest");
        Lti13ClaimResourceLink claimResourceLink = new Lti13ClaimResourceLink();
        claimResourceLink.setId("1");
        claimResourceLink.setTitle("what ever ");
        ltiLaunchRequest.setLtiClaimResourceLink(claimResourceLink);
        Lti13ClaimContext context = new Lti13ClaimContext();
        context.setId(launchInfo.getCourseInfo().getId());
        context.setTitle(launchInfo.getCourseInfo().getLongName());
        ltiLaunchRequest.setLtiClaimContext(context);
        return ltiLaunchRequest;
    }

    private LtiDeeplinkRequest createLtiDeepLinkingLaunchRequestDTO(LaunchInfo launchInfo, Locale locale) {
        LtiDeeplinkRequest ltiDeeplinkingRequest = new LtiDeeplinkRequest();
        logger.error("################### Locale Setting in LTI Deeplink Launch ");
        ltiDeeplinkingRequest.setIss(this.baseUrl);
        ltiDeeplinkingRequest.setLocale(locale.toLanguageTag());
        Long iat = JavaTimeUtils.getEpochInSecondsInUtc();
        ltiDeeplinkingRequest.setIat(iat);
        ltiDeeplinkingRequest.setExp(Long.valueOf(iat + 300L));
        ltiDeeplinkingRequest.setNonce(launchInfo.getNonce());
        ltiDeeplinkingRequest.setAud(launchInfo.getAud());
        ltiDeeplinkingRequest.setLtiClaimRoles(Collections.singletonList("http://purl.imsglobal.org/vocab/lis/v2/institution/person#Instructor"));
        ltiDeeplinkingRequest.setDeploymentId(launchInfo.getTool().getDeploymentId());
        ltiDeeplinkingRequest.setSub(launchInfo.getUserId());
        Lti13ClaimLaunchPresentation ltiClaimLaunchPresentation = new Lti13ClaimLaunchPresentation();
        ltiClaimLaunchPresentation.setReturnUrl(this.baseUrl + "platformapi/v1/lti13/deepLinkingResponse/");
        ltiClaimLaunchPresentation.setLocale(Locale.getDefault().toString());
        ltiClaimLaunchPresentation.setDocumentTarget("window");
        ltiDeeplinkingRequest.setLtiClaimLaunchPresentation(ltiClaimLaunchPresentation);
        HashMap customMap = new HashMap();
        ltiDeeplinkingRequest.setLtiClaimCustom(customMap);
        ltiDeeplinkingRequest.setLtiClaimVersion("1.3.0");
        ltiDeeplinkingRequest.setLtiClaimMessageType("LtiDeepLinkingRequest");
        Lti13ClaimDeepLinkingSettings deepLinkingSettings = new Lti13ClaimDeepLinkingSettings();
        deepLinkingSettings.setDeepLinkReturnUrl(launchInfo.getReturnUrl());
        deepLinkingSettings.setAcceptMultiple(this.deeplinkingAcceptMutiple);
        deepLinkingSettings.getAcceptTypes().addAll(ConstantsNeoc.LTI13.TYPE_ACCEPT_LIST);
        deepLinkingSettings.setAcceptPresentationDocumentTargets(ConstantsNeoc.LTI13.TYPE_PRESENTATION_LIST);
        ltiDeeplinkingRequest.setLtiClaimDeepLinkingSettings(deepLinkingSettings);
        ltiDeeplinkingRequest.setTargetLinkUri(launchInfo.getTargetLinkUri());
        ltiDeeplinkingRequest.setLtiClaimLaunchPresentation(ltiClaimLaunchPresentation);
        Lti13ClaimContext context = new Lti13ClaimContext();
        context.setId(launchInfo.getCourseInfo().getId());
        context.setTitle(launchInfo.getCourseInfo().getLongName());
        ltiDeeplinkingRequest.setLtiClaimContext(context);
        return ltiDeeplinkingRequest;
    }

    public ResponseEntity<String> createDeepLinkingLaunchRequest(LaunchInfo launchInfo, Locale locale) throws ApiLti13Exception {
        try {
            LtiDeeplinkRequest ltiLaunchRequest = this.createLtiDeepLinkingLaunchRequestDTO(launchInfo, locale);
            StringBuilder sb = new StringBuilder();
            String toolId = launchInfo.getTool().getToolId();
            String jwt = this.jwtEncoderDecoder.createAndEncodeJWTForLaunchRequest((Object)ltiLaunchRequest, sb, toolId);
            logger.info("DeeplinkingRequest is {}", (Object)ltiLaunchRequest);
            return this.launchLtiRequestViaForm(launchInfo, jwt, launchInfo.getOidcState());
        }
        catch (Exception e) {
            logger.error("Exception while creating LTI Launch ", (Throwable)e);
            throw new ApiLti13Exception(e.getMessage(), "ERROR", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private ResponseEntity<String> launchLtiRequestViaForm(LaunchInfo launchInfo, String jwt, String oidcState) {
        StringBuilder sb1 = new StringBuilder();
        logger.info("LTI Launch JWT {}", (Object)jwt);
        String body = "<body onload=\"document.launchform.submit()\">";
        sb1.append("<!DOCTYPE html>").append(body);
        sb1.append("<form  action=\"" + launchInfo.getLaunchUri() + "\" method=\"post\" name=\"launchform\" id=\"launchform\"> ");
        HtmlTagWriter.appendHiddenField((String)"state", (String)oidcState, (StringBuilder)sb1);
        HtmlTagWriter.appendHiddenField((String)"id_token", (String)jwt, (StringBuilder)sb1);
        sb1.append("</form>");
        sb1.append("<div style=\"align-content: center;background-color=\"light-grey\">Bitte warten Sie, Sie werden zum LTI Tool weiter geleitet</div>");
        sb1.append("<div style=\"align-content: center;background-color=\"light-grey\">please wait, you will be redirected to the lti tool</div>");
        return ResponseEntity.ok((Object)sb1.toString());
    }

    public ResponseEntity<String> createLtiLaunchRequest(LaunchInfo launchInfo, HttpServletRequest request) throws ApiLti13Exception {
        try {
            String redirectUri = request.getParameter("redirect_uri");
            logger.info("LaunchInfo {}", (Object)launchInfo);
            LtiLaunchRequest ltiLaunchRequest = this.createLtiLaunchRequestDTO(launchInfo);
            StringBuilder sb = new StringBuilder();
            launchInfo.setLaunchUri(redirectUri);
            String toolId = launchInfo.getTool().getToolId();
            logger.info("Tool {} ", (Object)launchInfo.getTool());
            String jwt = this.jwtEncoderDecoder.createAndEncodeJWTForLaunchRequest((Object)ltiLaunchRequest, sb, toolId);
            logger.info("LaunchRequest is {}", (Object)ltiLaunchRequest);
            return this.launchLtiRequestViaForm(launchInfo, jwt, launchInfo.getOidcState());
        }
        catch (Exception e) {
            logger.error("Exception while creating LTI Launch ", (Throwable)e);
            throw new ApiLti13Exception(e.getMessage(), "ERROR", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Autowired
    public void setJwtEncoderDecoder(JwtEncoderDecoder jwtEncoderDecoder) {
        this.jwtEncoderDecoder = jwtEncoderDecoder;
    }

    @Autowired
    public void setLineItemsService(Lti13LineItemsService lineItemsService) {
        this.lineItemsService = lineItemsService;
    }

    @Autowired
    public void setCustomParameterService(CustomParameterService customParameterService) {
        this.customParameterService = customParameterService;
    }

    @Value(value="${platform.hosturi}")
    public void setPlatformHostUri(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Value(value="${deeplinking.acceptMultiple:true}")
    public void setDeeplinkingAcceptMutiple(boolean deeplinkingAcceptMutiple) {
        this.deeplinkingAcceptMutiple = deeplinkingAcceptMutiple;
    }
}

