/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.service.namesandroles;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.mahlsdorf.groupservice.model.node.Course;
import de.mahlsdorf.groupservice.model.node.Student;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.lti13.exception.exception.ApiLti13Exception;
import de.mahlsdorf.lti13.lti13models.model.lti.names.Lti13NamesContainer;
import de.mahlsdorf.lti13.lti13models.model.lti.names.Lti13NamesContext;
import de.mahlsdorf.lti13.lti13models.model.lti.names.Lti13NamesMember;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class NamesAndRolesService {
    private static final Logger logger = LoggerFactory.getLogger(NamesAndRolesService.class);
    private Neo4JBaseService neo4JBaseService;

    public ResponseEntity<String> getNamesAndRolesForCourse(String courseId) throws ApiLti13Exception {
        try {
            long startTime = System.currentTimeMillis();
            Lti13NamesContainer namesContainer = new Lti13NamesContainer();
            Course course = this.neo4JBaseService.findCourseById(courseId);
            namesContainer.setId(course.getCourseId());
            Lti13NamesContext namesContext = new Lti13NamesContext();
            namesContext.setId(course.getCourseId());
            namesContext.setTitle(course.getName());
            namesContext.setLabel("-");
            namesContainer.setContext(namesContext);
            List studentList = this.neo4JBaseService.getStudentForCourseViaLearningGroup(course.getCourseId());
            logger.info("found {} Members in Course {} ", (Object)studentList.size(), (Object)course.getCourseId());
            Lti13NamesMember[] namesMembers = new Lti13NamesMember[studentList.size()];
            int count = 0;
            for (Student student : studentList) {
                Lti13NamesMember namesMember = new Lti13NamesMember();
                namesMember.setUserId(student.getStudentId());
                namesMember.setName(student.getFirstName() + " " + student.getLastName());
                namesMember.setGivenName(student.getFirstName());
                namesMember.setFamilyName(student.getLastName());
                namesMember.setRoles(Collections.singletonList("http://purl.imsglobal.org/vocab/lis/v2/membership#Learner"));
                namesMember.setEmail(null);
                namesMember.setStatus("Active");
                namesMember.setLisPersonSourceId(null);
                namesMembers[count] = namesMember;
                ++count;
            }
            namesContainer.setMembers(namesMembers);
            logger.info("Getting Names and Roles took {} msec", (Object)(System.currentTimeMillis() - startTime));
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            return ResponseEntity.ok((Object)gson.toJson((Object)namesContainer));
        }
        catch (Exception e) {
            logger.error("Exception while getting NamesAnd Roles ", (Throwable)e);
            throw new ApiLti13Exception("Exception", "ERROR", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Autowired
    public void setNeo4JBaseService(Neo4JBaseService neo4JBaseService) {
        this.neo4JBaseService = neo4JBaseService;
    }
}

