/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.service.security;

import de.mahlsdorf.lti13.exception.exception.ApiLti13Exception;
import de.mahlsdorf.lti13.lti13models.model.Lti13AccessToken;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class AccessTokenStore {
    private static final Logger logger = LoggerFactory.getLogger(AccessTokenStore.class);
    public static final String ERROR_LABEL = "ERROR";
    private final Map<String, Lti13AccessToken> accessTokenMap = new HashMap();

    public void checkAccessToken(HttpServletRequest request) throws ApiLti13Exception {
        logger.trace("Works only on a singeInstance Version");
        String authHeader = request.getHeader("Authorization");
        if (StringUtils.isEmpty((CharSequence)authHeader)) {
            logger.warn("No Authheader '{}' found ", (Object)"Authorization");
            throw new ApiLti13Exception("AuthHeader not found ", ERROR_LABEL, HttpStatus.UNAUTHORIZED);
        }
        logger.info("AuthHeader '{}'", (Object)authHeader);
        String accessTokenKey = authHeader.replace("Bearer ", "");
        accessTokenKey = accessTokenKey.trim();
        if (!this.accessTokenMap.containsKey(accessTokenKey)) {
            logger.warn("Acccesstoken {} not found ", (Object)accessTokenKey);
            throw new ApiLti13Exception("Accesstoken not found ", ERROR_LABEL, HttpStatus.UNAUTHORIZED);
        }
        Lti13AccessToken accessToken = (Lti13AccessToken)this.accessTokenMap.get(accessTokenKey);
        long calulatedValidUnil = accessToken.getValidUntil() * 1000L;
        if (System.currentTimeMillis() > calulatedValidUnil) {
            logger.warn("Accesstoken {} is not longer valid System.now {} validUntil {} validUntil as Date {} ", new Object[]{accessToken.getAccessTokenAsString(), System.currentTimeMillis(), calulatedValidUnil, new Date(calulatedValidUnil)});
            this.accessTokenMap.remove(accessTokenKey);
            logger.debug("Accesstoken {} removed From Accestoken Map ", (Object)accessTokenKey);
            throw new ApiLti13Exception("Accesstoken not found ", ERROR_LABEL, HttpStatus.UNAUTHORIZED);
        }
        logger.error("###################### IMPLEMENT SCOPE");
    }

    public void putAccessToken(Lti13AccessToken accessToken) {
        this.accessTokenMap.put(accessToken.getAccessTokenAsString(), accessToken);
    }
}

